/*
 * Decompiled with CFR 0.152.
 */
package com.teketik.test.mockinbean;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class BeanUtils {
    private BeanUtils() {
    }

    public static <T> T findBean(Class<T> type, @Nullable String name, ApplicationContext applicationContext) {
        Object beanOrProxy;
        Map beansOfType = applicationContext.getBeansOfType(type);
        Assert.isTrue((!beansOfType.isEmpty() ? 1 : 0) != 0, () -> "No beans of type " + type);
        if (beansOfType.size() == 1) {
            beanOrProxy = beansOfType.values().iterator().next();
        } else {
            Assert.notNull((Object)name, () -> "Multiple beans of type " + type + ". A name must be provided");
            beanOrProxy = beansOfType.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(name)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException("No beans of type " + type + " and name " + name));
        }
        return (T)(AopUtils.isAopProxy(beanOrProxy) ? AopProxyUtils.getSingletonTarget(beanOrProxy) : beanOrProxy);
    }

    public static Field findField(Class<?> clazz, @Nullable String name, Class<?> type) {
        Object[] results = new Object[2];
        ReflectionUtils.doWithFields(clazz, field -> {
            if (name != null && field.getName().equalsIgnoreCase(name)) {
                results[0] = results[0] == null ? field : Boolean.FALSE;
            }
            results[1] = results[1] == null ? field : Boolean.FALSE;
        }, field -> field.getType().equals(type));
        if (results[0] != null) {
            Assert.isTrue((!(results[0] instanceof Boolean) ? 1 : 0) != 0, () -> "Multiple fields of type " + type + " in " + clazz + " with name " + name);
            return (Field)results[0];
        }
        if (results[1] != null) {
            Assert.isTrue((!(results[1] instanceof Boolean) ? 1 : 0) != 0, () -> "Multiple fields of type " + type + " in " + clazz + (name != null ? " and none with name " + name : ". Please specify a name."));
            return (Field)results[1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T addToContextIfMissing(String beanName, Supplier<T> supplier, ApplicationContext applicationContext) {
        Object object;
        ApplicationContext applicationContext2 = applicationContext;
        synchronized (applicationContext2) {
            if (applicationContext.containsBean(beanName)) {
                object = applicationContext.getBean(beanName);
            } else {
                ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
                object = supplier.get();
                beanFactory.registerSingleton(beanName, object);
            }
        }
        return (T)object;
    }
}

