/*
 * Decompiled with CFR 0.152.
 */
package com.teketik.test.mockinbean;

import com.teketik.test.mockinbean.BeanUtils;
import com.teketik.test.mockinbean.Definition;
import com.teketik.test.mockinbean.InBeanDefinition;
import com.teketik.test.mockinbean.InBeanDefinitionsParser;
import com.teketik.test.mockinbean.MapUtils;
import com.teketik.test.mockinbean.MockInBeanTracker;
import com.teketik.test.mockinbean.TestProcessingPayload;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.ReflectionUtils;

class MockInBeanTestContextManager {
    private static final String MOCK_IN_BEAN_TEST_CONTEXT = "MockInBeanTestContext";

    private MockInBeanTestContextManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context prepareOnce(TestContext testContext) {
        TestContext testContext2 = testContext;
        synchronized (testContext2) {
            Object attribute = testContext.getAttribute(MOCK_IN_BEAN_TEST_CONTEXT);
            if (attribute == null) {
                attribute = new Context.Builder(testContext).build();
                testContext.setAttribute(MOCK_IN_BEAN_TEST_CONTEXT, attribute);
            }
            return (Context)attribute;
        }
    }

    static class Context {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final Collection<TestProcessingPayload> testProcessingPayloads;
        private final MockInBeanTracker tracker;

        private Context(Collection<TestProcessingPayload> testProcessingPayloads, MockInBeanTracker tracker) {
            this.testProcessingPayloads = testProcessingPayloads;
            this.tracker = tracker;
        }

        Collection<TestProcessingPayload> getTestProcessingPayloads() {
            return this.testProcessingPayloads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wireMock(TestProcessingPayload testProcessingPayload, Object mockOrSpy) {
            Object object = testProcessingPayload.originalBean;
            synchronized (object) {
                this.inject(testProcessingPayload.beansFieldsToInject, this.tracker.proxyTracker.getByBean(testProcessingPayload.originalBean));
                this.tracker.mockTracker.track(testProcessingPayload.originalBean, mockOrSpy);
                this.logger.debug((Object)("Tracking mock " + mockOrSpy + " for bean " + testProcessingPayload.originalBean));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unwireMock(TestProcessingPayload testProcessingPayload) {
            Object object = testProcessingPayload.originalBean;
            synchronized (object) {
                this.logger.debug((Object)("Untracking mock for bean " + testProcessingPayload.originalBean));
                if (this.tracker.mockTracker.untrack(testProcessingPayload.originalBean)) {
                    this.logger.debug((Object)("No more mocks for " + testProcessingPayload.originalBean + ". Rollbacking proxy"));
                    this.inject(testProcessingPayload.beansFieldsToInject, testProcessingPayload.originalBean);
                }
            }
        }

        private void inject(LinkedMultiValueMap<Field, Object> beansFieldsToInject, Object toInject) {
            for (Map.Entry fieldToBeans : beansFieldsToInject.entrySet()) {
                for (Object bean : (List)fieldToBeans.getValue()) {
                    this.inject((Field)fieldToBeans.getKey(), bean, toInject);
                    this.tracker.mockTracker.getTracked(bean).ifPresent(mockOrSpy -> this.inject((Field)fieldToBeans.getKey(), mockOrSpy, toInject));
                }
            }
        }

        private void inject(Field field, Object inObject, Object toInject) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting " + toInject.getClass() + " in " + field + " of " + inObject.getClass()));
            }
            ReflectionUtils.setField((Field)field, (Object)inObject, (Object)toInject);
        }

        private static class Builder {
            private final Log logger = LogFactory.getLog(this.getClass());
            private final TestContext testContext;
            private final ApplicationContext applicationContext;
            private final Map<Object, Set<Field>> alreadyProxiedFields = new IdentityHashMap<Object, Set<Field>>();
            private final LinkedList<TestProcessingPayload> testProcessingPayloads = new LinkedList();
            private final MockInBeanTracker tracker;

            private Builder(TestContext testContext) {
                this.testContext = testContext;
                InBeanDefinitionsParser parser = new InBeanDefinitionsParser();
                parser.parse(testContext.getTestClass());
                this.applicationContext = testContext.getApplicationContext();
                this.tracker = BeanUtils.addToContextIfMissing("mockInBeanTracker", () -> new MockInBeanTracker(), this.applicationContext);
                for (Map.Entry<Definition, List<InBeanDefinition>> definitionToInbeans : parser.getDefinitions().entrySet()) {
                    TestProcessingPayload testProcessingPayload = this.processDefinitions(definitionToInbeans.getKey(), definitionToInbeans.getValue());
                    this.logger.debug((Object)("Resolved " + testProcessingPayload));
                    this.testProcessingPayloads.add(testProcessingPayload);
                }
            }

            private TestProcessingPayload processDefinitions(Definition definition, List<InBeanDefinition> inBeanDefinitions) {
                Class<?> mockOrSpyType = this.extractClass(definition);
                LinkedMultiValueMap beanFieldsToInject = new LinkedMultiValueMap();
                Object proxy = null;
                for (InBeanDefinition inBeanDefinition : inBeanDefinitions) {
                    Object inBean = BeanUtils.findBean(inBeanDefinition.clazz, inBeanDefinition.name, this.applicationContext);
                    Field inBeanDefinitionField = BeanUtils.findField(inBean.getClass(), definition.getName(), mockOrSpyType);
                    Assert.notNull((Object)inBeanDefinitionField, () -> "Cannot find bean to mock " + mockOrSpyType + " in " + inBeanDefinition.clazz);
                    inBeanDefinitionField.setAccessible(true);
                    Object originalFieldValueInBean = ReflectionUtils.getField((Field)inBeanDefinitionField, inBean);
                    Object proxyForFieldValue = this.tracker.setupProxyIfNotExisting(originalFieldValueInBean);
                    Assert.isTrue((proxy == null || proxy == proxyForFieldValue ? 1 : 0) != 0, () -> "Resolved invalid target beans for definition " + definition + " in " + inBeanDefinition);
                    proxy = proxyForFieldValue;
                    beanFieldsToInject.add((Object)inBeanDefinitionField, inBean);
                    Assert.isTrue((boolean)MapUtils.getOrPut(this.alreadyProxiedFields, inBean, () -> new HashSet()).add(inBeanDefinitionField), () -> inBeanDefinitionField + " can only be mapped once, as a mock or a spy, not both!");
                }
                Field testField = ReflectionUtils.findField((Class)this.testContext.getTestClass(), (String)definition.getName(), mockOrSpyType);
                testField.setAccessible(true);
                return new TestProcessingPayload(definition, (LinkedMultiValueMap<Field, Object>)beanFieldsToInject, testField, this.tracker.proxyTracker.getBeanByProxy(proxy));
            }

            private Class<?> extractClass(Definition definition) {
                Type type = definition.getResolvableType().getType();
                if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                return (Class)type;
            }

            public Context build() {
                return new Context(Collections.unmodifiableCollection(this.testProcessingPayloads), this.tracker);
            }
        }
    }
}

