/*
 * Decompiled with CFR 0.152.
 */
package com.teketik.test.mockinbean;

import com.teketik.test.mockinbean.MockInBeanTestContextManager;
import com.teketik.test.mockinbean.TestProcessingPayload;
import java.lang.reflect.Field;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ReflectionUtils;

class MockInBeanTestExecutionListener
extends AbstractTestExecutionListener {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    MockInBeanTestExecutionListener() {
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        MockInBeanTestContextManager.Context context = MockInBeanTestContextManager.prepareOnce(testContext);
        context.getTestProcessingPayloads().forEach(testProcessingPayload -> {
            Object mockOrSpy = testProcessingPayload.definition.create(testProcessingPayload.originalBean);
            this.logger.debug((Object)("Injecting mock " + mockOrSpy + " in test field " + testProcessingPayload.testField));
            ReflectionUtils.setField((Field)testProcessingPayload.testField, (Object)testContext.getTestInstance(), mockOrSpy);
            context.wireMock((TestProcessingPayload)testProcessingPayload, mockOrSpy);
        });
        super.beforeTestMethod(testContext);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        MockInBeanTestContextManager.Context context = MockInBeanTestContextManager.prepareOnce(testContext);
        Optional.ofNullable(context.getTestProcessingPayloads()).ifPresent(testProcessingPayloads -> {
            for (TestProcessingPayload testProcessingPayload : testProcessingPayloads) {
                context.unwireMock(testProcessingPayload);
            }
        });
        super.afterTestMethod(testContext);
    }

    public int getOrder() {
        return 10000;
    }
}

