/*
 * Decompiled with CFR 0.152.
 */
package com.teketik.test.mockinbean;

import com.teketik.test.mockinbean.MapUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cglib.core.DefaultNamingPolicy;
import org.springframework.cglib.core.NamingPolicy;
import org.springframework.cglib.core.Predicate;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

class MockInBeanTracker {
    private static final NamingPolicy ENHANCER_NAMING_POLICY = new DefaultNamingPolicy(){

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return super.getClassName(prefix, source + "MockInBean", key, names);
        }
    };
    private final Log logger = LogFactory.getLog(this.getClass());
    final MockTracker mockTracker = new MockTracker();
    final ProxyTracker proxyTracker = new ProxyTracker();

    MockInBeanTracker() {
    }

    static boolean isProxy(Object o) {
        return o.getClass().toString().contains("$$EnhancerMockInBeanByCGLIB$$");
    }

    public Object setupProxyIfNotExisting(Object beanOrProxy) {
        if (MockInBeanTracker.isProxy(beanOrProxy)) {
            return beanOrProxy;
        }
        return this.proxyTracker.getByBeanOrMake(beanOrProxy, () -> {
            this.logger.debug((Object)("Creating proxy of bean " + beanOrProxy));
            return this.makeProxy(beanOrProxy);
        });
    }

    private Object makeProxy(final Object originalBean) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(originalBean.getClass());
        enhancer.setCallback((Callback)new MethodInterceptor(){

            public Object intercept(Object object, Method method, Object[] parameters, MethodProxy methodProxy) throws Throwable {
                Object target = this.resolveInvocationTarget(originalBean);
                return method.invoke(target, parameters);
            }

            private Object resolveInvocationTarget(Object originalBean2) {
                Optional<Object> trackedMock = MockInBeanTracker.this.mockTracker.getTracked(originalBean2);
                if (trackedMock.isPresent()) {
                    MockInBeanTracker.this.logger.debug((Object)("Resolved mock from thread local for class " + originalBean2));
                    return trackedMock.get();
                }
                MockInBeanTracker.this.logger.debug((Object)("No mock in thread local, using original " + originalBean2));
                return originalBean2;
            }
        });
        enhancer.setNamingPolicy(ENHANCER_NAMING_POLICY);
        return enhancer.create();
    }

    static final class ProxyTracker {
        private final Map<Object, Object> proxyToBean = new IdentityHashMap<Object, Object>();
        private final Map<Object, Object> beanToProxy = new IdentityHashMap<Object, Object>();

        ProxyTracker() {
        }

        synchronized Object getByBean(Object bean) {
            return this.beanToProxy.get(bean);
        }

        synchronized Object getByBeanOrMake(Object bean, Supplier<Object> proxyMaker) {
            return Optional.ofNullable(this.beanToProxy.get(bean)).orElseGet(() -> {
                Object proxy = proxyMaker.get();
                this.proxyToBean.put(proxy, bean);
                this.beanToProxy.put(bean, proxy);
                return proxy;
            });
        }

        synchronized Object getBeanByProxy(Object proxy) {
            return this.proxyToBean.get(proxy);
        }
    }

    static final class MockTracker {
        private final Map<Object, Map<Thread, Object>> beanToMockThreadLocal = new IdentityHashMap<Object, Map<Thread, Object>>();

        MockTracker() {
        }

        synchronized void track(Object bean, Object mockOrSpy) {
            MapUtils.getOrPut(this.beanToMockThreadLocal, bean, () -> new HashMap()).put(Thread.currentThread(), mockOrSpy);
        }

        synchronized boolean untrack(Object bean) {
            return Optional.ofNullable(this.beanToMockThreadLocal.get(bean)).map(threadLocal -> {
                threadLocal.remove(Thread.currentThread());
                return threadLocal.isEmpty();
            }).orElse(false);
        }

        synchronized Optional<Object> getTracked(Object bean) {
            return Optional.ofNullable(this.beanToMockThreadLocal.get(bean)).flatMap(threadToMock -> {
                if (threadToMock.size() == 1) {
                    return Optional.of(threadToMock.values().iterator().next());
                }
                return Optional.ofNullable(threadToMock.get(Thread.currentThread()));
            });
        }
    }
}

