/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose;

import com.fluxtion.agrona.ErrorHandler;
import com.fluxtion.agrona.concurrent.Agent;
import com.fluxtion.agrona.concurrent.AgentRunner;
import com.fluxtion.agrona.concurrent.AtomicBuffer;
import com.fluxtion.agrona.concurrent.DynamicCompositeAgent;
import com.fluxtion.agrona.concurrent.IdleStrategy;
import com.fluxtion.agrona.concurrent.UnsafeBuffer;
import com.fluxtion.agrona.concurrent.status.AtomicCounter;
import com.fluxtion.runtime.StaticEventProcessor;
import com.fluxtion.runtime.annotations.runtime.ServiceRegistered;
import com.fluxtion.runtime.audit.LogRecordListener;
import com.fluxtion.runtime.service.Service;
import com.fluxtion.runtime.service.ServiceRegistryNode;
import com.telamin.mongoose.config.MongooseServerConfig;
import com.telamin.mongoose.config.ThreadConfig;
import com.telamin.mongoose.dispatch.EventFlowManager;
import com.telamin.mongoose.dutycycle.ComposingEventProcessorAgent;
import com.telamin.mongoose.dutycycle.ComposingServiceAgent;
import com.telamin.mongoose.dutycycle.NamedEventProcessor;
import com.telamin.mongoose.dutycycle.ServiceAgent;
import com.telamin.mongoose.exception.ServiceRegistrationException;
import com.telamin.mongoose.internal.ComposingEventProcessorAgentRunner;
import com.telamin.mongoose.internal.ComposingWorkerServiceAgentRunner;
import com.telamin.mongoose.internal.LifecycleManager;
import com.telamin.mongoose.internal.ServerConfigurator;
import com.telamin.mongoose.internal.ServiceInjector;
import com.telamin.mongoose.service.CallBackType;
import com.telamin.mongoose.service.EventFlowService;
import com.telamin.mongoose.service.EventSource;
import com.telamin.mongoose.service.EventToInvokeStrategy;
import com.telamin.mongoose.service.admin.AdminCommandRegistry;
import com.telamin.mongoose.service.scheduler.DeadWheelScheduler;
import com.telamin.mongoose.service.servercontrol.MongooseServerController;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import lombok.Generated;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;

public class MongooseServer
implements MongooseServerController {
    @Generated
    private static final Logger log = Logger.getLogger(MongooseServer.class.getName());
    public static final String CONFIG_FILE_PROPERTY = "mongooseServer.config.file";
    private static LogRecordListener logRecordListener = logRecord -> log.info(logRecord.toString());
    private final MongooseServerConfig mongooseServerConfig;
    private final EventFlowManager flowManager = new EventFlowManager();
    private final ConcurrentHashMap<String, ComposingEventProcessorAgentRunner> composingEventProcessorAgents = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ComposingWorkerServiceAgentRunner> composingServiceAgents = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Service<?>> registeredServices = new ConcurrentHashMap();
    private final Set<Service<?>> registeredAgentServices = ConcurrentHashMap.newKeySet();
    private ErrorHandler errorHandler = m -> log.severe(m.getMessage());
    private final ServiceRegistryNode serviceRegistry = new ServiceRegistryNode();
    private volatile boolean started = false;
    private final LifecycleManager lifecycleManager = new LifecycleManager(this);

    public static void main(String[] args) {
        log.info("starting server from MongooseServer.main() with args:" + Arrays.toString(args));
        MongooseServer.bootServer();
    }

    public MongooseServer(MongooseServerConfig mongooseServerConfig) {
        this.mongooseServerConfig = mongooseServerConfig;
    }

    public static MongooseServer bootServer(Reader reader, LogRecordListener logRecordListener) {
        log.info("booting server loading config from reader");
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setTagInspector(tag -> true);
        Yaml yaml = new Yaml(loaderOptions);
        MongooseServerConfig mongooseServerConfig = (MongooseServerConfig)yaml.loadAs(reader, MongooseServerConfig.class);
        log.info("successfully loaded config from reader");
        return MongooseServer.bootServer(mongooseServerConfig, logRecordListener);
    }

    public static MongooseServer bootServer(Reader reader) {
        return MongooseServer.bootServer(reader, logRecordListener);
    }

    public static MongooseServer bootServer(LogRecordListener logRecordListener) {
        MongooseServer mongooseServer;
        String configFileName = System.getProperty(CONFIG_FILE_PROPERTY);
        Objects.requireNonNull(configFileName, "fluxtion config file must be specified by system property: mongooseServer.config.file");
        File configFile = new File(configFileName);
        log.info("booting fluxtion server with config file:" + String.valueOf(configFile) + " specified by system property:mongooseServer.config.file");
        try (FileReader reader = new FileReader(configFileName);){
            mongooseServer = MongooseServer.bootServer(reader, logRecordListener);
        }
        return mongooseServer;
    }

    public static MongooseServer bootServer() {
        return MongooseServer.bootServer(logRecordListener);
    }

    public static MongooseServer bootServer(MongooseServerConfig mongooseServerConfig, LogRecordListener logRecordListener) {
        MongooseServer.logRecordListener = logRecordListener;
        log.info("booting fluxtion server");
        log.fine("config:" + String.valueOf(mongooseServerConfig));
        return ServerConfigurator.bootFromConfig(mongooseServerConfig, logRecordListener);
    }

    public static MongooseServer bootServer(MongooseServerConfig mongooseServerConfig) {
        return MongooseServer.bootServer(mongooseServerConfig, logRecordListener);
    }

    public void setDefaultErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void registerEventMapperFactory(Supplier<EventToInvokeStrategy> eventMapper, CallBackType type) {
        log.info("registerEventMapperFactory:" + String.valueOf(eventMapper));
        this.flowManager.registerEventMapperFactory(eventMapper, type);
    }

    public void registerEventFeed(Service<?> services, Function<?, ?> dataMapper) {
        ServiceInjector.inject(dataMapper, this.registeredServices.values());
        this.registerService(services);
    }

    public void registerEventFeedWorker(ServiceAgent<?> services, Function<?, ?> dataMapper) {
        ServiceInjector.inject(dataMapper, this.registeredServices.values());
        this.registerWorkerService(services);
    }

    public <T> void registerEventSource(String sourceName, EventSource<T> eventSource) {
        this.registerEventSource(sourceName, eventSource, null);
    }

    public <T> void registerEventSource(String sourceName, EventSource<T> eventSource, Function<T, ?> dataMapper) {
        log.info("registerEventSource name:" + sourceName + " eventSource:" + String.valueOf(eventSource));
        Service service = new Service(eventSource, sourceName);
        ServiceInjector.inject(dataMapper, this.registeredServices.values());
        this.registerService(service);
    }

    public void registerEventSink(Service<?> services, Function<?, ?> dataMapper) {
        ServiceInjector.inject(dataMapper, this.registeredServices.values());
        this.registerService(services);
    }

    public void registerEventSinkWorker(ServiceAgent<?> services, Function<?, ?> dataMapper) {
        ServiceInjector.inject(dataMapper, this.registeredServices.values());
        this.registerWorkerService(services);
    }

    public void registerService(Service<?> ... services) {
        for (Service<?> service : services) {
            String serviceName = service.serviceName();
            log.info("registerService:" + String.valueOf(service));
            if (this.registeredServices.containsKey(serviceName)) {
                throw new ServiceRegistrationException("cannot register service name is already assigned:" + serviceName);
            }
            this.registeredServices.put(serviceName, service);
            Object instance = service.instance();
            if (instance instanceof EventFlowService) {
                ((EventFlowService)instance).setEventFlowManager(this.flowManager, serviceName);
            }
            ServiceInjector.inject(instance, this.registeredServices.values());
            for (Service<?> existing : this.registeredServices.values()) {
                Object existingInstance = existing.instance();
                if (existingInstance == instance) continue;
                ServiceInjector.inject(existingInstance, Collections.singleton(service));
            }
        }
    }

    public void registerAgentService(Service<?> ... services) {
        this.registerService(services);
        this.registeredAgentServices.addAll(Arrays.asList(services));
    }

    public void registerWorkerService(ServiceAgent<?> service) {
        String agentGroup = service.agentGroup();
        IdleStrategy idleStrategy = this.mongooseServerConfig.lookupIdleStrategyWhenNull(service.idleStrategy(), service.agentGroup());
        log.info("registerWorkerService:" + String.valueOf(service) + " agentGroup:" + agentGroup + " idleStrategy:" + String.valueOf(idleStrategy));
        ComposingWorkerServiceAgentRunner composingAgentRunner = this.composingServiceAgents.computeIfAbsent(agentGroup, ket -> {
            ComposingServiceAgent group = new ComposingServiceAgent(agentGroup, this.flowManager, this, new DeadWheelScheduler());
            AtomicCounter errorCounter = new AtomicCounter((AtomicBuffer)new UnsafeBuffer(new byte[4096]), 0);
            AgentRunner groupRunner = new AgentRunner(idleStrategy, this.errorHandler, errorCounter, (Agent)group);
            return new ComposingWorkerServiceAgentRunner(group, groupRunner);
        });
        composingAgentRunner.group().registerServer(service);
    }

    @Override
    public void addEventProcessor(String processorName, String groupName, IdleStrategy idleStrategy, Supplier<StaticEventProcessor> feedConsumer) throws IllegalArgumentException {
        IdleStrategy idleStrategyOverride = this.mongooseServerConfig.getIdleStrategyOrDefault(groupName, idleStrategy);
        ComposingEventProcessorAgentRunner composingEventProcessorAgentRunner = this.composingEventProcessorAgents.computeIfAbsent(groupName, ket -> {
            ComposingEventProcessorAgent group = new ComposingEventProcessorAgent(groupName, this.flowManager, this, new DeadWheelScheduler(), this.registeredServices);
            AtomicCounter errorCounter = new AtomicCounter((AtomicBuffer)new UnsafeBuffer(new byte[4096]), 0);
            AgentRunner groupRunner = new AgentRunner(idleStrategyOverride, this.errorHandler, errorCounter, (Agent)group);
            return new ComposingEventProcessorAgentRunner(group, groupRunner);
        });
        if (composingEventProcessorAgentRunner.group().isProcessorRegistered(processorName)) {
            throw new IllegalArgumentException("cannot add event processor name is already assigned:" + processorName);
        }
        composingEventProcessorAgentRunner.group().addNamedEventProcessor(() -> {
            StaticEventProcessor eventProcessor = (StaticEventProcessor)feedConsumer.get();
            eventProcessor.setAuditLogProcessor(logRecordListener);
            if (this.started) {
                log.info("init event processor in already started server processor:'" + String.valueOf(eventProcessor) + "'");
            }
            return new NamedEventProcessor(processorName, eventProcessor);
        });
        if (this.started && composingEventProcessorAgentRunner.groupRunner().thread() == null) {
            log.info("staring event processor group:'" + groupName + "' for running server");
            AgentRunner.startOnThread((AgentRunner)composingEventProcessorAgentRunner.groupRunner());
        }
    }

    @Override
    public Map<String, Collection<NamedEventProcessor>> registeredProcessors() {
        HashMap<String, Collection<NamedEventProcessor>> result = new HashMap<String, Collection<NamedEventProcessor>>();
        this.composingEventProcessorAgents.entrySet().forEach(entry -> result.put((String)entry.getKey(), ((ComposingEventProcessorAgentRunner)entry.getValue()).group().registeredEventProcessors()));
        return result;
    }

    @Override
    public void stopProcessor(String groupName, String processorName) {
        log.info("stopProcessor:" + processorName + " in group:" + groupName);
        ComposingEventProcessorAgentRunner processorAgent = this.composingEventProcessorAgents.get(groupName);
        if (processorAgent != null) {
            processorAgent.group().removeEventProcessorByName(processorName);
        }
    }

    @Override
    public void startService(String serviceName) {
        log.info("start service:" + serviceName);
        if (this.registeredServices.containsKey(serviceName)) {
            this.registeredServices.get(serviceName).start();
        }
    }

    @Override
    public void stopService(String serviceName) {
        log.info("stop service:" + serviceName);
        if (this.registeredServices.containsKey(serviceName)) {
            this.registeredServices.get(serviceName).stop();
        }
    }

    @Override
    public Map<String, Service<?>> registeredServices() {
        return this.registeredServices;
    }

    public void init() {
        this.lifecycleManager.init(this.registeredServices, this.registeredAgentServices, this.flowManager, this.serviceRegistry);
    }

    public void start() {
        ConcurrentHashMap serviceGroups = new ConcurrentHashMap();
        this.composingServiceAgents.forEach((k, v) -> serviceGroups.put(k, new LifecycleManager.GroupRunner(){
            final /* synthetic */ ComposingWorkerServiceAgentRunner val$v;
            {
                this.val$v = composingWorkerServiceAgentRunner;
            }

            @Override
            public AgentRunner getGroupRunner() {
                return this.val$v.groupRunner();
            }

            @Override
            public DynamicCompositeAgent getGroup() {
                return this.val$v.group();
            }

            @Override
            public void startCompleteIfSupported() {
                this.val$v.group().startComplete();
            }
        }));
        ConcurrentHashMap processorGroups = new ConcurrentHashMap();
        this.composingEventProcessorAgents.forEach((k, v) -> processorGroups.put(k, new LifecycleManager.GroupRunner(){
            final /* synthetic */ ComposingEventProcessorAgentRunner val$v;
            {
                this.val$v = composingEventProcessorAgentRunner;
            }

            @Override
            public AgentRunner getGroupRunner() {
                return this.val$v.groupRunner();
            }

            @Override
            public DynamicCompositeAgent getGroup() {
                return this.val$v.group();
            }
        }));
        this.lifecycleManager.start(this.registeredServices, serviceGroups, processorGroups, this.flowManager, this.registeredAgentServices);
        this.started = true;
    }

    public Collection<Service<?>> servicesRegistered() {
        return Collections.unmodifiableCollection(this.registeredServices.values());
    }

    public Integer resolveCoreIdForAgentName(String agentName) {
        if (this.mongooseServerConfig == null || this.mongooseServerConfig.getAgentThreads() == null) {
            return null;
        }
        return this.mongooseServerConfig.getAgentThreads().stream().filter(t -> agentName != null && agentName.equals(t.getAgentName())).map(ThreadConfig::getCoreId).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void stop() {
        this.lifecycleManager.stop(this.started, this.toGroupRunnerMap(this.composingEventProcessorAgents), this.toGroupRunnerMap(this.composingServiceAgents), this.registeredServices);
        this.started = false;
    }

    private ConcurrentHashMap<String, LifecycleManager.GroupRunner> toGroupRunnerMap(ConcurrentHashMap<String, ? extends Object> source) {
        ConcurrentHashMap<String, LifecycleManager.GroupRunner> map = new ConcurrentHashMap<String, LifecycleManager.GroupRunner>();
        source.forEach((k, v) -> {
            if (v instanceof ComposingEventProcessorAgentRunner) {
                final ComposingEventProcessorAgentRunner cep = (ComposingEventProcessorAgentRunner)v;
                map.put((String)k, new LifecycleManager.GroupRunner(){

                    @Override
                    public AgentRunner getGroupRunner() {
                        return cep.groupRunner();
                    }

                    @Override
                    public DynamicCompositeAgent getGroup() {
                        return cep.group();
                    }
                });
            } else if (v instanceof ComposingWorkerServiceAgentRunner) {
                final ComposingWorkerServiceAgentRunner cws = (ComposingWorkerServiceAgentRunner)v;
                map.put((String)k, new LifecycleManager.GroupRunner(){

                    @Override
                    public AgentRunner getGroupRunner() {
                        return cws.groupRunner();
                    }

                    @Override
                    public DynamicCompositeAgent getGroup() {
                        return cws.group();
                    }

                    @Override
                    public void startCompleteIfSupported() {
                        cws.group().startComplete();
                    }
                });
            }
        });
        return map;
    }

    @ServiceRegistered
    public void adminClient(AdminCommandRegistry adminCommandRegistry, String name) {
        log.info("adminCommandRegistry registered:" + name);
    }
}

