/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.config;

import java.util.Objects;

public final class ConfigKey<T> {
    private final String name;
    private final Class<T> type;

    private ConfigKey(String name, Class<T> type) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
    }

    public static <T> ConfigKey<T> of(String name, Class<T> type) {
        return new ConfigKey<T>(name, type);
    }

    public String name() {
        return this.name;
    }

    public Class<T> type() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigKey)) {
            return false;
        }
        ConfigKey that = (ConfigKey)o;
        return this.name.equals(that.name) && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return "ConfigKey{" + this.name + ":" + this.type.getSimpleName() + "}";
    }
}

