/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.config;

import com.fluxtion.runtime.EventProcessor;
import com.fluxtion.runtime.audit.EventLogControlEvent;
import com.fluxtion.runtime.node.ObjectEventHandlerNode;
import com.telamin.mongoose.MongooseEventHandler;
import com.telamin.mongoose.config.ConfigMap;
import com.telamin.mongoose.internal.ConfigAwareEventProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;

public class EventProcessorConfig<T extends EventProcessor<?>> {
    private T eventHandler;
    private String name;
    private ObjectEventHandlerNode customHandler;
    private Supplier<T> eventHandlerBuilder;
    private EventLogControlEvent.LogLevel logLevel;
    private Map<String, Object> configMap = new HashMap<String, Object>();

    public EventProcessorConfig(ObjectEventHandlerNode customHandler) {
        this.customHandler = customHandler;
    }

    public EventProcessorConfig() {
        this.configMap = new HashMap<String, Object>();
    }

    public T getEventHandler() {
        if (this.eventHandler == null && this.customHandler != null) {
            ConfigAwareEventProcessor wrappingProcessor = new ConfigAwareEventProcessor(this.customHandler);
            this.eventHandler = wrappingProcessor;
        }
        return this.eventHandler;
    }

    public ConfigMap getConfig() {
        return new ConfigMap(this.getConfigMap());
    }

    public static <T extends EventProcessor<?>> Builder<T> builder() {
        return new Builder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ObjectEventHandlerNode getCustomHandler() {
        return this.customHandler;
    }

    @Generated
    public Supplier<T> getEventHandlerBuilder() {
        return this.eventHandlerBuilder;
    }

    @Generated
    public EventLogControlEvent.LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public Map<String, Object> getConfigMap() {
        return this.configMap;
    }

    @Generated
    public void setEventHandler(T eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCustomHandler(ObjectEventHandlerNode customHandler) {
        this.customHandler = customHandler;
    }

    @Generated
    public void setEventHandlerBuilder(Supplier<T> eventHandlerBuilder) {
        this.eventHandlerBuilder = eventHandlerBuilder;
    }

    @Generated
    public void setLogLevel(EventLogControlEvent.LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Generated
    public void setConfigMap(Map<String, Object> configMap) {
        this.configMap = configMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventProcessorConfig)) {
            return false;
        }
        EventProcessorConfig other = (EventProcessorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$eventHandler = this.getEventHandler();
        T other$eventHandler = other.getEventHandler();
        if (this$eventHandler == null ? other$eventHandler != null : !this$eventHandler.equals(other$eventHandler)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ObjectEventHandlerNode this$customHandler = this.getCustomHandler();
        ObjectEventHandlerNode other$customHandler = other.getCustomHandler();
        if (this$customHandler == null ? other$customHandler != null : !this$customHandler.equals(other$customHandler)) {
            return false;
        }
        Supplier<T> this$eventHandlerBuilder = this.getEventHandlerBuilder();
        Supplier<T> other$eventHandlerBuilder = other.getEventHandlerBuilder();
        if (this$eventHandlerBuilder == null ? other$eventHandlerBuilder != null : !this$eventHandlerBuilder.equals(other$eventHandlerBuilder)) {
            return false;
        }
        EventLogControlEvent.LogLevel this$logLevel = this.getLogLevel();
        EventLogControlEvent.LogLevel other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        Map<String, Object> this$configMap = this.getConfigMap();
        Map<String, Object> other$configMap = other.getConfigMap();
        return !(this$configMap == null ? other$configMap != null : !((Object)this$configMap).equals(other$configMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventProcessorConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $eventHandler = this.getEventHandler();
        result = result * 59 + ($eventHandler == null ? 43 : $eventHandler.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ObjectEventHandlerNode $customHandler = this.getCustomHandler();
        result = result * 59 + ($customHandler == null ? 43 : $customHandler.hashCode());
        Supplier<T> $eventHandlerBuilder = this.getEventHandlerBuilder();
        result = result * 59 + ($eventHandlerBuilder == null ? 43 : $eventHandlerBuilder.hashCode());
        EventLogControlEvent.LogLevel $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        Map<String, Object> $configMap = this.getConfigMap();
        result = result * 59 + ($configMap == null ? 43 : ((Object)$configMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EventProcessorConfig(eventHandler=" + String.valueOf(this.getEventHandler()) + ", name=" + this.getName() + ", customHandler=" + String.valueOf(this.getCustomHandler()) + ", eventHandlerBuilder=" + String.valueOf(this.getEventHandlerBuilder()) + ", logLevel=" + String.valueOf(this.getLogLevel()) + ", configMap=" + String.valueOf(this.getConfigMap()) + ")";
    }

    public static final class Builder<T extends EventProcessor<?>> {
        private T eventHandler;
        private String name;
        private ObjectEventHandlerNode customHandler;
        private Supplier<T> eventHandlerBuilder;
        private EventLogControlEvent.LogLevel logLevel;
        private final Map<String, Object> config = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder<T> handler(T handler) {
            this.eventHandler = handler;
            return this;
        }

        public Builder<T> handlerFunction(Consumer<Object> handlerFunction) {
            return this.handler(new MongooseEventHandler(handlerFunction));
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> customHandler(ObjectEventHandlerNode node) {
            this.customHandler = node;
            return this;
        }

        public Builder<T> handlerBuilder(Supplier<T> builder) {
            this.eventHandlerBuilder = builder;
            return this;
        }

        public Builder<T> logLevel(EventLogControlEvent.LogLevel level) {
            this.logLevel = level;
            return this;
        }

        public Builder<T> putConfig(String key, Object value) {
            this.config.put(key, value);
            return this;
        }

        public EventProcessorConfig<T> build() {
            EventProcessorConfig<T> cfg = new EventProcessorConfig<T>();
            cfg.setEventHandler(this.eventHandler);
            cfg.setName(this.name);
            cfg.setCustomHandler(this.customHandler);
            cfg.setEventHandlerBuilder(this.eventHandlerBuilder);
            cfg.setLogLevel(this.logLevel);
            cfg.getConfigMap().putAll(this.config);
            return cfg;
        }
    }
}

