/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.config;

import com.fluxtion.agrona.concurrent.BusySpinIdleStrategy;
import com.fluxtion.agrona.concurrent.IdleStrategy;
import com.fluxtion.agrona.concurrent.YieldingIdleStrategy;
import com.fluxtion.runtime.EventProcessor;
import com.fluxtion.runtime.node.ObjectEventHandlerNode;
import com.telamin.mongoose.MongooseEventHandler;
import com.telamin.mongoose.config.EventFeedConfig;
import com.telamin.mongoose.config.EventProcessorConfig;
import com.telamin.mongoose.config.EventProcessorGroupConfig;
import com.telamin.mongoose.config.EventSinkConfig;
import com.telamin.mongoose.config.ServiceConfig;
import com.telamin.mongoose.config.ThreadConfig;
import com.telamin.mongoose.service.CallBackType;
import com.telamin.mongoose.service.EventToInvokeStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;

public class MongooseServerConfig {
    private List<EventProcessorGroupConfig> eventHandlers;
    private List<EventFeedConfig<?>> eventFeeds;
    private List<EventSinkConfig<?>> eventSinks;
    private List<ServiceConfig<?>> services;
    private List<ThreadConfig> agentThreads;
    private IdleStrategy idleStrategy = new YieldingIdleStrategy();
    private EventProcessorGroupConfig defaultHandlerGroupConfig;
    private Map<CallBackType, Supplier<EventToInvokeStrategy>> eventInvokeStrategies;

    public List<EventProcessorGroupConfig> getEventHandlers() {
        if (this.eventHandlers == null) {
            this.eventHandlers = new ArrayList<EventProcessorGroupConfig>();
        }
        if (this.defaultHandlerGroupConfig != null && !this.eventHandlers.contains(this.defaultHandlerGroupConfig)) {
            this.eventHandlers.add(this.defaultHandlerGroupConfig);
        }
        return this.eventHandlers;
    }

    public <T> MongooseServerConfig addEventSource(T eventSource, String name, boolean isBroadcast) {
        if (this.eventFeeds == null) {
            this.eventFeeds = new ArrayList();
        }
        EventFeedConfig eventFeedConfig = new EventFeedConfig();
        eventFeedConfig.setInstance(eventSource);
        eventFeedConfig.setName(name);
        eventFeedConfig.setBroadcast(isBroadcast);
        this.eventFeeds.add(eventFeedConfig);
        return this;
    }

    public <T> MongooseServerConfig addEventSourceWorker(T eventSource, String name, boolean isBroadcast, String agentGroup, IdleStrategy idleStrategy) {
        if (this.eventFeeds == null) {
            this.eventFeeds = new ArrayList();
        }
        EventFeedConfig eventFeedConfig = new EventFeedConfig();
        eventFeedConfig.setInstance(eventSource);
        eventFeedConfig.setName(name);
        eventFeedConfig.setBroadcast(isBroadcast);
        eventFeedConfig.setAgentName(agentGroup);
        eventFeedConfig.setIdleStrategy(idleStrategy);
        this.eventFeeds.add(eventFeedConfig);
        return this;
    }

    public IdleStrategy lookupIdleStrategyWhenNull(IdleStrategy preferredIdeIdleStrategy, String agentName) {
        if (preferredIdeIdleStrategy == null && this.agentThreads == null) {
            return this.idleStrategy;
        }
        if (preferredIdeIdleStrategy == null) {
            return this.agentThreads.stream().filter(cfg -> cfg.getAgentName().equals(agentName)).findFirst().map(ThreadConfig::getIdleStrategy).orElse((IdleStrategy)new YieldingIdleStrategy());
        }
        return preferredIdeIdleStrategy;
    }

    public IdleStrategy getIdleStrategyOrDefault(String agentName, IdleStrategy defaultIdeIdleStrategy) {
        if (defaultIdeIdleStrategy == null && this.agentThreads == null) {
            return this.idleStrategy;
        }
        if (this.agentThreads == null) {
            return defaultIdeIdleStrategy;
        }
        IdleStrategy idleStrategy = this.agentThreads.stream().filter(cfg -> cfg.getAgentName().equals(agentName)).findFirst().map(ThreadConfig::getIdleStrategy).orElse(defaultIdeIdleStrategy);
        return idleStrategy == null ? defaultIdeIdleStrategy : idleStrategy;
    }

    public <T extends EventProcessor<?>> EventProcessorGroupConfig addProcessor(T processor, String name) {
        if (this.defaultHandlerGroupConfig == null) {
            this.defaultHandlerGroupConfig = new EventProcessorGroupConfig();
            this.defaultHandlerGroupConfig.setAgentName("defaultHandlerGroup");
            this.defaultHandlerGroupConfig.setEventHandlers(new HashMap());
            this.defaultHandlerGroupConfig.setIdleStrategy((IdleStrategy)new BusySpinIdleStrategy());
        }
        EventProcessorConfig<T> processorConfig = new EventProcessorConfig<T>();
        processorConfig.setEventHandler(processor);
        this.defaultHandlerGroupConfig.getEventHandlers().put(name, processorConfig);
        return this.defaultHandlerGroupConfig;
    }

    public <T extends EventProcessor<?>> MongooseServerConfig addProcessor(String groupName, T processor, String name) {
        EventProcessorGroupConfig eventProcessorGroupConfig = this.getGroupConfig(groupName);
        EventProcessorConfig<T> processorConfig = new EventProcessorConfig<T>();
        processorConfig.setEventHandler(processor);
        eventProcessorGroupConfig.getEventHandlers().put(name, processorConfig);
        return this;
    }

    public <T extends EventProcessor<?>> MongooseServerConfig addProcessor(String groupName, Consumer<Object> handlerFunction, String name) {
        EventProcessorGroupConfig eventProcessorGroupConfig = this.getGroupConfig(groupName);
        EventProcessorConfig<EventProcessor> processorConfig = new EventProcessorConfig<EventProcessor>();
        EventProcessor mongooseEventHandler = (EventProcessor)new MongooseEventHandler(handlerFunction);
        processorConfig.setEventHandler(mongooseEventHandler);
        eventProcessorGroupConfig.getEventHandlers().put(name, processorConfig);
        return this;
    }

    public <T extends ObjectEventHandlerNode> MongooseServerConfig addProcessor(String groupName, T processor, String name) {
        EventProcessorGroupConfig eventProcessorGroupConfig = this.getGroupConfig(groupName);
        EventProcessorConfig processorConfig = new EventProcessorConfig();
        processorConfig.setCustomHandler(processor);
        Map<String, EventProcessorConfig<?>> eventHandlers1 = eventProcessorGroupConfig.getEventHandlers();
        eventHandlers1.put(name, processorConfig);
        return this;
    }

    public EventProcessorGroupConfig getGroupConfig(String groupName) {
        return this.getEventHandlers().stream().filter(cfg -> cfg.getAgentName().equals(groupName)).findFirst().orElseGet(() -> {
            EventProcessorGroupConfig config = EventProcessorGroupConfig.builder().agentName(groupName).build();
            this.getEventHandlers().add(config);
            return config;
        });
    }

    public <T> MongooseServerConfig addService(T service, String name) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        Class<?> clazz = service.getClass();
        ServiceConfig<T> cfg = new ServiceConfig<T>(service, clazz, name);
        this.services.add(cfg);
        return this;
    }

    public <T> MongooseServerConfig addService(T service, Class<T> serviceClass, String name) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        ServiceConfig<T> cfg = new ServiceConfig<T>(service, serviceClass, name);
        this.services.add(cfg);
        return this;
    }

    public <T> MongooseServerConfig addWorkerService(T service, Class<T> serviceClass, String name, String agentGroup, IdleStrategy idleStrategy) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        ServiceConfig<T> cfg = new ServiceConfig<T>(service, serviceClass, name);
        cfg.setAgentGroup(agentGroup);
        cfg.setIdleStrategy(idleStrategy);
        this.services.add(cfg);
        return this;
    }

    public <T> MongooseServerConfig addWorkerService(T service, String name, String agentGroup, IdleStrategy idleStrategy) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        Class<?> clazz = service.getClass();
        ServiceConfig<T> cfg = new ServiceConfig<T>(service, clazz, name);
        cfg.setAgentGroup(agentGroup);
        cfg.setIdleStrategy(idleStrategy);
        this.services.add(cfg);
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public List<EventFeedConfig<?>> getEventFeeds() {
        return this.eventFeeds;
    }

    @Generated
    public List<EventSinkConfig<?>> getEventSinks() {
        return this.eventSinks;
    }

    @Generated
    public List<ServiceConfig<?>> getServices() {
        return this.services;
    }

    @Generated
    public List<ThreadConfig> getAgentThreads() {
        return this.agentThreads;
    }

    @Generated
    public IdleStrategy getIdleStrategy() {
        return this.idleStrategy;
    }

    @Generated
    public EventProcessorGroupConfig getDefaultHandlerGroupConfig() {
        return this.defaultHandlerGroupConfig;
    }

    @Generated
    public Map<CallBackType, Supplier<EventToInvokeStrategy>> getEventInvokeStrategies() {
        return this.eventInvokeStrategies;
    }

    @Generated
    public void setEventHandlers(List<EventProcessorGroupConfig> eventHandlers) {
        this.eventHandlers = eventHandlers;
    }

    @Generated
    public void setEventFeeds(List<EventFeedConfig<?>> eventFeeds) {
        this.eventFeeds = eventFeeds;
    }

    @Generated
    public void setEventSinks(List<EventSinkConfig<?>> eventSinks) {
        this.eventSinks = eventSinks;
    }

    @Generated
    public void setServices(List<ServiceConfig<?>> services) {
        this.services = services;
    }

    @Generated
    public void setAgentThreads(List<ThreadConfig> agentThreads) {
        this.agentThreads = agentThreads;
    }

    @Generated
    public void setIdleStrategy(IdleStrategy idleStrategy) {
        this.idleStrategy = idleStrategy;
    }

    @Generated
    public void setDefaultHandlerGroupConfig(EventProcessorGroupConfig defaultHandlerGroupConfig) {
        this.defaultHandlerGroupConfig = defaultHandlerGroupConfig;
    }

    @Generated
    public void setEventInvokeStrategies(Map<CallBackType, Supplier<EventToInvokeStrategy>> eventInvokeStrategies) {
        this.eventInvokeStrategies = eventInvokeStrategies;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongooseServerConfig)) {
            return false;
        }
        MongooseServerConfig other = (MongooseServerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<EventProcessorGroupConfig> this$eventHandlers = this.getEventHandlers();
        List<EventProcessorGroupConfig> other$eventHandlers = other.getEventHandlers();
        if (this$eventHandlers == null ? other$eventHandlers != null : !((Object)this$eventHandlers).equals(other$eventHandlers)) {
            return false;
        }
        List<EventFeedConfig<?>> this$eventFeeds = this.getEventFeeds();
        List<EventFeedConfig<?>> other$eventFeeds = other.getEventFeeds();
        if (this$eventFeeds == null ? other$eventFeeds != null : !((Object)this$eventFeeds).equals(other$eventFeeds)) {
            return false;
        }
        List<EventSinkConfig<?>> this$eventSinks = this.getEventSinks();
        List<EventSinkConfig<?>> other$eventSinks = other.getEventSinks();
        if (this$eventSinks == null ? other$eventSinks != null : !((Object)this$eventSinks).equals(other$eventSinks)) {
            return false;
        }
        List<ServiceConfig<?>> this$services = this.getServices();
        List<ServiceConfig<?>> other$services = other.getServices();
        if (this$services == null ? other$services != null : !((Object)this$services).equals(other$services)) {
            return false;
        }
        List<ThreadConfig> this$agentThreads = this.getAgentThreads();
        List<ThreadConfig> other$agentThreads = other.getAgentThreads();
        if (this$agentThreads == null ? other$agentThreads != null : !((Object)this$agentThreads).equals(other$agentThreads)) {
            return false;
        }
        IdleStrategy this$idleStrategy = this.getIdleStrategy();
        IdleStrategy other$idleStrategy = other.getIdleStrategy();
        if (this$idleStrategy == null ? other$idleStrategy != null : !this$idleStrategy.equals(other$idleStrategy)) {
            return false;
        }
        EventProcessorGroupConfig this$defaultHandlerGroupConfig = this.getDefaultHandlerGroupConfig();
        EventProcessorGroupConfig other$defaultHandlerGroupConfig = other.getDefaultHandlerGroupConfig();
        if (this$defaultHandlerGroupConfig == null ? other$defaultHandlerGroupConfig != null : !((Object)this$defaultHandlerGroupConfig).equals(other$defaultHandlerGroupConfig)) {
            return false;
        }
        Map<CallBackType, Supplier<EventToInvokeStrategy>> this$eventInvokeStrategies = this.getEventInvokeStrategies();
        Map<CallBackType, Supplier<EventToInvokeStrategy>> other$eventInvokeStrategies = other.getEventInvokeStrategies();
        return !(this$eventInvokeStrategies == null ? other$eventInvokeStrategies != null : !((Object)this$eventInvokeStrategies).equals(other$eventInvokeStrategies));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MongooseServerConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<EventProcessorGroupConfig> $eventHandlers = this.getEventHandlers();
        result = result * 59 + ($eventHandlers == null ? 43 : ((Object)$eventHandlers).hashCode());
        List<EventFeedConfig<?>> $eventFeeds = this.getEventFeeds();
        result = result * 59 + ($eventFeeds == null ? 43 : ((Object)$eventFeeds).hashCode());
        List<EventSinkConfig<?>> $eventSinks = this.getEventSinks();
        result = result * 59 + ($eventSinks == null ? 43 : ((Object)$eventSinks).hashCode());
        List<ServiceConfig<?>> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        List<ThreadConfig> $agentThreads = this.getAgentThreads();
        result = result * 59 + ($agentThreads == null ? 43 : ((Object)$agentThreads).hashCode());
        IdleStrategy $idleStrategy = this.getIdleStrategy();
        result = result * 59 + ($idleStrategy == null ? 43 : $idleStrategy.hashCode());
        EventProcessorGroupConfig $defaultHandlerGroupConfig = this.getDefaultHandlerGroupConfig();
        result = result * 59 + ($defaultHandlerGroupConfig == null ? 43 : ((Object)$defaultHandlerGroupConfig).hashCode());
        Map<CallBackType, Supplier<EventToInvokeStrategy>> $eventInvokeStrategies = this.getEventInvokeStrategies();
        result = result * 59 + ($eventInvokeStrategies == null ? 43 : ((Object)$eventInvokeStrategies).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MongooseServerConfig(eventHandlers=" + String.valueOf(this.getEventHandlers()) + ", eventFeeds=" + String.valueOf(this.getEventFeeds()) + ", eventSinks=" + String.valueOf(this.getEventSinks()) + ", services=" + String.valueOf(this.getServices()) + ", agentThreads=" + String.valueOf(this.getAgentThreads()) + ", idleStrategy=" + String.valueOf(this.getIdleStrategy()) + ", defaultHandlerGroupConfig=" + String.valueOf(this.getDefaultHandlerGroupConfig()) + ", eventInvokeStrategies=" + String.valueOf(this.getEventInvokeStrategies()) + ")";
    }

    public static final class Builder {
        private final List<EventProcessorGroupConfig> eventHandlers = new ArrayList<EventProcessorGroupConfig>();
        private final List<EventFeedConfig<?>> eventFeeds = new ArrayList();
        private final List<EventSinkConfig<?>> eventSinks = new ArrayList();
        private final List<ServiceConfig<?>> services = new ArrayList();
        private final List<ThreadConfig> agentThreads = new ArrayList<ThreadConfig>();
        private IdleStrategy idleStrategy;
        private final Map<CallBackType, Supplier<EventToInvokeStrategy>> eventInvokeStrategies = new HashMap<CallBackType, Supplier<EventToInvokeStrategy>>();

        private Builder() {
        }

        public Builder idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public Builder addProcessorGroup(EventProcessorGroupConfig group) {
            this.eventHandlers.add(group);
            return this;
        }

        public Builder addEventFeed(EventFeedConfig<?> feed) {
            this.eventFeeds.add(feed);
            return this;
        }

        public Builder addEventSink(EventSinkConfig<?> sink) {
            this.eventSinks.add(sink);
            return this;
        }

        public Builder addService(ServiceConfig<?> svc) {
            this.services.add(svc);
            return this;
        }

        public Builder addThread(ThreadConfig thread) {
            this.agentThreads.add(thread);
            return this;
        }

        public Builder eventInvokeStrategy(CallBackType type, Supplier<EventToInvokeStrategy> factory) {
            if (type != null && factory != null) {
                this.eventInvokeStrategies.put(type, factory);
            }
            return this;
        }

        public Builder onEventInvokeStrategy(Supplier<EventToInvokeStrategy> factory) {
            return this.eventInvokeStrategy(CallBackType.ON_EVENT_CALL_BACK, factory);
        }

        public Builder addProcessor(String agentName, String handlerName, EventProcessorConfig<?> cfg) {
            if (agentName == null || handlerName == null || cfg == null) {
                throw new IllegalArgumentException("agentName, handlerName and cfg must be non-null");
            }
            EventProcessorGroupConfig group = this.eventHandlers.stream().filter(g -> agentName.equals(g.getAgentName())).findFirst().orElseGet(() -> {
                EventProcessorGroupConfig g = EventProcessorGroupConfig.builder().agentName(agentName).build();
                this.eventHandlers.add(g);
                return g;
            });
            if (group.getEventHandlers() == null) {
                group.setEventHandlers(new HashMap());
            }
            group.getEventHandlers().put(handlerName, cfg);
            return this;
        }

        public Builder addProcessor(String agentName, EventProcessorConfig<?> cfg) {
            return this.addProcessor(agentName, cfg.getName(), cfg);
        }

        public MongooseServerConfig build() {
            MongooseServerConfig cfg = new MongooseServerConfig();
            if (!this.eventHandlers.isEmpty()) {
                cfg.setEventHandlers(new ArrayList<EventProcessorGroupConfig>(this.eventHandlers));
            }
            if (!this.eventFeeds.isEmpty()) {
                cfg.setEventFeeds(new ArrayList(this.eventFeeds));
            }
            if (!this.eventSinks.isEmpty()) {
                cfg.setEventSinks(new ArrayList(this.eventSinks));
            }
            if (!this.services.isEmpty()) {
                cfg.setServices(new ArrayList(this.services));
            }
            if (!this.agentThreads.isEmpty()) {
                cfg.setAgentThreads(new ArrayList<ThreadConfig>(this.agentThreads));
            }
            if (this.idleStrategy != null) {
                cfg.setIdleStrategy(this.idleStrategy);
            }
            if (!this.eventInvokeStrategies.isEmpty()) {
                cfg.setEventInvokeStrategies(new HashMap<CallBackType, Supplier<EventToInvokeStrategy>>(this.eventInvokeStrategies));
            }
            return cfg;
        }
    }
}

