/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.config;

import com.fluxtion.agrona.concurrent.Agent;
import com.fluxtion.agrona.concurrent.IdleStrategy;
import com.fluxtion.runtime.service.Service;
import com.telamin.mongoose.dutycycle.ServiceAgent;
import lombok.Generated;

public class ServiceConfig<T> {
    private T service;
    private String serviceClass;
    private String name;
    private String agentGroup;
    private IdleStrategy idleStrategy;

    public ServiceConfig(T service, Class<T> serviceClass, String name) {
        this(service, serviceClass.getCanonicalName(), name, null, null);
    }

    public boolean isAgent() {
        return this.agentGroup != null;
    }

    public void setService(T service) {
        this.service = service;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void setName(String name) {
        this.name = name;
    }

    public T getService() {
        return this.service;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public String getName() {
        return this.name;
    }

    public String getAgentGroup() {
        return this.agentGroup;
    }

    public void setAgentGroup(String agentGroup) {
        this.agentGroup = agentGroup;
    }

    public IdleStrategy getIdleStrategy() {
        return this.idleStrategy;
    }

    public void setIdleStrategy(IdleStrategy idleStrategy) {
        this.idleStrategy = idleStrategy;
    }

    public Service<T> toService() {
        Class<?> serviceClazz = this.serviceClass == null ? this.service.getClass() : Class.forName(this.serviceClass);
        this.serviceClass = serviceClazz.getCanonicalName();
        return new Service(this.service, serviceClazz, this.name == null ? this.serviceClass : this.name);
    }

    public <A extends Agent> ServiceAgent<A> toServiceAgent() {
        Service<T> svc = this.toService();
        return new ServiceAgent<T>(this.agentGroup, this.idleStrategy, svc, (Agent)this.service);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated
    public T service() {
        return this.service;
    }

    @Generated
    public String serviceClass() {
        return this.serviceClass;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public String agentGroup() {
        return this.agentGroup;
    }

    @Generated
    public IdleStrategy idleStrategy() {
        return this.idleStrategy;
    }

    @Generated
    public ServiceConfig<T> service(T service) {
        this.service = service;
        return this;
    }

    @Generated
    public ServiceConfig<T> serviceClass(String serviceClass) {
        this.serviceClass = serviceClass;
        return this;
    }

    @Generated
    public ServiceConfig<T> name(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public ServiceConfig<T> agentGroup(String agentGroup) {
        this.agentGroup = agentGroup;
        return this;
    }

    @Generated
    public ServiceConfig<T> idleStrategy(IdleStrategy idleStrategy) {
        this.idleStrategy = idleStrategy;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceConfig)) {
            return false;
        }
        ServiceConfig other = (ServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$service = this.service();
        T other$service = other.service();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        String this$serviceClass = this.serviceClass();
        String other$serviceClass = other.serviceClass();
        if (this$serviceClass == null ? other$serviceClass != null : !this$serviceClass.equals(other$serviceClass)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$agentGroup = this.agentGroup();
        String other$agentGroup = other.agentGroup();
        if (this$agentGroup == null ? other$agentGroup != null : !this$agentGroup.equals(other$agentGroup)) {
            return false;
        }
        IdleStrategy this$idleStrategy = this.idleStrategy();
        IdleStrategy other$idleStrategy = other.idleStrategy();
        return !(this$idleStrategy == null ? other$idleStrategy != null : !this$idleStrategy.equals(other$idleStrategy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $service = this.service();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        String $serviceClass = this.serviceClass();
        result = result * 59 + ($serviceClass == null ? 43 : $serviceClass.hashCode());
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $agentGroup = this.agentGroup();
        result = result * 59 + ($agentGroup == null ? 43 : $agentGroup.hashCode());
        IdleStrategy $idleStrategy = this.idleStrategy();
        result = result * 59 + ($idleStrategy == null ? 43 : $idleStrategy.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ServiceConfig(service=" + String.valueOf(this.service()) + ", serviceClass=" + this.serviceClass() + ", name=" + this.name() + ", agentGroup=" + this.agentGroup() + ", idleStrategy=" + String.valueOf(this.idleStrategy()) + ")";
    }

    @Generated
    public ServiceConfig(T service, String serviceClass, String name, String agentGroup, IdleStrategy idleStrategy) {
        this.service = service;
        this.serviceClass = serviceClass;
        this.name = name;
        this.agentGroup = agentGroup;
        this.idleStrategy = idleStrategy;
    }

    @Generated
    public ServiceConfig() {
    }

    public static final class Builder<T> {
        private T service;
        private String serviceClass;
        private String name;
        private String agentGroup;
        private IdleStrategy idleStrategy;

        private Builder() {
        }

        public Builder<T> service(T service) {
            this.service = service;
            return this;
        }

        public Builder<T> serviceClass(Class<?> clazz) {
            this.serviceClass = clazz == null ? null : clazz.getCanonicalName();
            return this;
        }

        public Builder<T> serviceClassName(String className) {
            this.serviceClass = className;
            return this;
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> agent(String agentGroup, IdleStrategy idleStrategy) {
            this.agentGroup = agentGroup;
            this.idleStrategy = idleStrategy;
            return this;
        }

        public ServiceConfig<T> build() {
            ServiceConfig<T> cfg = new ServiceConfig<T>();
            cfg.setService(this.service);
            cfg.setServiceClass(this.serviceClass);
            cfg.setName(this.name);
            cfg.setAgentGroup(this.agentGroup);
            cfg.setIdleStrategy(this.idleStrategy);
            return cfg;
        }
    }
}

