/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.connector.file;

import com.fluxtion.agrona.IoUtil;
import com.fluxtion.runtime.event.NamedFeedEvent;
import com.telamin.mongoose.config.ReadStrategy;
import com.telamin.mongoose.dispatch.EventToQueuePublisher;
import com.telamin.mongoose.service.extension.AbstractAgentHostedEventSourceService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.MappedByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;

public class FileEventSource
extends AbstractAgentHostedEventSourceService {
    @Generated
    private static final Logger log = Logger.getLogger(FileEventSource.class.getName());
    private String filename;
    private InputStream stream;
    private BufferedReader reader = null;
    private char[] buffer;
    private int offset = 0;
    private boolean cacheEventLog = false;
    private ReadStrategy readStrategy = ReadStrategy.COMMITED;
    private boolean tail = true;
    private boolean commitRead = true;
    private boolean latestRead = false;
    private final AtomicBoolean startComplete = new AtomicBoolean(false);
    private long streamOffset;
    private MappedByteBuffer commitPointer;
    private boolean once;
    private boolean publishToQueue = false;
    private final boolean infoEnabled;
    private final boolean fineEnabled;
    private final boolean finestEnabled;
    private final boolean warningEnabled;
    private final boolean severeEnabled;

    public FileEventSource() {
        this(1024);
    }

    public FileEventSource(int initialBufferSize) {
        super("fileEventFeed");
        this.buffer = new char[initialBufferSize];
        this.infoEnabled = log.isLoggable(Level.INFO);
        this.fineEnabled = log.isLoggable(Level.FINE);
        this.finestEnabled = log.isLoggable(Level.FINEST);
        this.warningEnabled = log.isLoggable(Level.WARNING);
        this.severeEnabled = log.isLoggable(Level.SEVERE);
    }

    public void start() {
        block17: {
            if (this.infoEnabled) {
                log.log(Level.INFO, "start FileEventSource " + this.serviceName + " file:" + this.filename);
            }
            this.tail = this.readStrategy == ReadStrategy.COMMITED | this.readStrategy == ReadStrategy.EARLIEST | this.readStrategy == ReadStrategy.LATEST;
            this.once = !this.tail;
            this.commitRead = this.readStrategy == ReadStrategy.COMMITED;
            this.latestRead = this.readStrategy == ReadStrategy.LATEST | this.readStrategy == ReadStrategy.ONCE_LATEST;
            if (this.infoEnabled) {
                log.log(Level.INFO, "tail:" + this.tail + " once:" + this.once + ", commitRead:" + this.commitRead + " latestRead:" + this.latestRead + " readStrategy:" + String.valueOf((Object)this.readStrategy));
            }
            File committedReadFile = new File(this.filename + ".readPointer");
            if (this.readStrategy == ReadStrategy.ONCE_EARLIEST | this.readStrategy == ReadStrategy.EARLIEST) {
                this.streamOffset = 0L;
            } else if (committedReadFile.exists()) {
                this.commitPointer = IoUtil.mapExistingFile((File)committedReadFile, (String)("committedReadFile_" + this.filename));
                this.streamOffset = this.commitPointer.getLong(0);
                if (this.infoEnabled) {
                    log.log(Level.INFO, this.serviceName + " reading committedReadFile:" + committedReadFile.getAbsolutePath() + ", streamOffset:" + this.streamOffset);
                }
            } else if (this.commitRead) {
                this.commitPointer = IoUtil.mapNewFile((File)committedReadFile, (long)1024L);
                this.streamOffset = 0L;
                if (this.infoEnabled) {
                    log.log(Level.INFO, this.serviceName + " creating committedReadFile:" + committedReadFile.getAbsolutePath() + ", streamOffset:" + this.streamOffset);
                }
            }
            if (this.latestRead && !this.commitRead) {
                try {
                    File f = new File(this.filename);
                    if (f.exists()) {
                        this.streamOffset = f.length();
                        if (this.infoEnabled) {
                            log.log(Level.INFO, "initialising streamOffset to EOF for LATEST: " + this.streamOffset);
                        }
                    }
                }
                catch (Throwable t) {
                    if (!this.warningEnabled) break block17;
                    log.log(Level.WARNING, "Failed to determine EOF for LATEST, defaulting to 0: " + String.valueOf(t));
                }
            }
        }
        if (this.filename == null || this.filename.isEmpty()) {
            // empty if block
        }
        this.connectReader();
        this.output.setCacheEventLog(this.cacheEventLog);
        this.tail |= this.readStrategy == ReadStrategy.ONCE_EARLIEST;
        if (this.cacheEventLog) {
            if (this.infoEnabled) {
                log.log(Level.INFO, "cacheEventLog: " + this.cacheEventLog);
            }
            this.startComplete.set(true);
            this.publishToQueue = false;
            this.doWork();
            this.startComplete.set(false);
        }
    }

    public void onStart() {
        if (this.infoEnabled) {
            log.log(Level.INFO, "agent onStart FileEventSource " + this.serviceName + " file:" + this.filename);
        }
    }

    public void startComplete() {
        if (this.infoEnabled) {
            log.log(Level.INFO, "startComplete FileEventSource " + this.serviceName + " file:" + this.filename);
        }
        this.startComplete.set(true);
        this.publishToQueue = true;
        this.output.dispatchCachedEventLog();
    }

    public <T> NamedFeedEvent<T>[] eventLog() {
        List<NamedFeedEvent<?>> eventLog = this.output.getEventLog();
        return eventLog.toArray(new NamedFeedEvent[0]);
    }

    public int doWork() {
        if (!this.tail) {
            return 0;
        }
        try {
            if (this.connectReader() == null) {
                return 0;
            }
            if (this.fineEnabled) {
                log.log(Level.FINE, "doWork FileEventFeed");
            }
            String lastReadLine = null;
            int readCount = 0;
            while (this.reader.ready()) {
                String line;
                this.tail = !this.once;
                int nread = this.reader.read(this.buffer, this.offset, this.buffer.length - this.offset);
                if (this.finestEnabled) {
                    log.log(Level.FINEST, "Read " + nread + " bytes from " + this.getFilename());
                }
                if (nread <= 0) continue;
                this.offset += nread;
                do {
                    if ((line = this.extractLine()) == null) continue;
                    ++readCount;
                    if (this.finestEnabled) {
                        log.log(Level.FINEST, "Read a line from " + this.getFilename() + " count:" + readCount + " line:" + line);
                    }
                    if (this.latestRead) {
                        lastReadLine = line;
                        continue;
                    }
                    this.publish(line);
                } while (line != null);
                if (this.latestRead & lastReadLine != null & !this.once) {
                    if (this.finestEnabled) {
                        log.log(Level.FINEST, "publish latest:" + lastReadLine);
                    }
                    this.publish(lastReadLine);
                }
                if (lastReadLine != null || this.offset != this.buffer.length) continue;
                char[] newbuf = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, newbuf, 0, this.buffer.length);
                if (this.infoEnabled) {
                    log.log(Level.INFO, "Increased buffer from " + this.buffer.length + " to " + newbuf.length);
                }
                this.buffer = newbuf;
            }
            this.tail |= this.readStrategy != ReadStrategy.ONCE_EARLIEST;
            return readCount;
        }
        catch (IOException e) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
            this.stream = null;
            return 0;
        }
    }

    public void stop() {
        if (this.infoEnabled) {
            log.log(Level.INFO, "Stopping");
        }
        try {
            if (this.stream != null) {
                this.stream.close();
                if (this.infoEnabled) {
                    log.log(Level.INFO, "Closed input stream");
                }
            }
        }
        catch (IOException e) {
            if (this.severeEnabled) {
                log.log(Level.SEVERE, "Failed to close FileStreamSourceTask stream", e);
            }
        }
        finally {
            if (this.commitPointer != null) {
                this.commitPointer.force();
                IoUtil.unmap((MappedByteBuffer)this.commitPointer);
            }
        }
    }

    @Override
    public void tearDown() {
        super.tearDown();
    }

    private Reader connectReader() {
        if (this.startComplete.get() & this.stream == null && this.filename != null && !this.filename.isEmpty()) {
            try {
                this.stream = Files.newInputStream(Paths.get(this.filename, new String[0]), new OpenOption[0]);
                if (this.infoEnabled) {
                    log.log(Level.INFO, "Found previous offset, trying to skip to file offset " + this.streamOffset);
                }
                long skipLeft = this.streamOffset;
                while (skipLeft > 0L) {
                    try {
                        long skipped = this.stream.skip(skipLeft);
                        skipLeft -= skipped;
                    }
                    catch (IOException e) {
                        if (!this.severeEnabled) continue;
                        log.log(Level.SEVERE, "Error while trying to seek to previous offset in file " + this.filename + ": ", e);
                    }
                }
                if (this.infoEnabled) {
                    log.log(Level.INFO, "Skipped to offset " + this.streamOffset);
                }
                this.reader = new BufferedReader(new InputStreamReader(this.stream, StandardCharsets.UTF_8));
                if (this.infoEnabled) {
                    log.log(Level.INFO, "Opened " + this.getFilename() + " for reading");
                }
            }
            catch (NoSuchFileException e) {
                if (this.warningEnabled) {
                    log.log(Level.WARNING, "Couldn't find file " + this.getFilename() + " for FileStreamSourceTask, sleeping to wait for it to be created");
                }
            }
            catch (IOException e) {
                if (this.severeEnabled) {
                    log.log(Level.SEVERE, "Error while trying to open file " + this.filename + ": ", e);
                }
                throw new RuntimeException(e);
            }
        }
        return this.reader;
    }

    private void publish(String line) {
        if (this.publishToQueue) {
            if (this.fineEnabled) {
                log.log(Level.FINE, "publish record:" + line);
            }
            this.output.publish(line);
        } else {
            if (this.fineEnabled) {
                log.log(Level.FINE, "cache record:" + line);
            }
            this.output.cache(line);
        }
        if (this.commitRead) {
            this.commitPointer.force();
        }
    }

    private String extractLine() {
        int until = -1;
        int newStart = -1;
        for (int i = 0; i < this.offset; ++i) {
            if (this.buffer[i] == '\n') {
                until = i;
                newStart = i + 1;
                break;
            }
            if (this.buffer[i] != '\r') continue;
            if (i + 1 >= this.offset) {
                return null;
            }
            until = i;
            newStart = this.buffer[i + 1] == '\n' ? i + 2 : i + 1;
            break;
        }
        if (until != -1) {
            String result = new String(this.buffer, 0, until);
            System.arraycopy(this.buffer, newStart, this.buffer, 0, this.buffer.length - newStart);
            this.offset -= newStart;
            this.streamOffset += (long)newStart;
            if (this.commitRead) {
                this.commitPointer.putLong(0, this.streamOffset);
            }
            return result;
        }
        return null;
    }

    void setOutput(EventToQueuePublisher<?> output) {
        this.output = output;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Generated
    public boolean isCacheEventLog() {
        return this.cacheEventLog;
    }

    @Generated
    public void setCacheEventLog(boolean cacheEventLog) {
        this.cacheEventLog = cacheEventLog;
    }

    @Generated
    public ReadStrategy getReadStrategy() {
        return this.readStrategy;
    }

    @Generated
    public void setReadStrategy(ReadStrategy readStrategy) {
        this.readStrategy = readStrategy;
    }
}

