/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.connector.file;

import com.fluxtion.runtime.lifecycle.Lifecycle;
import com.fluxtion.runtime.output.AbstractMessageSink;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.logging.Logger;
import lombok.Generated;

public class FileMessageSink
extends AbstractMessageSink<Object>
implements Lifecycle {
    @Generated
    private static final Logger log = Logger.getLogger(FileMessageSink.class.getName());
    private String filename;
    private PrintStream printStream;

    public void init() {
    }

    public void start() {
        Path path = Paths.get(this.filename, new String[0]);
        path.toFile().getParentFile().mkdirs();
        this.printStream = new PrintStream(Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.APPEND), false, StandardCharsets.UTF_8);
    }

    protected void sendToSink(Object value) {
        log.finer(() -> "sink publish:" + String.valueOf(value));
        this.printStream.println(value);
    }

    public void stop() {
        this.printStream.flush();
        this.printStream.close();
    }

    public void tearDown() {
        this.stop();
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public void setFilename(String filename) {
        this.filename = filename;
    }
}

