/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.connector.memory;

import com.fluxtion.runtime.output.AbstractMessageSink;
import com.telamin.mongoose.connector.memory.InMemoryEventSource;
import com.telamin.mongoose.service.EventSource;
import java.util.function.Function;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;

public class HandlerPipe<T> {
    @Generated
    private static final Logger log = Logger.getLogger(HandlerPipe.class.getName());
    private final InMemoryEventSource<T> source;
    private final PipeSink sink;

    public static <T> HandlerPipe<T> of(String feedName) {
        return new HandlerPipe<T>(feedName);
    }

    public static <T> HandlerPipe<T> of(String feedName, EventSource.EventWrapStrategy wrapStrategy) {
        HandlerPipe<T> pipe = new HandlerPipe<T>(feedName);
        pipe.source.setEventWrapStrategy(wrapStrategy);
        return pipe;
    }

    public HandlerPipe(@NonNull String feedName) {
        if (feedName == null) {
            throw new NullPointerException("feedName is marked non-null but is null");
        }
        this.source = new InMemoryEventSource();
        this.source.setName(feedName);
        this.sink = new PipeSink();
    }

    public AbstractMessageSink<Object> sink() {
        return this.sink;
    }

    public HandlerPipe<T> dataMapper(Function<T, ?> mapper) {
        this.source.setDataMapper(mapper);
        return this;
    }

    public HandlerPipe<T> cacheEventLog(boolean cache) {
        this.source.setCacheEventLog(cache);
        return this;
    }

    protected void forward(Object value) {
        this.source.publishNow(value);
    }

    @Generated
    public InMemoryEventSource<T> getSource() {
        return this.source;
    }

    private class PipeSink
    extends AbstractMessageSink<Object> {
        private PipeSink() {
        }

        protected void sendToSink(Object value) {
            if (value == null) {
                return;
            }
            try {
                HandlerPipe.this.forward(value);
            }
            catch (Throwable t) {
                log.severe("HandlerPipe sink forward failed: " + String.valueOf(t));
                throw t;
            }
        }
    }
}

