/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.connector.memory;

import com.fluxtion.runtime.event.NamedFeedEvent;
import com.telamin.mongoose.dispatch.EventToQueuePublisher;
import com.telamin.mongoose.service.extension.AbstractAgentHostedEventSourceService;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import lombok.Generated;

public class InMemoryEventSource<T>
extends AbstractAgentHostedEventSourceService<T> {
    @Generated
    private static final Logger log = Logger.getLogger(InMemoryEventSource.class.getName());
    private final ConcurrentLinkedQueue<T> pending = new ConcurrentLinkedQueue();
    private final AtomicBoolean startComplete = new AtomicBoolean(false);
    private boolean cacheEventLog = false;
    private boolean publishToQueue = false;

    public InMemoryEventSource() {
        super("inMemoryEventFeed");
    }

    public void start() {
        this.output.setCacheEventLog(this.cacheEventLog);
        this.publishToQueue = !this.cacheEventLog;
    }

    public void startComplete() {
        this.startComplete.set(true);
        this.publishToQueue = true;
        this.output.dispatchCachedEventLog();
    }

    public void offer(T item) {
        if (item == null) {
            return;
        }
        this.pending.offer(item);
    }

    public void publishNow(T item) {
        if (item == null) {
            return;
        }
        if (this.publishToQueue) {
            this.output.publish(item);
        } else {
            this.output.cache(item);
        }
    }

    public int doWork() throws Exception {
        T item;
        int count = 0;
        while ((item = this.pending.poll()) != null) {
            if (this.publishToQueue) {
                this.output.publish(item);
            } else {
                this.output.cache(item);
            }
            ++count;
        }
        return count;
    }

    public <X> NamedFeedEvent<X>[] eventLog() {
        List<NamedFeedEvent<?>> eventLog = this.output.getEventLog();
        return eventLog.toArray(new NamedFeedEvent[0]);
    }

    void setOutput(EventToQueuePublisher<?> output) {
        this.output = output;
    }

    @Generated
    public boolean isCacheEventLog() {
        return this.cacheEventLog;
    }

    @Generated
    public void setCacheEventLog(boolean cacheEventLog) {
        this.cacheEventLog = cacheEventLog;
    }
}

