/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.dispatch;

import com.fluxtion.runtime.StaticEventProcessor;
import com.fluxtion.runtime.annotations.feature.Experimental;
import com.telamin.mongoose.dispatch.ProcessorContext;
import com.telamin.mongoose.service.EventToInvokeStrategy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;

@Experimental
public abstract class AbstractEventToInvocationStrategy
implements EventToInvokeStrategy {
    @Generated
    private static final Logger log = Logger.getLogger(AbstractEventToInvocationStrategy.class.getName());
    protected final List<StaticEventProcessor> eventProcessorSinks = new CopyOnWriteArrayList<StaticEventProcessor>();
    protected static final Map<StaticEventProcessor, AtomicLong> syntheticClocks = new ConcurrentHashMap<StaticEventProcessor, AtomicLong>();
    protected static final AtomicLong syntheticClock = new AtomicLong();
    private final long id = syntheticClock.incrementAndGet();
    private final boolean fineLogEnabled = log.isLoggable(Level.FINE);

    public AbstractEventToInvocationStrategy() {
        if (this.fineLogEnabled) {
            log.fine(() -> "AbstractEventToInvocationStrategy created with id: " + this.id);
        }
    }

    @Override
    public void processEvent(Object event) {
        if (this.fineLogEnabled) {
            log.fine(() -> "invokerId: " + this.id + " processEvent: " + String.valueOf(event) + " to " + this.eventProcessorSinks.size() + " processors");
        }
        int targetQueuesSize = this.eventProcessorSinks.size();
        for (int i = 0; i < targetQueuesSize; ++i) {
            StaticEventProcessor eventProcessor = this.eventProcessorSinks.get(i);
            if (this.fineLogEnabled) {
                log.fine(() -> "invokerId: " + this.id + " dispatchEvent to " + String.valueOf(eventProcessor));
            }
            ProcessorContext.setCurrentProcessor(eventProcessor);
            this.dispatchEvent(event, eventProcessor);
            ProcessorContext.removeCurrentProcessor();
        }
    }

    @Override
    public void processEvent(Object event, long time) {
        int targetQueuesSize = this.eventProcessorSinks.size();
        for (int i = 0; i < targetQueuesSize; ++i) {
            StaticEventProcessor eventProcessor = this.eventProcessorSinks.get(i);
            syntheticClocks.computeIfAbsent(eventProcessor, k -> {
                AtomicLong atomicLong = new AtomicLong();
                eventProcessor.setClockStrategy(atomicLong::get);
                return atomicLong;
            }).set(time);
        }
        this.processEvent(event);
    }

    protected abstract void dispatchEvent(Object var1, StaticEventProcessor var2);

    @Override
    public void registerProcessor(StaticEventProcessor eventProcessor) {
        if (this.isValidTarget(eventProcessor) && !this.eventProcessorSinks.contains(eventProcessor)) {
            this.eventProcessorSinks.add(eventProcessor);
            log.fine(() -> "invokerId: " + this.id + " registerProcessor: " + String.valueOf(eventProcessor) + " added to " + this.eventProcessorSinks.size() + " processors");
        } else {
            log.warning("invokerId: " + this.id + " registerProcessor: " + String.valueOf(eventProcessor) + " is not a valid target");
        }
    }

    protected abstract boolean isValidTarget(StaticEventProcessor var1);

    @Override
    public void deregisterProcessor(StaticEventProcessor eventProcessor) {
        this.eventProcessorSinks.remove(eventProcessor);
    }

    @Override
    public int listenerCount() {
        return this.eventProcessorSinks.size();
    }
}

