/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.dispatch;

import com.fluxtion.agrona.concurrent.Agent;
import com.fluxtion.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import com.fluxtion.agrona.concurrent.OneToOneConcurrentArrayQueue;
import com.fluxtion.runtime.lifecycle.Lifecycle;
import com.telamin.mongoose.dispatch.EventToOnEventInvokeStrategy;
import com.telamin.mongoose.dispatch.EventToQueuePublisher;
import com.telamin.mongoose.dutycycle.EventQueueToEventProcessor;
import com.telamin.mongoose.dutycycle.EventQueueToEventProcessorAgent;
import com.telamin.mongoose.service.CallBackType;
import com.telamin.mongoose.service.EventSource;
import com.telamin.mongoose.service.EventSourceKey;
import com.telamin.mongoose.service.EventSubscriptionKey;
import com.telamin.mongoose.service.EventToInvokeStrategy;
import com.telamin.mongoose.service.LifeCycleEventSource;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class EventFlowManager {
    private final ConcurrentHashMap<EventSourceKey<?>, EventSource_QueuePublisher<?>> eventSourceToQueueMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<EventSinkKey<?>, ManyToOneConcurrentArrayQueue<?>> eventSinkToQueueMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<CallBackType, Supplier<EventToInvokeStrategy>> eventToInvokerFactoryMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<EventSourceKey_Subscriber<?>, OneToOneConcurrentArrayQueue<Object>> subscriberKeyToQueueMap = new ConcurrentHashMap();

    public EventFlowManager() {
        this.eventToInvokerFactoryMap.put(CallBackType.ON_EVENT_CALL_BACK, EventToOnEventInvokeStrategy::new);
    }

    public void init() {
        this.forEachLifeCycleEventSource(Lifecycle::init);
    }

    public void start() {
        this.forEachLifeCycleEventSource(Lifecycle::start);
    }

    public <T> ManyToOneConcurrentArrayQueue<T> registerEventSink(EventSourceKey<T> sinkKey, Object sinkReader) {
        Objects.requireNonNull(sinkKey, "sinkKey must be non-null");
        EventSinkKey<T> eventSinkKey = new EventSinkKey<T>(sinkKey, sinkReader);
        return this.eventSinkToQueueMap.computeIfAbsent(eventSinkKey, key -> new ManyToOneConcurrentArrayQueue(1024));
    }

    public void subscribe(EventSubscriptionKey<?> subscriptionKey) {
        Objects.requireNonNull(subscriptionKey, "subscriptionKey must be non-null");
        EventSource_QueuePublisher<?> eventSourceQueuePublisher = this.eventSourceToQueueMap.get(subscriptionKey.eventSourceKey());
        Objects.requireNonNull(eventSourceQueuePublisher, "no EventSource registered for EventSourceKey:" + String.valueOf(subscriptionKey));
        eventSourceQueuePublisher.eventSource().subscribe(subscriptionKey);
    }

    public void unSubscribe(EventSubscriptionKey<?> subscriptionKey) {
        Objects.requireNonNull(subscriptionKey, "subscriptionKey must be non-null");
        EventSource_QueuePublisher<?> eventSourceQueuePublisher = this.eventSourceToQueueMap.get(subscriptionKey.eventSourceKey());
        Objects.requireNonNull(eventSourceQueuePublisher, "no EventSource registered for EventSourceKey:" + String.valueOf(subscriptionKey));
        eventSourceQueuePublisher.eventSource().unSubscribe(subscriptionKey);
    }

    public <T> EventToQueuePublisher<T> registerEventSource(String sourceName, EventSource<T> eventSource) {
        Objects.requireNonNull(eventSource, "eventSource must be non-null");
        EventSource_QueuePublisher eventSourceQueuePublisher = this.eventSourceToQueueMap.computeIfAbsent(new EventSourceKey(sourceName), eventSourceKey -> new EventSource_QueuePublisher(new EventToQueuePublisher(sourceName), eventSource));
        EventToQueuePublisher queuePublisher = eventSourceQueuePublisher.queuePublisher();
        eventSource.setEventToQueuePublisher(queuePublisher);
        return queuePublisher;
    }

    public void registerEventMapperFactory(Supplier<EventToInvokeStrategy> eventMapper, CallBackType type) {
        Objects.requireNonNull(eventMapper, "eventMapper must be non-null");
        Objects.requireNonNull(type, "type must be non-null");
        this.eventToInvokerFactoryMap.put(type, eventMapper);
    }

    public void registerEventMapperFactory(Supplier<EventToInvokeStrategy> eventMapper, Class<?> type) {
        Objects.requireNonNull(eventMapper, "eventMapper must be non-null");
        Objects.requireNonNull(type, "Callback class type must be non-null");
        this.registerEventMapperFactory(eventMapper, CallBackType.forClass(type));
    }

    public <T> EventQueueToEventProcessor getMappingAgent(EventSourceKey<T> eventSourceKey, CallBackType type, Agent subscriber) {
        Objects.requireNonNull(eventSourceKey, "eventSourceKey must be non-null");
        Objects.requireNonNull(type, "type must be non-null");
        Objects.requireNonNull(subscriber, "subscriber must be non-null");
        Supplier<EventToInvokeStrategy> eventMapperSupplier = this.eventToInvokerFactoryMap.get(type);
        Objects.requireNonNull(eventMapperSupplier, "no EventMapper registered for type:" + String.valueOf(type));
        EventSource_QueuePublisher<T> sourcePublisher = this.getEventSourceQueuePublisherOrThrow(eventSourceKey);
        EventSourceKey_Subscriber<T> keySubscriber = new EventSourceKey_Subscriber<T>(eventSourceKey, subscriber);
        OneToOneConcurrentArrayQueue<Object> eventQueue = this.getOrCreateSubscriberQueue(keySubscriber);
        String name = EventFlowManager.buildSubscriptionName(subscriber, eventSourceKey, type);
        sourcePublisher.queuePublisher().addTargetQueue(eventQueue, name);
        Runnable unsubscribe = this.createUnsubscribeAction(sourcePublisher, name, keySubscriber);
        return new EventQueueToEventProcessorAgent(eventQueue, eventMapperSupplier.get(), name).withUnsubscribeAction(unsubscribe);
    }

    public <T> EventQueueToEventProcessor getMappingAgent(EventSubscriptionKey<T> subscriptionKey, Agent subscriber) {
        return this.getMappingAgent(subscriptionKey.eventSourceKey(), subscriptionKey.callBackType(), subscriber);
    }

    public void appendQueueInformation(Appendable appendable) {
        if (this.eventSourceToQueueMap.isEmpty()) {
            EventFlowManager.safeAppend(appendable, "No event readers registered");
            return;
        }
        this.eventSourceToQueueMap.forEach((key, value) -> EventFlowManager.appendQueueDetails(appendable, key.sourceName(), value.queuePublisher()));
    }

    private void forEachLifeCycleEventSource(Consumer<LifeCycleEventSource> action) {
        this.eventSourceToQueueMap.values().stream().map(EventSource_QueuePublisher::eventSource).filter(LifeCycleEventSource.class::isInstance).map(LifeCycleEventSource.class::cast).forEach(action);
    }

    private <T> EventSource_QueuePublisher<T> getEventSourceQueuePublisherOrThrow(EventSourceKey<T> eventSourceKey) {
        EventSource_QueuePublisher<?> publisher = this.eventSourceToQueueMap.get(eventSourceKey);
        return Objects.requireNonNull(publisher, "no EventSource registered for EventSourceKey:" + String.valueOf(eventSourceKey));
    }

    private <T> OneToOneConcurrentArrayQueue<Object> getOrCreateSubscriberQueue(EventSourceKey_Subscriber<T> keySubscriber) {
        return this.subscriberKeyToQueueMap.computeIfAbsent(keySubscriber, key -> new OneToOneConcurrentArrayQueue(1024));
    }

    private static String buildSubscriptionName(Agent subscriber, EventSourceKey<?> eventSourceKey, CallBackType type) {
        return subscriber.roleName() + "/" + eventSourceKey.sourceName() + "/" + type.name();
    }

    private Runnable createUnsubscribeAction(EventSource_QueuePublisher<?> sourcePublisher, String name, EventSourceKey_Subscriber<?> keySubscriber) {
        return () -> {
            sourcePublisher.queuePublisher().removeTargetQueueByName(name);
            this.subscriberKeyToQueueMap.remove(keySubscriber);
        };
    }

    private static void safeAppend(Appendable appendable, String text) {
        try {
            appendable.append(text);
        }
        catch (IOException ex) {
            System.err.println("problem logging event queues, exception:" + String.valueOf(ex));
        }
    }

    private static void appendQueueDetails(Appendable appendable, String sourceName, EventToQueuePublisher<?> queue) {
        try {
            appendable.append("eventSource:").append(sourceName).append("\n\treadQueues:\n");
            for (EventToQueuePublisher.NamedQueue q : queue.getTargetQueues()) {
                appendable.append("\t\t").append(q.name()).append(" -> ").append(q.targetQueue().toString()).append("\n");
            }
        }
        catch (IOException ex) {
            System.err.println("problem logging event queues, exception:" + String.valueOf(ex));
        }
    }

    private record EventSinkKey<T>(EventSourceKey<T> eventSourceKey, Object subscriber) {
    }

    private record EventSource_QueuePublisher<T>(EventToQueuePublisher<T> queuePublisher, EventSource<T> eventSource) {
    }

    private record EventSourceKey_Subscriber<T>(EventSourceKey<T> eventSourceKey, Object subscriber) {
    }
}

