/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.dispatch;

import java.util.Random;

public class ExponentialBackoff {
    private final long baseDelay;
    private final long maxDelay;
    private final Random random = new Random();
    private int attempts = 0;
    private long currentDelay = 0L;

    public ExponentialBackoff(long baseDelay, long maxDelay) {
        this.baseDelay = baseDelay;
        this.maxDelay = maxDelay;
    }

    public long getWaitTime() {
        if (this.currentDelay < this.maxDelay) {
            long randomizedDelay;
            long delay = this.baseDelay * (long)Math.pow(2.0, this.attempts++);
            System.out.println(delay);
            this.currentDelay = randomizedDelay = delay + (long)this.random.nextInt((int)(Math.max(10L, delay) / 10L));
            return Math.min(randomizedDelay, this.maxDelay);
        }
        return this.maxDelay;
    }

    public static void main(String[] args) throws InterruptedException {
        ExponentialBackoff backoff = new ExponentialBackoff(4L, 100L);
        for (int i = 10; i < 50; ++i) {
            long delay = backoff.getWaitTime();
            System.out.println("Attempt " + (i + 1) + ", waiting " + delay + " ms");
            Thread.sleep(delay);
        }
    }
}

