/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.dispatch;

import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class RetryPolicy {
    private final int maxAttempts;
    private final long initialBackoffMillis;
    private final long maxBackoffMillis;
    private final double multiplier;
    private final Set<Class<? extends Throwable>> retryOn;

    public RetryPolicy(int maxAttempts, long initialBackoffMillis, long maxBackoffMillis, double multiplier, Set<Class<? extends Throwable>> retryOn) {
        if (maxAttempts < 1) {
            throw new IllegalArgumentException("maxAttempts must be >=1");
        }
        if (initialBackoffMillis < 0L || maxBackoffMillis < 0L) {
            throw new IllegalArgumentException("backoff must be >=0");
        }
        if (multiplier < 1.0) {
            throw new IllegalArgumentException("multiplier must be >=1.0");
        }
        this.maxAttempts = maxAttempts;
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxBackoffMillis = Math.max(maxBackoffMillis, initialBackoffMillis);
        this.multiplier = multiplier;
        this.retryOn = retryOn;
    }

    public static RetryPolicy defaultProcessingPolicy() {
        return new RetryPolicy(3, 5L, 100L, 2.0, Set.of(RuntimeException.class));
    }

    public boolean shouldRetry(Throwable t, int attempt) {
        if (attempt >= this.maxAttempts) {
            return false;
        }
        if (this.retryOn == null || this.retryOn.isEmpty()) {
            return true;
        }
        for (Class<? extends Throwable> c : this.retryOn) {
            if (!c.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public void backoff(int attempt) {
        if (this.initialBackoffMillis <= 0L) {
            return;
        }
        long delay = (long)Math.min((double)this.maxBackoffMillis, (double)this.initialBackoffMillis * Math.pow(this.multiplier, Math.max(0, attempt - 1)));
        try {
            TimeUnit.MILLISECONDS.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public long getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    public long getMaxBackoffMillis() {
        return this.maxBackoffMillis;
    }

    public double getMultiplier() {
        return this.multiplier;
    }
}

