/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.dutycycle;

import com.fluxtion.agrona.concurrent.Agent;
import com.fluxtion.agrona.concurrent.DynamicCompositeAgent;
import com.fluxtion.agrona.concurrent.OneToOneConcurrentArrayQueue;
import com.fluxtion.runtime.annotations.feature.Experimental;
import com.fluxtion.runtime.service.Service;
import com.fluxtion.runtime.service.ServiceRegistryNode;
import com.telamin.mongoose.MongooseServer;
import com.telamin.mongoose.dispatch.EventFlowManager;
import com.telamin.mongoose.dutycycle.ServiceAgent;
import com.telamin.mongoose.internal.CoreAffinity;
import com.telamin.mongoose.internal.ServiceInjector;
import com.telamin.mongoose.service.scheduler.DeadWheelScheduler;
import com.telamin.mongoose.service.scheduler.SchedulerService;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import lombok.Generated;

@Experimental
public class ComposingServiceAgent
extends DynamicCompositeAgent {
    @Generated
    private static final Logger log = Logger.getLogger(ComposingServiceAgent.class.getName());
    private final EventFlowManager eventFlowManager;
    private final MongooseServer mongooseServer;
    private final DeadWheelScheduler scheduler;
    private final Service<SchedulerService> schedulerService;
    private final OneToOneConcurrentArrayQueue<ServiceAgent<?>> toStartList = new OneToOneConcurrentArrayQueue(128);
    private final OneToOneConcurrentArrayQueue<ServiceAgent<?>> toAddList = new OneToOneConcurrentArrayQueue(128);
    private final OneToOneConcurrentArrayQueue<ServiceAgent<?>> toCallStartupCompleteList = new OneToOneConcurrentArrayQueue(128);
    private final ServiceRegistryNode serviceRegistry = new ServiceRegistryNode();
    private final AtomicBoolean startUpComplete = new AtomicBoolean(false);

    public ComposingServiceAgent(String roleName, EventFlowManager eventFlowManager, MongooseServer mongooseServer, DeadWheelScheduler scheduler) {
        super(roleName, new Agent[]{scheduler});
        this.eventFlowManager = eventFlowManager;
        this.mongooseServer = mongooseServer;
        this.scheduler = scheduler;
        this.schedulerService = new Service((Object)scheduler, SchedulerService.class);
    }

    public <T> void registerServer(ServiceAgent<T> server) {
        this.toStartList.add(server);
        this.toCallStartupCompleteList.add(server);
        log.info("registerServer toCallStartupCompleteList size:" + this.toCallStartupCompleteList.size());
    }

    public void onStart() {
        Integer coreId;
        if (this.mongooseServer != null && (coreId = this.mongooseServer.resolveCoreIdForAgentName(this.roleName())) != null) {
            CoreAffinity.pinCurrentThreadToCore(coreId);
        }
        log.info("onStart toStartList size:" + this.toStartList.size());
        this.checkForAdded();
        super.onStart();
    }

    public int doWork() throws Exception {
        this.checkForAdded();
        return super.doWork();
    }

    public void startComplete() {
        log.info("startComplete toCallStartupCompleteList size:" + this.toCallStartupCompleteList.size());
        this.startUpComplete.set(true);
    }

    public void onClose() {
        log.info("onClose");
        super.onClose();
    }

    private void checkForAdded() {
        if (!this.toStartList.isEmpty()) {
            this.toStartList.drain(serviceAgent -> {
                this.toAddList.add(serviceAgent);
                Service exportedService = serviceAgent.exportedService();
                exportedService.init();
                this.serviceRegistry.init();
                this.serviceRegistry.nodeRegistered(exportedService.instance(), exportedService.serviceName());
                this.serviceRegistry.registerService(this.schedulerService);
                this.mongooseServer.servicesRegistered().forEach(arg_0 -> ((ServiceRegistryNode)this.serviceRegistry).registerService(arg_0));
                ArrayList inj = new ArrayList(this.mongooseServer.servicesRegistered());
                inj.add(this.schedulerService);
                ServiceInjector.inject(exportedService.instance(), inj);
                this.mongooseServer.registerAgentService(exportedService);
                exportedService.start();
            });
        }
        if (!this.toAddList.isEmpty() && this.status() == DynamicCompositeAgent.Status.ACTIVE && this.tryAdd(((ServiceAgent)this.toAddList.peek()).delegate())) {
            this.toAddList.poll();
        }
        if (this.startUpComplete.get() & !this.toCallStartupCompleteList.isEmpty()) {
            this.toCallStartupCompleteList.drain(s -> s.exportedService().startComplete());
        }
    }
}

