/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.internal;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import lombok.Generated;

public final class CoreAffinity {
    @Generated
    private static final Logger log = Logger.getLogger(CoreAffinity.class.getName());

    private CoreAffinity() {
    }

    public static boolean pinCurrentThreadToCore(int coreId) {
        try {
            Class<?> affinityCls = Class.forName("net.openhft.affinity.Affinity");
            try {
                Method m = affinityCls.getMethod("setAffinity", Integer.TYPE);
                m.invoke(null, coreId);
                log.info(() -> "Pinned thread '" + Thread.currentThread().getName() + "' to core " + coreId + " using OpenHFT Affinity");
                return true;
            }
            catch (NoSuchMethodException nsme) {
                Class<?> lockCls = Class.forName("net.openhft.affinity.AffinityLock");
                Method acquireCore = lockCls.getMethod("acquireLock", Integer.TYPE);
                Object lock = acquireCore.invoke(null, coreId);
                log.info(() -> "Pinned thread '" + Thread.currentThread().getName() + "' to core " + coreId + " using OpenHFT AffinityLock");
                return true;
            }
        }
        catch (Throwable t) {
            log.info(() -> "Core pin requested for core " + coreId + ", but no supported affinity library was found. Running unpinned.");
            return false;
        }
    }
}

