/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.internal;

import com.fluxtion.agrona.concurrent.AgentRunner;
import com.fluxtion.agrona.concurrent.DynamicCompositeAgent;
import com.fluxtion.runtime.service.Service;
import com.fluxtion.runtime.service.ServiceRegistryNode;
import com.telamin.mongoose.MongooseServer;
import com.telamin.mongoose.dispatch.EventFlowManager;
import com.telamin.mongoose.service.LifeCycleEventSource;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import lombok.Generated;

public final class LifecycleManager {
    @Generated
    private static final Logger log = Logger.getLogger(LifecycleManager.class.getName());
    private final MongooseServer server;

    public LifecycleManager(MongooseServer server) {
        this.server = server;
    }

    public void init(Map<String, Service<?>> registeredServices, Set<Service<?>> registeredAgentServices, EventFlowManager flowManager, ServiceRegistryNode serviceRegistry) {
        log.info("init");
        registeredServices.values().forEach(svc -> {
            if (!(svc.instance() instanceof LifeCycleEventSource)) {
                svc.init();
            }
        });
        flowManager.init();
        registeredServices.values().forEach(svc -> {
            if (!registeredAgentServices.contains(svc)) {
                serviceRegistry.nodeRegistered(svc.instance(), svc.serviceName());
                this.server.servicesRegistered().forEach(arg_0 -> ((ServiceRegistryNode)serviceRegistry).registerService(arg_0));
            }
        });
    }

    public void start(Map<String, Service<?>> registeredServices, ConcurrentHashMap<String, ? extends GroupRunner> composingServiceAgents, ConcurrentHashMap<String, ? extends GroupRunner> composingEventProcessorAgents, EventFlowManager flowManager, Set<Service<?>> registeredAgentServices) throws InterruptedException {
        log.info("start");
        registeredServices.values().forEach(svc -> {
            if (!(svc.instance() instanceof LifeCycleEventSource)) {
                svc.start();
            }
        });
        log.info("start flowManager");
        flowManager.start();
        log.info("start agent hosted services");
        composingServiceAgents.forEach((k, v) -> {
            log.info("starting composing service agent " + k);
            AgentRunner.startOnThread((AgentRunner)v.getGroupRunner());
        });
        boolean waiting = true;
        log.info("waiting for agent hosted services to start");
        while (waiting) {
            waiting = composingServiceAgents.values().stream().anyMatch(f -> f.getGroup().status() != DynamicCompositeAgent.Status.ACTIVE);
            Thread.sleep(10L);
            log.finer("checking all service agents are started");
        }
        log.info("start event processor agent workers");
        composingEventProcessorAgents.forEach((k, v) -> {
            log.info("starting composing event processor agent " + k);
            AgentRunner.startOnThread((AgentRunner)v.getGroupRunner());
        });
        waiting = true;
        log.info("waiting for event processor agents to start");
        while (waiting) {
            waiting = composingEventProcessorAgents.values().stream().anyMatch(f -> f.getGroup().status() != DynamicCompositeAgent.Status.ACTIVE);
            Thread.sleep(10L);
            log.finer("checking all processor agents are started");
        }
        log.info("calling startup complete on services");
        for (Service<?> service : registeredServices.values()) {
            if (registeredAgentServices.contains(service)) continue;
            service.startComplete();
        }
        log.info("calling startup complete on agent hosted services");
        composingServiceAgents.values().forEach(GroupRunner::startCompleteIfSupported);
    }

    public void stop(boolean started, ConcurrentHashMap<String, ? extends GroupRunner> composingEventProcessorAgents, ConcurrentHashMap<String, ? extends GroupRunner> composingServiceAgents, Map<String, Service<?>> registeredServices) {
        log.info("stopping server");
        if (!started) {
            log.info("server not started, nothing to stop");
            return;
        }
        log.info("stopping event processor agents");
        composingEventProcessorAgents.forEach((k, v) -> {
            log.info("stopping composing event processor agent " + k);
            AgentRunner groupRunner = v.getGroupRunner();
            if (groupRunner.thread() != null) {
                groupRunner.close();
            }
        });
        log.info("stopping agent hosted services");
        composingServiceAgents.forEach((k, v) -> {
            log.info("stopping composing service agent " + k);
            AgentRunner groupRunner = v.getGroupRunner();
            if (groupRunner.thread() != null) {
                groupRunner.close();
            }
        });
        log.info("stopping registered services");
        for (Service<?> service : registeredServices.values()) {
            if (service.instance() instanceof LifeCycleEventSource) continue;
            service.stop();
        }
    }

    public static interface GroupRunner {
        public AgentRunner getGroupRunner();

        public DynamicCompositeAgent getGroup();

        default public void startCompleteIfSupported() {
        }
    }
}

