/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.internal;

import com.fluxtion.agrona.concurrent.IdleStrategy;
import com.fluxtion.runtime.EventProcessor;
import com.fluxtion.runtime.audit.EventLogControlEvent;
import com.fluxtion.runtime.audit.LogRecordListener;
import com.fluxtion.runtime.service.Service;
import com.telamin.mongoose.MongooseServer;
import com.telamin.mongoose.config.ConfigListener;
import com.telamin.mongoose.config.ConfigMap;
import com.telamin.mongoose.config.EventProcessorConfig;
import com.telamin.mongoose.config.MongooseServerConfig;
import com.telamin.mongoose.config.ServiceConfig;
import com.telamin.mongoose.dutycycle.GlobalErrorHandler;
import com.telamin.mongoose.service.CallBackType;
import com.telamin.mongoose.service.EventToInvokeStrategy;
import com.telamin.mongoose.service.pool.ObjectPoolsRegistry;
import com.telamin.mongoose.service.pool.impl.Pools;
import com.telamin.mongoose.service.servercontrol.MongooseServerController;
import java.util.Objects;
import java.util.function.Supplier;

public final class ServerConfigurator {
    private ServerConfigurator() {
    }

    public static MongooseServer bootFromConfig(MongooseServerConfig mongooseServerConfig, LogRecordListener logRecordListener) {
        Objects.requireNonNull(mongooseServerConfig, "mongooseServerConfig must be non-null");
        Objects.requireNonNull(logRecordListener, "logRecordListener must be non-null");
        MongooseServer mongooseServer = new MongooseServer(mongooseServerConfig);
        mongooseServer.setDefaultErrorHandler(new GlobalErrorHandler());
        if (mongooseServerConfig.getEventInvokeStrategies() != null && !mongooseServerConfig.getEventInvokeStrategies().isEmpty()) {
            mongooseServerConfig.getEventInvokeStrategies().forEach((type, factory) -> mongooseServer.registerEventMapperFactory((Supplier<EventToInvokeStrategy>)factory, (CallBackType)type));
        }
        mongooseServer.registerService(new Service((Object)mongooseServer, MongooseServerController.class, "com.telamin.mongoose.service.servercontrol.MongooseServerController"));
        mongooseServer.registerService(new Service((Object)Pools.SHARED, ObjectPoolsRegistry.class, "com.telamin.mongoose.pool.ObjectPoolsRegistry"));
        if (mongooseServerConfig.getEventFeeds() != null) {
            mongooseServerConfig.getEventFeeds().forEach(server -> {
                if (server.isAgent()) {
                    mongooseServer.registerEventFeedWorker(server.toServiceAgent(), server.getValueMapper());
                } else {
                    mongooseServer.registerEventFeed(server.toService(), server.getValueMapper());
                }
            });
        }
        if (mongooseServerConfig.getEventSinks() != null) {
            mongooseServerConfig.getEventSinks().forEach(server -> {
                if (server.isAgent()) {
                    mongooseServer.registerEventSinkWorker(server.toServiceAgent(), server.getValueMapper());
                } else {
                    mongooseServer.registerEventSink(server.toService(), server.getValueMapper());
                }
            });
        }
        if (mongooseServerConfig.getServices() != null) {
            for (ServiceConfig<?> serviceConfig : mongooseServerConfig.getServices()) {
                if (serviceConfig.isAgent()) {
                    mongooseServer.registerWorkerService(serviceConfig.toServiceAgent());
                    continue;
                }
                mongooseServer.registerService(serviceConfig.toService());
            }
        }
        if (mongooseServerConfig.getEventHandlers() != null) {
            mongooseServerConfig.getEventHandlers().forEach(cfg -> {
                EventLogControlEvent.LogLevel defaultLogLevel = cfg.getLogLevel() == null ? EventLogControlEvent.LogLevel.INFO : cfg.getLogLevel();
                String groupName = cfg.getAgentName();
                IdleStrategy idleStrategy1 = cfg.getIdleStrategy();
                IdleStrategy idleStrategy = mongooseServerConfig.lookupIdleStrategyWhenNull(idleStrategy1, cfg.getAgentName());
                cfg.getEventHandlers().entrySet().forEach(handlerEntry -> {
                    String name = (String)handlerEntry.getKey();
                    try {
                        mongooseServer.addEventProcessor(name, groupName, idleStrategy, () -> {
                            EventProcessorConfig eventProcessorConfig = (EventProcessorConfig)handlerEntry.getValue();
                            Object eventProcessor = eventProcessorConfig.getEventHandler() == null ? (EventProcessor)eventProcessorConfig.getEventHandlerBuilder().get() : eventProcessorConfig.getEventHandler();
                            EventLogControlEvent.LogLevel logLevel = eventProcessorConfig.getLogLevel() == null ? defaultLogLevel : eventProcessorConfig.getLogLevel();
                            ConfigMap configMap = eventProcessorConfig.getConfig();
                            eventProcessor.setAuditLogProcessor(logRecordListener);
                            eventProcessor.setAuditLogLevel(logLevel);
                            eventProcessor.init();
                            eventProcessor.consumeServiceIfExported(ConfigListener.class, l -> l.initialConfig(configMap));
                            return eventProcessor;
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            });
        }
        mongooseServer.init();
        mongooseServer.start();
        return mongooseServer;
    }
}

