/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.internal;

import com.fluxtion.runtime.annotations.runtime.ServiceRegistered;
import com.fluxtion.runtime.service.Service;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ServiceInjector {
    private static final Logger LOG = Logger.getLogger(ServiceInjector.class.getName());

    private ServiceInjector() {
    }

    public static void inject(Object target, Collection<Service<?>> services) {
        Method[] methods;
        if (target == null || services == null || services.isEmpty()) {
            return;
        }
        Class<?> targetClass = target.getClass();
        try {
            methods = targetClass.getMethods();
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, "ServiceInjector: unable to introspect methods for {0}: {1}", new Object[]{targetClass, t});
            return;
        }
        HashMap byType = new HashMap();
        for (Service<?> svc : services) {
            Class iface = svc.serviceClass();
            byType.computeIfAbsent(iface, k -> new ArrayList()).add(svc);
        }
        for (Method m : methods) {
            Class<?> type;
            if (!m.isAnnotationPresent(ServiceRegistered.class)) continue;
            Class<?>[] params = m.getParameterTypes();
            if (params.length == 1) {
                type = params[0];
                ServiceInjector.injectSingle(target, m, type, byType);
                continue;
            }
            if (params.length == 2 && params[1] == String.class) {
                type = params[0];
                ServiceInjector.injectPair(target, m, type, byType);
                continue;
            }
            LOG.log(Level.FINE, "ServiceInjector: unsupported @ServiceRegistered method signature {0} on {1}", new Object[]{m, targetClass});
        }
    }

    private static void injectSingle(Object target, Method m, Class<?> type, Map<Class<?>, List<Service<?>>> byType) {
        List<Service<?>> matches = ServiceInjector.findAssignable(byType, type);
        for (Service<?> svc : matches) {
            try {
                m.invoke(target, svc.instance());
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "ServiceInjector: error invoking method {0} with service {1}: {2}", new Object[]{m, svc, t});
            }
        }
    }

    private static void injectPair(Object target, Method m, Class<?> type, Map<Class<?>, List<Service<?>>> byType) {
        List<Service<?>> matches = ServiceInjector.findAssignable(byType, type);
        for (Service<?> svc : matches) {
            try {
                m.invoke(target, svc.instance(), svc.serviceName());
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "ServiceInjector: error invoking method {0} with service {1}: {2}", new Object[]{m, svc, t});
            }
        }
    }

    private static List<Service<?>> findAssignable(Map<Class<?>, List<Service<?>>> byType, Class<?> paramType) {
        ArrayList result = new ArrayList();
        List<Service<?>> exact = byType.get(paramType);
        if (exact != null) {
            result.addAll(exact);
        }
        for (Map.Entry<Class<?>, List<Service<?>>> e : byType.entrySet()) {
            Class<?> iface = e.getKey();
            if (!paramType.isAssignableFrom(iface) || iface == paramType) continue;
            result.addAll((Collection)e.getValue());
        }
        return result;
    }
}

