/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.service;

import com.telamin.mongoose.service.CallBackType;
import com.telamin.mongoose.service.EventSourceKey;

public record EventSubscriptionKey<T>(EventSourceKey<T> eventSourceKey, CallBackType callBackType) {
    public EventSubscriptionKey(EventSourceKey<T> eventSourceKey, Class<?> callBackClass) {
        this(eventSourceKey, CallBackType.forClass(callBackClass));
    }

    public EventSubscriptionKey(EventSourceKey<T> eventSourceKey, CallBackType callBackType, Object qualifier) {
        this(eventSourceKey, callBackType);
    }

    public static <T> EventSubscriptionKey<T> onEvent(String sourceName) {
        return new EventSubscriptionKey(EventSourceKey.of(sourceName), CallBackType.ON_EVENT_CALL_BACK);
    }

    public static <T> EventSubscriptionKey<T> of(String sourceName, CallBackType callBackType) {
        return new EventSubscriptionKey(EventSourceKey.of(sourceName), callBackType);
    }

    public static <T> EventSubscriptionKey<T> of(EventSourceKey<T> eventSourceKey, CallBackType callBackType) {
        return new EventSubscriptionKey<T>(eventSourceKey, callBackType);
    }

    public static <T> Builder<T> fromSource(String sourceName) {
        return new Builder(EventSourceKey.of(sourceName));
    }

    public static <T> Builder<T> builder(EventSourceKey<T> sourceKey) {
        return new Builder<T>(sourceKey);
    }

    public static final class Builder<T> {
        private final EventSourceKey<T> eventSourceKey;
        private CallBackType callBackType = CallBackType.ON_EVENT_CALL_BACK;

        private Builder(EventSourceKey<T> eventSourceKey) {
            this.eventSourceKey = eventSourceKey;
        }

        public Builder<T> callback(CallBackType type) {
            this.callBackType = type;
            return this;
        }

        public Builder<T> callback(Class<?> callbackClass) {
            this.callBackType = CallBackType.forClass(callbackClass);
            return this;
        }

        public Builder<T> onEvent() {
            this.callBackType = CallBackType.ON_EVENT_CALL_BACK;
            return this;
        }

        public EventSubscriptionKey<T> build() {
            return new EventSubscriptionKey<T>(this.eventSourceKey, this.callBackType);
        }
    }
}

