/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.service.admin.impl;

import com.fluxtion.runtime.annotations.feature.Experimental;
import com.telamin.mongoose.dispatch.EventToQueuePublisher;
import com.telamin.mongoose.exception.AdminCommandException;
import com.telamin.mongoose.service.admin.AdminCommandRequest;
import com.telamin.mongoose.service.admin.AdminFunction;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;

@Experimental
public class AdminCommand {
    private Consumer<Object> output;
    private Consumer<Object> errOutput;
    private AdminFunction<Object, Object> commandWithOutput;
    private final EventToQueuePublisher<AdminCommand> targetQueue;
    private final Semaphore semaphore = new Semaphore(1);
    private transient List<String> args;

    public AdminCommand(AdminFunction<Object, Object> commandWithOutput, EventToQueuePublisher<AdminCommand> targetQueue) {
        this.commandWithOutput = commandWithOutput;
        this.output = System.out::println;
        this.errOutput = System.err::println;
        this.targetQueue = targetQueue;
    }

    public AdminCommand(AdminFunction<Object, Object> commandWithOutput) {
        this.commandWithOutput = commandWithOutput;
        this.output = System.out::println;
        this.errOutput = System.err::println;
        this.targetQueue = null;
    }

    public AdminCommand(AdminCommand adminCommand, AdminCommandRequest adminCommandRequest) {
        this.commandWithOutput = adminCommand.commandWithOutput;
        this.targetQueue = adminCommand.targetQueue;
        this.output = adminCommandRequest.getOutput();
        this.errOutput = adminCommandRequest.getErrOutput();
        this.args = new ArrayList<String>(adminCommandRequest.getArguments());
        this.args.add(0, adminCommandRequest.getCommand());
    }

    public void publishCommand(AdminCommandRequest adminCommandRequest) {
        AdminCommand adminCommand = new AdminCommand(this, adminCommandRequest);
        adminCommand.publishCommand(adminCommand.args);
    }

    public void publishCommand(List<String> value) {
        if (this.targetQueue == null) {
            this.commandWithOutput.processAdminCommand(value, this.output, this.errOutput);
        } else {
            try {
                if (this.semaphore.tryAcquire(1L, TimeUnit.SECONDS)) {
                    this.args = value;
                    this.targetQueue.publish(this);
                    this.semaphore.acquire();
                    this.semaphore.release();
                } else {
                    this.output.accept("command is busy try again");
                }
            }
            catch (InterruptedException e) {
                throw new AdminCommandException("Interrupted while publishing admin command", e);
            }
        }
    }

    public void executeCommand() {
        try {
            this.commandWithOutput.processAdminCommand(this.args, this.output, this.errOutput);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.errOutput.accept("problem executing command exception:" + e.getMessage() + "\n" + String.valueOf(sw));
        }
        finally {
            this.semaphore.release();
        }
    }

    @Generated
    public Consumer<Object> getOutput() {
        return this.output;
    }

    @Generated
    public Consumer<Object> getErrOutput() {
        return this.errOutput;
    }

    @Generated
    public AdminFunction<Object, Object> getCommandWithOutput() {
        return this.commandWithOutput;
    }

    @Generated
    public EventToQueuePublisher<AdminCommand> getTargetQueue() {
        return this.targetQueue;
    }

    @Generated
    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    @Generated
    public List<String> getArgs() {
        return this.args;
    }

    @Generated
    public void setOutput(Consumer<Object> output) {
        this.output = output;
    }

    @Generated
    public void setErrOutput(Consumer<Object> errOutput) {
        this.errOutput = errOutput;
    }

    @Generated
    public void setCommandWithOutput(AdminFunction<Object, Object> commandWithOutput) {
        this.commandWithOutput = commandWithOutput;
    }

    @Generated
    public void setArgs(List<String> args) {
        this.args = args;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdminCommand)) {
            return false;
        }
        AdminCommand other = (AdminCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Consumer<Object> this$output = this.getOutput();
        Consumer<Object> other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        Consumer<Object> this$errOutput = this.getErrOutput();
        Consumer<Object> other$errOutput = other.getErrOutput();
        if (this$errOutput == null ? other$errOutput != null : !this$errOutput.equals(other$errOutput)) {
            return false;
        }
        AdminFunction<Object, Object> this$commandWithOutput = this.getCommandWithOutput();
        AdminFunction<Object, Object> other$commandWithOutput = other.getCommandWithOutput();
        if (this$commandWithOutput == null ? other$commandWithOutput != null : !this$commandWithOutput.equals(other$commandWithOutput)) {
            return false;
        }
        EventToQueuePublisher<AdminCommand> this$targetQueue = this.getTargetQueue();
        EventToQueuePublisher<AdminCommand> other$targetQueue = other.getTargetQueue();
        if (this$targetQueue == null ? other$targetQueue != null : !this$targetQueue.equals(other$targetQueue)) {
            return false;
        }
        Semaphore this$semaphore = this.getSemaphore();
        Semaphore other$semaphore = other.getSemaphore();
        return !(this$semaphore == null ? other$semaphore != null : !this$semaphore.equals(other$semaphore));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdminCommand;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Consumer<Object> $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        Consumer<Object> $errOutput = this.getErrOutput();
        result = result * 59 + ($errOutput == null ? 43 : $errOutput.hashCode());
        AdminFunction<Object, Object> $commandWithOutput = this.getCommandWithOutput();
        result = result * 59 + ($commandWithOutput == null ? 43 : $commandWithOutput.hashCode());
        EventToQueuePublisher<AdminCommand> $targetQueue = this.getTargetQueue();
        result = result * 59 + ($targetQueue == null ? 43 : $targetQueue.hashCode());
        Semaphore $semaphore = this.getSemaphore();
        result = result * 59 + ($semaphore == null ? 43 : $semaphore.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AdminCommand(output=" + String.valueOf(this.getOutput()) + ", errOutput=" + String.valueOf(this.getErrOutput()) + ", commandWithOutput=" + String.valueOf(this.getCommandWithOutput()) + ", targetQueue=" + String.valueOf(this.getTargetQueue()) + ", semaphore=" + String.valueOf(this.getSemaphore()) + ", args=" + String.valueOf(this.getArgs()) + ")";
    }

    @Generated
    public AdminCommand(Consumer<Object> output, Consumer<Object> errOutput, AdminFunction<Object, Object> commandWithOutput, EventToQueuePublisher<AdminCommand> targetQueue, List<String> args) {
        this.output = output;
        this.errOutput = errOutput;
        this.commandWithOutput = commandWithOutput;
        this.targetQueue = targetQueue;
        this.args = args;
    }
}

