/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.service.admin.impl;

import com.fluxtion.runtime.StaticEventProcessor;
import com.fluxtion.runtime.annotations.feature.Experimental;
import com.telamin.mongoose.dispatch.EventFlowManager;
import com.telamin.mongoose.dispatch.EventToQueuePublisher;
import com.telamin.mongoose.dispatch.ProcessorContext;
import com.telamin.mongoose.service.CallBackType;
import com.telamin.mongoose.service.EventSourceKey;
import com.telamin.mongoose.service.EventSubscriptionKey;
import com.telamin.mongoose.service.LifeCycleEventSource;
import com.telamin.mongoose.service.admin.AdminCommandRegistry;
import com.telamin.mongoose.service.admin.AdminCommandRequest;
import com.telamin.mongoose.service.admin.AdminFunction;
import com.telamin.mongoose.service.admin.impl.AdminCommand;
import com.telamin.mongoose.service.admin.impl.AdminCommandInvoker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;

@Experimental
public class AdminCommandProcessor
implements AdminCommandRegistry,
LifeCycleEventSource<AdminCommand> {
    @Generated
    private static final Logger log = Logger.getLogger(AdminCommandProcessor.class.getName());
    private final Map<String, AdminCommand> registeredCommandMap = new HashMap<String, AdminCommand>();
    private EventFlowManager eventFlowManager;
    private static final String HELP_MESSAGE = "default commands:\n---------------------------\nquit         - exit the console\nhelp/?       - this message\ncommands     - registered service commands\neventSources - list event sources\n";

    public void init() {
        log.info("init");
    }

    @Override
    public void setEventFlowManager(EventFlowManager eventFlowManager, String serviceName) {
        this.eventFlowManager = eventFlowManager;
        eventFlowManager.registerEventMapperFactory(AdminCommandInvoker::new, AdminCallbackType.class);
    }

    public void start() {
        log.info("start");
        this.registerCommand("help", this::printHelp);
        this.registerCommand("?", this::printHelp);
        this.registerCommand("eventSources", this::printQueues);
        this.registerCommand("commands", this::registeredCommands);
    }

    @Override
    public void processAdminCommandRequest(AdminCommandRequest command) {
        String commandName = command.getCommand().trim();
        log.info("processing: " + String.valueOf(command) + " name: '" + commandName + "'");
        AdminCommand adminCommand = this.registeredCommandMap.get(commandName);
        if (adminCommand != null) {
            adminCommand.publishCommand(command);
        } else {
            log.info("command not found: " + commandName);
        }
    }

    @Override
    public <OUT, ERR> void registerCommand(String name, AdminFunction<OUT, ERR> command) {
        if (ProcessorContext.currentProcessor() == null) {
            this.registeredCommandMap.put(name, new AdminCommand(command));
        } else {
            String queueKey = "adminCommand." + name;
            this.addCommand(name, queueKey, new AdminCommand(command, this.eventFlowManager.registerEventSource(queueKey, this)));
        }
    }

    @Override
    public List<String> commandList() {
        return this.registeredCommandMap.keySet().stream().sorted().collect(Collectors.toList());
    }

    public void stop() {
        log.info("stop");
    }

    public void tearDown() {
        log.info("stop");
    }

    private void printHelp(List<String> args, Consumer<String> out, Consumer<String> err) {
        out.accept(HELP_MESSAGE);
    }

    private void printQueues(List<String> args, Consumer<String> out, Consumer<String> err) {
        StringBuilder sb = new StringBuilder();
        this.eventFlowManager.appendQueueInformation(sb);
        out.accept(sb.toString());
    }

    private void registeredCommands(List<String> args, Consumer<String> out, Consumer<String> err) {
        String commandsString = this.registeredCommandMap.keySet().stream().sorted().collect(Collectors.joining("\n", "Service commands:\n---------------------------\n", "\n"));
        out.accept(commandsString);
    }

    private void addCommand(String name, String queueKey, AdminCommand adminCommand) {
        StaticEventProcessor staticEventProcessor = ProcessorContext.currentProcessor();
        log.info("registered command:" + name + " queue:" + queueKey + " processor:" + String.valueOf(staticEventProcessor));
        this.registeredCommandMap.put(name, adminCommand);
        EventSubscriptionKey subscriptionKey = new EventSubscriptionKey(new EventSourceKey(queueKey), AdminCallbackType.class);
        staticEventProcessor.getSubscriptionManager().subscribe(subscriptionKey);
    }

    @Override
    public void subscribe(EventSubscriptionKey<AdminCommand> eventSourceKey) {
    }

    @Override
    public void unSubscribe(EventSubscriptionKey<AdminCommand> eventSourceKey) {
    }

    @Override
    public void setEventToQueuePublisher(EventToQueuePublisher<AdminCommand> targetQueue) {
    }

    private static class AdminCallbackType
    implements CallBackType {
        private AdminCallbackType() {
        }

        @Override
        public String name() {
            return "AdminCallback";
        }
    }
}

