/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.service.admin.impl;

import com.fluxtion.runtime.annotations.feature.Experimental;
import com.fluxtion.runtime.annotations.runtime.ServiceRegistered;
import com.fluxtion.runtime.lifecycle.Lifecycle;
import com.telamin.mongoose.service.admin.AdminCommandRegistry;
import com.telamin.mongoose.service.admin.AdminCommandRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import lombok.Generated;

@Experimental
public class CliAdminCommandProcessor
implements Lifecycle {
    @Generated
    private static final Logger log = Logger.getLogger(CliAdminCommandProcessor.class.getName());
    private static final AtomicBoolean runLoop = new AtomicBoolean(true);
    private ExecutorService executorService;
    private AdminCommandRegistry adminCommandRegistry;

    public void init() {
        log.info("init");
        this.executorService = Executors.newSingleThreadExecutor();
    }

    @ServiceRegistered
    public void adminRegistry(AdminCommandRegistry adminCommandRegistry, String name) {
        log.info("AdminCommandRegistry available name: " + name);
        this.adminCommandRegistry = adminCommandRegistry;
    }

    public void start() {
        log.info("start");
        this.executorService.submit(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.info("starting");
            Scanner scanner = new Scanner(System.in);
            while (runLoop.get()) {
                System.out.print("Command > ");
                String[] commandArgs = scanner.nextLine().trim().split(" ");
                if (commandArgs.length <= 0) continue;
                AdminCommandRequest adminCommandRequest = new AdminCommandRequest();
                ArrayList<String> commandArgsList = new ArrayList<String>(Arrays.asList(commandArgs));
                commandArgsList.remove(0);
                adminCommandRequest.setCommand(commandArgs[0]);
                adminCommandRequest.setArguments(commandArgsList);
                adminCommandRequest.setOutput(System.out::println);
                adminCommandRequest.setErrOutput(System.err::println);
                log.info("adminCommandRequest: " + String.valueOf(adminCommandRequest));
                if (this.adminCommandRegistry == null) continue;
                this.adminCommandRegistry.processAdminCommandRequest(adminCommandRequest);
            }
        });
    }

    public void stop() {
        log.info("stop");
        runLoop.set(false);
    }

    public void tearDown() {
        log.info("stop");
        runLoop.set(false);
        this.executorService.shutdown();
    }
}

