/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.service.error;

import com.telamin.mongoose.service.error.ErrorEvent;
import com.telamin.mongoose.service.error.ErrorListener;
import com.telamin.mongoose.service.error.ErrorReporter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;

public class DefaultErrorReporter
implements ErrorReporter {
    @Generated
    private static final Logger log = Logger.getLogger(DefaultErrorReporter.class.getName());
    private final CopyOnWriteArrayList<ErrorListener> listeners = new CopyOnWriteArrayList();
    private final ArrayDeque<ErrorEvent> ring = new ArrayDeque(128);
    private final int capacity;

    public DefaultErrorReporter() {
        this(100);
    }

    public DefaultErrorReporter(int capacity) {
        this.capacity = Math.max(1, capacity);
    }

    @Override
    public void addListener(ErrorListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    @Override
    public void removeListener(ErrorListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(ErrorEvent event) {
        Level level;
        if (event == null) {
            return;
        }
        ArrayDeque<ErrorEvent> arrayDeque = this.ring;
        synchronized (arrayDeque) {
            if (this.ring.size() >= this.capacity) {
                this.ring.removeFirst();
            }
            this.ring.addLast(event);
        }
        switch (event.getSeverity()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INFO: {
                Level level2 = Level.INFO;
                break;
            }
            case WARNING: {
                Level level2 = Level.WARNING;
                break;
            }
            case ERROR: 
            case CRITICAL: {
                Level level2 = level = Level.SEVERE;
            }
        }
        if (event.getError() != null) {
            log.log(level, event.getSource() + ": " + event.getMessage(), event.getError());
        } else {
            log.log(level, event.getSource() + ": " + event.getMessage());
        }
        for (ErrorListener l : this.listeners) {
            try {
                l.onError(event);
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "error listener threw exception: " + String.valueOf(l) + ", error=" + String.valueOf(t), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ErrorEvent> recent(int limit) {
        ArrayList<ErrorEvent> list = new ArrayList<ErrorEvent>();
        if (limit <= 0) {
            return list;
        }
        ArrayDeque<ErrorEvent> arrayDeque = this.ring;
        synchronized (arrayDeque) {
            int size = this.ring.size();
            int start = Math.max(0, size - limit);
            int i = 0;
            for (ErrorEvent e : this.ring) {
                if (i++ < start) continue;
                list.add(e);
            }
        }
        return list;
    }
}

