/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.service.error;

import java.time.Instant;
import java.util.Objects;

public final class ErrorEvent {
    private final Instant timestamp = Instant.now();
    private final String source;
    private final String message;
    private final Throwable error;
    private final Severity severity;

    public ErrorEvent(String source, String message, Throwable error, Severity severity) {
        this.source = source == null ? "unknown" : source;
        this.message = message == null ? "" : message;
        this.error = error;
        this.severity = severity == null ? Severity.ERROR : severity;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getError() {
        return this.error;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        return "ErrorEvent{timestamp=" + String.valueOf(this.timestamp) + ", source='" + this.source + "', message='" + this.message + "', severity=" + String.valueOf((Object)this.severity) + (String)(this.error != null ? ", error=" + String.valueOf(this.error) : "") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ErrorEvent)) {
            return false;
        }
        ErrorEvent that = (ErrorEvent)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.source, that.source) && Objects.equals(this.message, that.message) && this.severity == that.severity && Objects.equals(this.error == null ? null : this.error.toString(), that.error == null ? null : that.error.toString());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.source, this.message, this.severity});
    }

    public static enum Severity {
        INFO,
        WARNING,
        ERROR,
        CRITICAL;

    }
}

