/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.service.extension;

import com.fluxtion.runtime.StaticEventProcessor;
import com.fluxtion.runtime.annotations.runtime.ServiceRegistered;
import com.fluxtion.runtime.input.NamedFeed;
import com.fluxtion.runtime.input.SubscriptionManager;
import com.fluxtion.runtime.node.EventSubscription;
import com.telamin.mongoose.dispatch.EventFlowManager;
import com.telamin.mongoose.dispatch.EventToQueuePublisher;
import com.telamin.mongoose.dispatch.ProcessorContext;
import com.telamin.mongoose.service.CallBackType;
import com.telamin.mongoose.service.EventSource;
import com.telamin.mongoose.service.EventSourceKey;
import com.telamin.mongoose.service.EventSubscriptionKey;
import com.telamin.mongoose.service.EventToInvokeStrategy;
import com.telamin.mongoose.service.LifeCycleEventSource;
import com.telamin.mongoose.service.scheduler.SchedulerService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import lombok.Generated;

public abstract class AbstractEventSourceService<T>
implements NamedFeed,
LifeCycleEventSource<T> {
    @Generated
    private static final Logger log = Logger.getLogger(AbstractEventSourceService.class.getName());
    protected String name;
    private final CallBackType eventToInvokeType;
    private final Supplier<EventToInvokeStrategy> eventToInokeStrategySupplier;
    protected EventToQueuePublisher<T> output;
    protected String serviceName;
    protected EventSubscriptionKey<T> subscriptionKey;
    protected SchedulerService scheduler;
    private EventSource.EventWrapStrategy eventWrapStrategy = EventSource.EventWrapStrategy.SUBSCRIPTION_NOWRAP;
    private EventSource.SlowConsumerStrategy slowConsumerStrategy = EventSource.SlowConsumerStrategy.BACKOFF;
    private Function<T, ?> dataMapper = Function.identity();

    protected AbstractEventSourceService(String name) {
        this(name, CallBackType.ON_EVENT_CALL_BACK);
    }

    public AbstractEventSourceService(String name, CallBackType eventToInvokeType) {
        this(name, eventToInvokeType, null);
    }

    public AbstractEventSourceService(String name, CallBackType eventToInvokeType, Supplier<EventToInvokeStrategy> eventToInokeStrategySupplier) {
        this.name = name;
        this.eventToInvokeType = eventToInvokeType;
        this.eventToInokeStrategySupplier = eventToInokeStrategySupplier;
    }

    @Override
    public void setEventFlowManager(EventFlowManager eventFlowManager, String serviceName) {
        this.serviceName = serviceName;
        this.output = eventFlowManager.registerEventSource(serviceName, this);
        this.output.setEventWrapStrategy(this.eventWrapStrategy);
        this.output.setDataMapper(this.dataMapper);
        this.subscriptionKey = new EventSubscriptionKey(new EventSourceKey(serviceName), this.eventToInvokeType);
        if (this.eventToInokeStrategySupplier != null) {
            eventFlowManager.registerEventMapperFactory(this.eventToInokeStrategySupplier, this.eventToInvokeType);
        }
    }

    @ServiceRegistered
    public void scheduler(SchedulerService scheduler) {
        this.scheduler = scheduler;
    }

    public void init() {
    }

    public void subscribe() {
        StaticEventProcessor current = ProcessorContext.currentProcessor();
        log.info("adding subscription for service '" + this.serviceName + "' to '" + String.valueOf(current) + "'");
        if (current == null) {
            log.warning("subscribe called with no current processor in context; skipping subscription for service '" + this.serviceName + "'");
            return;
        }
        SubscriptionManager subscriptionManager = current.getSubscriptionManager();
        subscriptionManager.subscribe(this.subscriptionKey);
    }

    public void tearDown() {
    }

    public void registerSubscriber(StaticEventProcessor subscriber) {
        if (this.eventWrapStrategy == EventSource.EventWrapStrategy.BROADCAST_NOWRAP || this.eventWrapStrategy == EventSource.EventWrapStrategy.BROADCAST_NAMED_EVENT) {
            log.info("registerSubscriber for broadcast receive " + String.valueOf(subscriber));
            this.subscribe();
        }
    }

    public void subscribe(StaticEventProcessor subscriber, EventSubscription<?> eventSubscription) {
        log.info("subscribe request for " + String.valueOf(eventSubscription) + " from " + String.valueOf(subscriber));
        if (this.serviceName.equals(eventSubscription.filterString())) {
            log.info("subscribe request for " + String.valueOf(eventSubscription) + " from " + String.valueOf(subscriber) + " matches service name:" + this.serviceName);
            this.subscribe();
        } else {
            log.info("ignoring subscribe request for " + String.valueOf(eventSubscription) + " from " + String.valueOf(subscriber) + " does not match service name:" + this.serviceName);
        }
    }

    public void unSubscribe(StaticEventProcessor subscriber, EventSubscription<?> eventSubscription) {
        subscriber.getSubscriptionManager().unSubscribe(this.subscriptionKey);
    }

    public void removeAllSubscriptions(StaticEventProcessor subscriber) {
    }

    @Override
    public void setEventWrapStrategy(EventSource.EventWrapStrategy eventWrapStrategy) {
        this.eventWrapStrategy = eventWrapStrategy;
        if (this.output != null) {
            this.output.setEventWrapStrategy(eventWrapStrategy);
        }
    }

    @Override
    public void setSlowConsumerStrategy(EventSource.SlowConsumerStrategy slowConsumerStrategy) {
        this.slowConsumerStrategy = slowConsumerStrategy;
    }

    @Override
    public void setDataMapper(Function<T, ?> dataMapper) {
        this.dataMapper = dataMapper;
        if (this.output != null) {
            this.output.setDataMapper(dataMapper);
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    protected Function<T, ?> getDataMapper() {
        return this.dataMapper;
    }
}

