/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.service.pool.impl;

import com.telamin.mongoose.service.pool.ObjectPool;
import com.telamin.mongoose.service.pool.ObjectPoolsRegistry;
import com.telamin.mongoose.service.pool.PoolAware;
import com.telamin.mongoose.service.pool.impl.ObjectPoolManager;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class GlobalObjectPool
implements ObjectPoolsRegistry {
    private final Map<Class<?>, ObjectPool<?>> pools = new ConcurrentHashMap();

    @Override
    public <T extends PoolAware> ObjectPool<T> getOrCreate(Class<T> type, Supplier<T> factory) {
        return this.getOrCreate(type, factory, null, 256);
    }

    @Override
    public <T extends PoolAware> ObjectPool<T> getOrCreate(Class<T> type, Supplier<T> factory, Consumer<T> reset) {
        return this.getOrCreate(type, factory, reset, 256);
    }

    @Override
    public <T extends PoolAware> ObjectPool<T> getOrCreate(Class<T> type, Supplier<T> factory, Consumer<T> reset, int capacity) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(factory, "factory");
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        ObjectPool pool = this.pools.computeIfAbsent(type, k -> new ObjectPoolManager(factory, reset, capacity));
        return pool;
    }

    @Override
    public <T extends PoolAware> ObjectPool<T> getOrCreate(Class<T> type, Supplier<T> factory, Consumer<T> reset, int capacity, int partitions) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(factory, "factory");
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        if (partitions <= 0) {
            throw new IllegalArgumentException("partitions must be > 0");
        }
        ObjectPool pool = this.pools.computeIfAbsent(type, k -> new ObjectPoolManager(factory, reset, capacity, partitions));
        return pool;
    }

    @Override
    public void remove(Class<?> type) {
        this.pools.remove(type);
    }
}

