/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.service.pool.impl;

import com.fluxtion.agrona.concurrent.ManyToManyConcurrentArrayQueue;
import com.telamin.mongoose.service.pool.ObjectPool;
import com.telamin.mongoose.service.pool.PoolAware;
import com.telamin.mongoose.service.pool.impl.PoolTracker;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class ObjectPoolManager<T extends PoolAware>
implements ObjectPool<T> {
    public static final int DEFAULT_CAPACITY = 256;
    private final Supplier<T> factory;
    private final Consumer<T> resetHook;
    private final ManyToManyConcurrentArrayQueue<T>[] freePartitions;
    private final int capacity;
    private final int partitions;
    private final int mask;
    private final AtomicInteger created = new AtomicInteger();

    public ObjectPoolManager(Supplier<T> factory, Consumer<T> resetHook) {
        this(factory, resetHook, 256);
    }

    public ObjectPoolManager(Supplier<T> factory, Consumer<T> resetHook, int capacity) {
        this(factory, resetHook, capacity, ObjectPoolManager.defaultPartitions());
    }

    public ObjectPoolManager(Supplier<T> factory, Consumer<T> resetHook, int capacity, int partitions) {
        int p2;
        this.factory = Objects.requireNonNull(factory, "factory");
        this.resetHook = resetHook;
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        if (partitions <= 0) {
            throw new IllegalArgumentException("partitions must be > 0");
        }
        for (p2 = 1; p2 < partitions; p2 <<= 1) {
        }
        this.partitions = p2;
        this.mask = p2 - 1;
        this.capacity = capacity;
        ManyToManyConcurrentArrayQueue[] arr = new ManyToManyConcurrentArrayQueue[this.partitions];
        int baseCap = Math.max(1, capacity / this.partitions);
        int remainder = Math.max(0, capacity - baseCap * this.partitions);
        for (int i = 0; i < this.partitions; ++i) {
            int cap = baseCap + (i < remainder ? 1 : 0);
            arr[i] = new ManyToManyConcurrentArrayQueue(Math.max(2, cap));
        }
        this.freePartitions = arr;
    }

    @Override
    public T acquire() {
        int home = this.homePartitionForCurrentThread();
        Object t = this.pollFromPartition(home);
        if (t == null) {
            while (true) {
                int idx;
                int i;
                int current;
                if ((current = this.created.get()) < this.capacity) {
                    if (!this.created.compareAndSet(current, current + 1)) continue;
                    t = (PoolAware)this.factory.get();
                    break;
                }
                long start = System.nanoTime();
                do {
                    for (i = 0; i < this.partitions && (t = (PoolAware)this.freePartitions[idx = home + i & this.mask].poll()) == null; ++i) {
                    }
                    if (t != null) break;
                    Thread.onSpinWait();
                } while (System.nanoTime() - start < TimeUnit.MICROSECONDS.toNanos(200L));
                if (t == null) {
                    Thread.yield();
                    for (i = 0; i < this.partitions && (t = (PoolAware)this.freePartitions[idx = home + i & this.mask].poll()) == null; ++i) {
                    }
                }
                if (t != null) break;
            }
        }
        PoolTracker<?> tracker = t.getPoolTracker();
        tracker.init(this, t, this.resetHook);
        return t;
    }

    @Override
    public void release(T t, Consumer<T> reset) {
        if (reset != null) {
            try {
                reset.accept(t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int idx = this.partitionForObject(t);
        while (!this.freePartitions[idx].offer(t)) {
            idx = idx + 1 & this.mask;
            Thread.onSpinWait();
        }
    }

    @Override
    public int availableCount() {
        int sum = 0;
        for (int i = 0; i < this.partitions; ++i) {
            sum += this.freePartitions[i].size();
        }
        return sum;
    }

    @Override
    public void removeFromPool(T t) {
        PoolAware replacement = (PoolAware)this.factory.get();
        int idx = this.partitionForObject(replacement);
        while (!this.freePartitions[idx].offer((Object)replacement)) {
            idx = idx + 1 & this.mask;
            Thread.onSpinWait();
        }
    }

    private int homePartitionForCurrentThread() {
        long tid = Thread.currentThread().getId();
        int h = (int)(tid ^ tid >>> 21 ^ tid >>> 7);
        return h & this.mask;
    }

    private int partitionForObject(Object o) {
        int h = System.identityHashCode(o);
        h ^= h >>> 16;
        return h & this.mask;
    }

    private T pollFromPartition(int idx) {
        return (T)((PoolAware)this.freePartitions[idx].poll());
    }

    private static int defaultPartitions() {
        int p2;
        int cores = Math.max(1, Runtime.getRuntime().availableProcessors());
        int target = Math.min(8, cores);
        for (p2 = 1; p2 < target; p2 <<= 1) {
        }
        return Math.max(1, p2);
    }
}

