/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.service.pool.impl;

import com.telamin.mongoose.service.pool.ObjectPool;
import com.telamin.mongoose.service.pool.PoolAware;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import lombok.Generated;

public final class PoolTracker<T extends PoolAware> {
    private volatile ObjectPool<T> pool;
    private volatile T owner;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final AtomicBoolean returned = new AtomicBoolean(false);
    private volatile Consumer<T> onReturn;

    void init(ObjectPool<T> pool, T owner, Consumer<T> onReturn) {
        Objects.requireNonNull(pool, "pool");
        Objects.requireNonNull(owner, "owner");
        if (this.pool == null) {
            this.pool = pool;
            this.owner = owner;
        }
        this.onReturn = onReturn;
        this.refCount.set(1);
        this.returned.set(false);
    }

    public void acquireReference() {
        if (this.returned.get()) {
            throw new IllegalStateException("Cannot acquire reference: object already returned to pool");
        }
        this.ensureInitialised();
        this.refCount.incrementAndGet();
    }

    public void releaseReference() {
        if (this.returned.get()) {
            return;
        }
        this.ensureInitialised();
        int after = this.refCount.decrementAndGet();
        if (after < 0) {
            throw new IllegalStateException("PoolTracker underflow: release called more times than acquired");
        }
    }

    public void returnToPool() {
        if (this.returned.get()) {
            return;
        }
        this.ensureInitialised();
        if (this.refCount.get() == 0) {
            this.doReturnOnce();
        }
    }

    private void doReturnOnce() {
        T toReturn = this.owner;
        if (toReturn != null && this.returned.compareAndSet(false, true)) {
            Consumer<T> reset = this.onReturn;
            ObjectPool<T> p = this.pool;
            p.release(toReturn, reset);
        }
    }

    public void removeFromPool() {
        this.ensureInitialised();
        this.returned.set(true);
        ObjectPool<T> p = this.pool;
        T toDetach = this.owner;
        if (p != null && toDetach != null) {
            p.removeFromPool(toDetach);
        }
    }

    private void ensureInitialised() {
        if (this.pool == null || this.owner == null) {
            throw new IllegalStateException("PoolTracker not initialised by ObjectPool");
        }
    }

    public int currentRefCount() {
        return this.refCount.get();
    }

    @Generated
    public String toString() {
        return "PoolTracker(pool=" + String.valueOf(this.pool) + ", owner=" + String.valueOf(this.owner) + ", refCount=" + String.valueOf(this.refCount) + ", returned=" + String.valueOf(this.returned) + ", onReturn=" + String.valueOf(this.onReturn) + ")";
    }
}

