/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.service.scheduler;

import com.fluxtion.agrona.DeadlineTimerWheel;
import com.fluxtion.agrona.collections.Long2ObjectHashMap;
import com.fluxtion.agrona.concurrent.Agent;
import com.fluxtion.agrona.concurrent.EpochNanoClock;
import com.fluxtion.agrona.concurrent.OffsetEpochNanoClock;
import com.fluxtion.runtime.annotations.feature.Experimental;
import com.telamin.mongoose.service.scheduler.SchedulerService;
import java.util.concurrent.TimeUnit;

@Experimental
public class DeadWheelScheduler
implements SchedulerService,
Agent {
    protected final DeadlineTimerWheel timerWheel = new DeadlineTimerWheel(TimeUnit.MILLISECONDS, System.currentTimeMillis(), 1024L, 1);
    protected final Long2ObjectHashMap<Runnable> expiryActions = new Long2ObjectHashMap();
    protected final EpochNanoClock clock;

    public DeadWheelScheduler() {
        this((EpochNanoClock)new OffsetEpochNanoClock());
    }

    public DeadWheelScheduler(EpochNanoClock clock) {
        this.clock = clock;
        this.timerWheel.currentTickTime(clock.nanoTime());
    }

    @Override
    public long scheduleAtTime(long expireTIme, Runnable expiryAction) {
        long id = this.timerWheel.scheduleTimer(expireTIme);
        this.expiryActions.put(id, (Object)expiryAction);
        return id;
    }

    @Override
    public long scheduleAfterDelay(long waitTime, Runnable expiryAction) {
        long id = this.timerWheel.scheduleTimer(this.milliTime() + waitTime);
        this.expiryActions.put(id, (Object)expiryAction);
        return id;
    }

    public int doWork() {
        return this.timerWheel.poll(this.milliTime(), this::onTimerExpiry, 100);
    }

    public String roleName() {
        return "deadWheelScheduler";
    }

    private boolean onTimerExpiry(TimeUnit timeUnit, long now, long timerId) {
        ((Runnable)this.expiryActions.remove(timerId)).run();
        return true;
    }

    @Override
    public long milliTime() {
        long millisToNanos = this.clock.nanoTime() / 1000000L;
        return millisToNanos;
    }

    @Override
    public long microTime() {
        return TimeUnit.NANOSECONDS.toMicros(this.clock.nanoTime());
    }

    @Override
    public long nanoTime() {
        return this.clock.nanoTime();
    }

    public void setcurrentTickTime(long now) {
        this.timerWheel.currentTickTime(now);
    }
}

