/*
 * Decompiled with CFR 0.152.
 */
package com.telamin.mongoose.service.servercontrol;

import com.fluxtion.runtime.annotations.runtime.ServiceRegistered;
import com.fluxtion.runtime.lifecycle.Lifecycle;
import com.telamin.mongoose.service.admin.AdminCommandRegistry;
import com.telamin.mongoose.service.servercontrol.MongooseServerController;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;

public class MongooseServerAdmin
implements Lifecycle {
    @Generated
    private static final Logger log = Logger.getLogger(MongooseServerAdmin.class.getName());
    private AdminCommandRegistry registry;
    private MongooseServerController serverController;

    @ServiceRegistered
    public void admin(AdminCommandRegistry registry) {
        this.registry = registry;
        log.info("Admin command registry");
    }

    @ServiceRegistered
    public void server(MongooseServerController serverController) {
        this.serverController = serverController;
        log.info("Server command registry");
    }

    public void init() {
        log.info("Fluxtion Server admin init");
    }

    public void start() {
        log.info("Fluxtion Server admin started");
        this.registry.registerCommand("server.service.list", this::listServices);
        this.registry.registerCommand("server.processors.list", this::listProcessors);
        this.registry.registerCommand("server.processors.stop", this::stopProcessors);
    }

    public void tearDown() {
        log.info("Fluxtion Server admin tearDown");
    }

    private void listServices(List<String> args, Consumer<String> out, Consumer<String> err) {
        out.accept(this.serverController.registeredServices().entrySet().stream().map(e -> (String)e.getKey() + ": " + String.valueOf(e.getValue())).collect(Collectors.joining("\n\t", "services:\n\t", "\n")));
    }

    private void stopServices(List<String> args, Consumer<String> out, Consumer<String> err) {
        out.accept("stopping service:" + args.get(1));
        this.serverController.stopService(args.get(1));
    }

    private void startServices(List<String> args, Consumer<String> out, Consumer<String> err) {
        out.accept("starting service:" + args.get(1));
        this.serverController.startService(args.get(1));
    }

    private void listProcessors(List<String> args, Consumer<String> out, Consumer<String> err) {
        out.accept(this.serverController.registeredProcessors().entrySet().stream().map(e -> {
            String groupName = (String)e.getKey();
            return "group:" + groupName + "\nprocessors:" + ((Collection)e.getValue()).stream().map(namedEventProcessor -> groupName + "/" + namedEventProcessor.name() + " -> " + String.valueOf(namedEventProcessor.eventProcessor())).collect(Collectors.joining("\n\t", "\n\t", "\n"));
        }).collect(Collectors.joining("\n", "\n", "\n")));
    }

    private void stopProcessors(List<String> args, Consumer<String> out, Consumer<String> err) {
        String arg = args.get(1);
        out.accept("stopping processor:" + arg);
        String[] splitArgs = arg.split("/");
        this.serverController.stopProcessor(splitArgs[0], splitArgs[1]);
    }
}

