/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.util.background;

import android.content.Context;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PaintDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.TypedValue;
import androidx.compose.runtime.internal.StabilityInferred;
import com.telefonica.mistica.R;
import com.telefonica.mistica.util.ColorUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/telefonica/mistica/util/background/GradientBackgroundFactory;", "", "()V", "getBackground", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "intColors", "", "getBackgroundForLoginLoadingScreen", "getGradientColors", "getLoginLoadingScreenColors", "getPositions", "", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=1)
public final class GradientBackgroundFactory {
    @NotNull
    public static final GradientBackgroundFactory INSTANCE = new GradientBackgroundFactory();
    public static final int $stable;

    private GradientBackgroundFactory() {
    }

    @JvmStatic
    @NotNull
    public static final Drawable getBackground(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return INSTANCE.getBackground(context, INSTANCE.getGradientColors(context));
    }

    @JvmStatic
    @NotNull
    public static final Drawable getBackgroundForLoginLoadingScreen(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return INSTANCE.getBackground(context, INSTANCE.getLoginLoadingScreenColors(context));
    }

    private final Drawable getBackground(Context context, int[] intColors) {
        float[] positions = this.getPositions(context);
        ShapeDrawable.ShaderFactory shaderFactory2 = new ShapeDrawable.ShaderFactory(intColors, positions){
            final /* synthetic */ int[] $intColors;
            final /* synthetic */ float[] $positions;
            {
                this.$intColors = $intColors;
                this.$positions = $positions;
            }

            @NotNull
            public Shader resize(int width, int height) {
                float x = (float)width / 2.0f;
                return (Shader)new LinearGradient(x, 0.0f, x, (float)height, this.$intColors, this.$positions, Shader.TileMode.CLAMP);
            }
        };
        PaintDrawable paint = new PaintDrawable();
        paint.setShape((Shape)new RectShape());
        paint.setShaderFactory(shaderFactory2);
        return (Drawable)paint;
    }

    private final float[] getPositions(Context context) {
        float[] positions = new float[4];
        TypedValue typedValue = new TypedValue();
        context.getResources().getValue(R.dimen.gradient_background_start_point, typedValue, true);
        positions[0] = typedValue.getFloat();
        context.getResources().getValue(R.dimen.gradient_background_med_point, typedValue, true);
        positions[1] = typedValue.getFloat();
        context.getResources().getValue(R.dimen.gradient_background_med_high_point, typedValue, true);
        positions[2] = typedValue.getFloat();
        context.getResources().getValue(R.dimen.gradient_background_end_point, typedValue, true);
        positions[3] = typedValue.getFloat();
        return positions;
    }

    private final int[] getGradientColors(Context context) {
        int[] intColors = new int[]{ColorUtilsKt.getThemeColor(context, R.attr.colorGradientBackgroundFirst), ColorUtilsKt.getThemeColor(context, R.attr.colorGradientBackgroundSecond), ColorUtilsKt.getThemeColor(context, R.attr.colorGradientBackgroundThird), ColorUtilsKt.getThemeColor(context, R.attr.colorGradientBackgroundFourth)};
        return intColors;
    }

    private final int[] getLoginLoadingScreenColors(Context context) {
        int[] intColors = new int[]{ColorUtilsKt.getThemeColor(context, R.attr.colorLoginLoadingGradientFirst), ColorUtilsKt.getThemeColor(context, R.attr.colorLoginLoadingGradientSecond), ColorUtilsKt.getThemeColor(context, R.attr.colorLoginLoadingGradientThird), ColorUtilsKt.getThemeColor(context, R.attr.colorLoginLoadingGradientFourth)};
        return intColors;
    }
}

