/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.feedback;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AttrRes;
import androidx.annotation.StringRes;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.android.material.snackbar.BaseTransientBottomBar;
import com.google.android.material.snackbar.Snackbar;
import com.telefonica.mistica.R;
import com.telefonica.mistica.feedback.SnackBarBehaviorConfig;
import com.telefonica.mistica.feedback.SnackbarLength;
import com.telefonica.mistica.feedback.snackbar.CustomSnackbarLayout;
import com.telefonica.mistica.util.ColorUtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u0005H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0005H\u0003J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00162\b\b\u0001\u0010\u001b\u001a\u00020\u0005H\u0002J\u001a\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00162\b\b\u0001\u0010\u001b\u001a\u00020\u0005H\u0002J\u0012\u0010%\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0017J\u0012\u0010&\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0017J\u001c\u0010'\u001a\u00020\u00002\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\u0010(\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010'\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u0000H\u0016J\f\u0010*\u001a\u00020\"*\u00020\u0016H\u0002J\f\u0010+\u001a\u00020\"*\u00020\u0016H\u0002J\f\u0010,\u001a\u00020-*\u00020\u0016H\u0002J\f\u0010.\u001a\u00020\"*\u00020\u0016H\u0002J\u0014\u0010/\u001a\u00020\"*\u00020\u00162\u0006\u00100\u001a\u00020\u0010H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/telefonica/mistica/feedback/SnackbarBuilder;", "", "view", "Landroid/view/View;", "resId", "", "(Landroid/view/View;I)V", "text", "", "(Landroid/view/View;Ljava/lang/String;)V", "actionListener", "Landroid/view/View$OnClickListener;", "actionText", "callback", "Lcom/google/android/material/snackbar/Snackbar$Callback;", "hasAction", "", "getHasAction", "()Z", "", "withDismiss", "createSnackbar", "Lcom/google/android/material/snackbar/Snackbar;", "snackbarLength", "Lcom/telefonica/mistica/feedback/SnackbarLength;", "getSpannable", "Landroid/text/Spannable;", "colorRes", "inflateCustomSnackbar", "duration", "isInvalidLengthWhenThereIsAction", "length", "isInvalidLengthWhenThereIsNoAction", "setActionTextColor", "", "snackbar", "setBackgroundColor", "showCritical", "showInformative", "withAction", "listener", "withCallback", "addCallbackIfNeeded", "dispatchDismissedByActionEvent", "getCustomLayout", "Lcom/telefonica/mistica/feedback/snackbar/CustomSnackbarLayout;", "setCustomAction", "showDismissActionIfNeeded", "hasInfiniteDuration", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSnackbarBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnackbarBuilder.kt\ncom/telefonica/mistica/feedback/SnackbarBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public class SnackbarBuilder {
    @NotNull
    private final View view;
    @NotNull
    private final CharSequence text;
    @Nullable
    private String actionText;
    @Nullable
    private View.OnClickListener actionListener;
    @Nullable
    private Snackbar.Callback callback;
    private boolean withDismiss;
    public static final int $stable = 8;

    public SnackbarBuilder(@Nullable View view, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (view == null) {
            boolean bl = false;
            String string2 = "View cannot be null";
            throw new IllegalArgumentException(string2.toString());
        }
        this.text = text;
        this.view = view;
    }

    private final boolean getHasAction() {
        return this.actionText != null;
    }

    public SnackbarBuilder(@NotNull View view, @StringRes int resId) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        String string2 = view.getResources().getString(resId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        this(view, string2);
    }

    @NotNull
    public SnackbarBuilder withAction(@NotNull String text, @Nullable View.OnClickListener listener2) {
        SnackbarBuilder snackbarBuilder;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SnackbarBuilder $this$withAction_u24lambda_u241 = snackbarBuilder = this;
        boolean bl = false;
        $this$withAction_u24lambda_u241.actionText = text;
        $this$withAction_u24lambda_u241.actionListener = listener2;
        return snackbarBuilder;
    }

    @NotNull
    public SnackbarBuilder withAction(@StringRes int resId, @Nullable View.OnClickListener listener2) {
        String string2 = this.view.getResources().getString(resId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return this.withAction(string2, listener2);
    }

    @NotNull
    public SnackbarBuilder withCallback(@NotNull Snackbar.Callback callback) {
        SnackbarBuilder snackbarBuilder;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        SnackbarBuilder $this$withCallback_u24lambda_u242 = snackbarBuilder = this;
        boolean bl = false;
        $this$withCallback_u24lambda_u242.callback = callback;
        return snackbarBuilder;
    }

    @NotNull
    public SnackbarBuilder withDismiss() {
        SnackbarBuilder snackbarBuilder;
        SnackbarBuilder $this$withDismiss_u24lambda_u243 = snackbarBuilder = this;
        boolean bl = false;
        $this$withDismiss_u24lambda_u243.withDismiss = true;
        return snackbarBuilder;
    }

    @JvmOverloads
    @NotNull
    public Snackbar showInformative(@NotNull SnackbarLength snackbarLength) {
        Intrinsics.checkNotNullParameter((Object)((Object)snackbarLength), (String)"snackbarLength");
        Spannable spannable = this.getSpannable(R.attr.colorTextPrimaryInverse);
        Snackbar snackbar = this.createSnackbar((CharSequence)spannable, snackbarLength);
        this.setBackgroundColor(snackbar, R.attr.colorFeedbackInfoBackground);
        this.setActionTextColor(snackbar, R.attr.colorTextLinkSnackbar);
        snackbar.show();
        return snackbar;
    }

    public static /* synthetic */ Snackbar showInformative$default(SnackbarBuilder snackbarBuilder, SnackbarLength snackbarLength, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showInformative");
        }
        if ((n & 1) != 0) {
            snackbarLength = SnackbarLength.SHORT;
        }
        return snackbarBuilder.showInformative(snackbarLength);
    }

    @JvmOverloads
    @NotNull
    public Snackbar showCritical(@NotNull SnackbarLength snackbarLength) {
        Intrinsics.checkNotNullParameter((Object)((Object)snackbarLength), (String)"snackbarLength");
        Spannable spannable = this.getSpannable(R.attr.colorTextPrimaryInverse);
        Snackbar snackbar = this.createSnackbar((CharSequence)spannable, snackbarLength);
        this.setBackgroundColor(snackbar, R.attr.colorFeedbackErrorBackground);
        this.setActionTextColor(snackbar, R.attr.colorTextPrimaryInverse);
        snackbar.show();
        return snackbar;
    }

    public static /* synthetic */ Snackbar showCritical$default(SnackbarBuilder snackbarBuilder, SnackbarLength snackbarLength, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showCritical");
        }
        if ((n & 1) != 0) {
            snackbarLength = SnackbarLength.SHORT;
        }
        return snackbarBuilder.showCritical(snackbarLength);
    }

    private final void setActionTextColor(Snackbar snackbar, @AttrRes int colorRes) {
        CustomSnackbarLayout customSnackbarLayout = this.getCustomLayout(snackbar);
        Context context = this.view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        customSnackbarLayout.setActionTextColor(ColorUtilsKt.getThemeColor(context, colorRes));
    }

    private final void setBackgroundColor(Snackbar snackbar, @AttrRes int colorRes) {
        View view = snackbar.getView();
        Context context = this.view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        view.setBackgroundTintList(ColorStateList.valueOf((int)ColorUtilsKt.getThemeColor(context, colorRes)));
    }

    private final Spannable getSpannable(@AttrRes int colorRes) {
        Spannable spannable = (Spannable)new SpannableString(this.text);
        Context context = this.view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(ColorUtilsKt.getThemeColor(context, colorRes));
        spannable.setSpan((Object)foregroundColorSpan, 0, spannable.length(), 33);
        return spannable;
    }

    private final Snackbar createSnackbar(CharSequence text, SnackbarLength snackbarLength) {
        int duration = (SnackBarBehaviorConfig.areSticky() ? SnackbarLength.INDEFINITE : (this.isInvalidLengthWhenThereIsAction(snackbarLength) ? SnackbarLength.LONG : (this.isInvalidLengthWhenThereIsNoAction(snackbarLength) ? SnackbarLength.SHORT : snackbarLength))).duration();
        Snackbar snackbar = this.inflateCustomSnackbar(duration);
        this.getCustomLayout(snackbar).setText(text);
        this.setCustomAction(snackbar);
        this.showDismissActionIfNeeded(snackbar, snackbarLength == SnackbarLength.INDEFINITE);
        this.addCallbackIfNeeded(snackbar);
        return snackbar;
    }

    private final boolean isInvalidLengthWhenThereIsAction(SnackbarLength length) {
        return this.getHasAction() && length == SnackbarLength.SHORT;
    }

    private final boolean isInvalidLengthWhenThereIsNoAction(SnackbarLength length) {
        return !this.getHasAction() && length == SnackbarLength.LONG;
    }

    @SuppressLint(value={"ShowToast"})
    private final Snackbar inflateCustomSnackbar(int duration) {
        Snackbar snackbar = Snackbar.make((View)this.view, (CharSequence)"", (int)duration);
        Intrinsics.checkNotNullExpressionValue((Object)snackbar, (String)"make(...)");
        Snackbar snackbar2 = snackbar;
        View view = snackbar2.getView();
        Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type com.google.android.material.snackbar.Snackbar.SnackbarLayout");
        Snackbar.SnackbarLayout snackbarLayout = (Snackbar.SnackbarLayout)view;
        snackbarLayout.removeAllViews();
        View customLayout = LayoutInflater.from((Context)snackbarLayout.getContext()).inflate(R.layout.snackbar_layout, (ViewGroup)snackbarLayout, false);
        snackbarLayout.addView(customLayout);
        return snackbar2;
    }

    private final void setCustomAction(Snackbar $this$setCustomAction) {
        block0: {
            String string2 = this.actionText;
            if (string2 == null) break block0;
            String text = string2;
            boolean bl = false;
            this.getCustomLayout($this$setCustomAction).setAction(text, arg_0 -> SnackbarBuilder.setCustomAction$lambda$5$lambda$4(this, $this$setCustomAction, arg_0));
        }
    }

    private final void dispatchDismissedByActionEvent(Snackbar $this$dispatchDismissedByActionEvent) {
        $this$dispatchDismissedByActionEvent.removeCallback((BaseTransientBottomBar.BaseCallback)this.callback);
        Snackbar.Callback callback = this.callback;
        if (callback != null) {
            callback.onDismissed($this$dispatchDismissedByActionEvent, 1);
        }
        $this$dispatchDismissedByActionEvent.dismiss();
    }

    private final CustomSnackbarLayout getCustomLayout(Snackbar $this$getCustomLayout) {
        View view = $this$getCustomLayout.getView().findViewById(R.id.custom_layout);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        return (CustomSnackbarLayout)view;
    }

    private final void showDismissActionIfNeeded(Snackbar $this$showDismissActionIfNeeded, boolean hasInfiniteDuration) {
        boolean userShouldBeAbleToDismissSnackbar;
        boolean bl = userShouldBeAbleToDismissSnackbar = !this.getHasAction() && hasInfiniteDuration;
        if (this.withDismiss || userShouldBeAbleToDismissSnackbar) {
            this.getCustomLayout($this$showDismissActionIfNeeded).setOnDismissClickListener((Function0<Unit>)((Function0)new Function0<Unit>($this$showDismissActionIfNeeded){
                final /* synthetic */ Snackbar $this_showDismissActionIfNeeded;
                {
                    this.$this_showDismissActionIfNeeded = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.$this_showDismissActionIfNeeded.dismiss();
                }
            }));
        }
    }

    private final void addCallbackIfNeeded(Snackbar $this$addCallbackIfNeeded) {
        if (this.callback != null) {
            $this$addCallbackIfNeeded.addCallback((BaseTransientBottomBar.BaseCallback)this.callback);
        }
    }

    @JvmOverloads
    @NotNull
    public final Snackbar showInformative() {
        return SnackbarBuilder.showInformative$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Snackbar showCritical() {
        return SnackbarBuilder.showCritical$default(this, null, 1, null);
    }

    private static final void setCustomAction$lambda$5$lambda$4(SnackbarBuilder this$0, Snackbar $this_setCustomAction, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_setCustomAction, (String)"$this_setCustomAction");
        View.OnClickListener onClickListener = this$0.actionListener;
        if (onClickListener != null) {
            onClickListener.onClick(it);
        }
        this$0.dispatchDismissedByActionEvent($this_setCustomAction);
    }
}

