/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.input;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.databinding.BindingAdapter;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import androidx.databinding.InverseBindingListener;
import androidx.databinding.InverseBindingMethod;
import androidx.databinding.InverseBindingMethods;
import com.google.android.material.textfield.TextInputLayout;
import com.telefonica.mistica.R;
import com.telefonica.mistica.input.Input;
import com.telefonica.mistica.util.ColorUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BindingMethods(value={@BindingMethod(type=CheckBoxInput.class, attribute="inputCheckText", method="setText"), @BindingMethod(type=CheckBoxInput.class, attribute="inputChecked", method="setChecked")})
@InverseBindingMethods(value={@InverseBindingMethod(type=CheckBoxInput.class, attribute="inputChecked", method="isChecked")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\"\u0010\u0014\u001a\u00020\u00152\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0017J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0017H\u0016J\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\rJ\u0010\u0010\"\u001a\u00020\u000f2\b\u0010#\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/telefonica/mistica/input/CheckBoxInput;", "Lcom/telefonica/mistica/input/Input;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "checkBox", "Landroidx/appcompat/widget/AppCompatCheckBox;", "onCheckedChangeListener", "Landroid/widget/CompoundButton$OnCheckedChangeListener;", "configureErrorResetOnCheckChange", "", "getButtonDrawable", "Landroid/graphics/drawable/Drawable;", "getText", "", "handleAttrsAndInflateLayout", "Lcom/google/android/material/textfield/TextInputLayout;", "isChecked", "", "setButtonTint", "setChecked", "checked", "setEnabled", "enabled", "setMovementMethod", "movementMethod", "Landroid/text/method/MovementMethod;", "setOnCheckedChangeListener", "listener", "setText", "text", "Companion", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
public final class CheckBoxInput
extends Input {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private AppCompatCheckBox checkBox;
    @Nullable
    private CompoundButton.OnCheckedChangeListener onCheckedChangeListener;
    public static final int $stable = 8;

    @JvmOverloads
    public CheckBoxInput(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public /* synthetic */ CheckBoxInput(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(context, attributeSet, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TextInputLayout handleAttrsAndInflateLayout(@Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        boolean initialInputChecked = true;
        String initialInputText = null;
        if (attrs != null) {
            TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.CheckBoxInput, defStyleAttr, defStyleRes);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
            TypedArray styledAttrs = typedArray;
            try {
                initialInputChecked = styledAttrs.getBoolean(R.styleable.CheckBoxInput_inputChecked, true);
                initialInputText = styledAttrs.getString(R.styleable.CheckBoxInput_inputCheckText);
            }
            finally {
                styledAttrs.recycle();
            }
        }
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.input_checkbox, (ViewGroup)this, true);
        View view = this.findViewById(R.id.checkbox_input);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.checkBox = (AppCompatCheckBox)view;
        this.setChecked(initialInputChecked);
        this.setText(initialInputText);
        this.configureErrorResetOnCheckChange();
        this.setButtonTint();
        View view2 = this.findViewById(R.id.text_input_layout);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        return (TextInputLayout)view2;
    }

    private final void configureErrorResetOnCheckChange() {
        AppCompatCheckBox appCompatCheckBox = this.checkBox;
        if (appCompatCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkBox");
            appCompatCheckBox = null;
        }
        appCompatCheckBox.setOnCheckedChangeListener((arg_0, arg_1) -> CheckBoxInput.configureErrorResetOnCheckChange$lambda$0(this, arg_0, arg_1));
    }

    private final void setButtonTint() {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[]{0x10100A0};
        nArrayArray[0] = nArray;
        nArray = new int[]{-16842912};
        nArrayArray[1] = nArray;
        int[][] states = nArrayArray;
        nArray = new int[2];
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        nArray[0] = ColorUtilsKt.getThemeColor(context, R.attr.colorControlActive);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        nArray[1] = ColorUtilsKt.getThemeColor(context2, R.attr.colorControl);
        int[] colors = nArray;
        AppCompatCheckBox appCompatCheckBox = this.checkBox;
        if (appCompatCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkBox");
            appCompatCheckBox = null;
        }
        appCompatCheckBox.setButtonTintList(new ColorStateList((int[][])states, colors));
    }

    public final void setChecked(boolean checked) {
        AppCompatCheckBox appCompatCheckBox = this.checkBox;
        if (appCompatCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkBox");
            appCompatCheckBox = null;
        }
        appCompatCheckBox.setChecked(checked);
    }

    public final boolean isChecked() {
        AppCompatCheckBox appCompatCheckBox = this.checkBox;
        if (appCompatCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkBox");
            appCompatCheckBox = null;
        }
        return appCompatCheckBox.isChecked();
    }

    public final void setText(@Nullable CharSequence text) {
        AppCompatCheckBox appCompatCheckBox = this.checkBox;
        if (appCompatCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkBox");
            appCompatCheckBox = null;
        }
        appCompatCheckBox.setText(text);
    }

    @Nullable
    public final CharSequence getText() {
        AppCompatCheckBox appCompatCheckBox = this.checkBox;
        if (appCompatCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkBox");
            appCompatCheckBox = null;
        }
        return appCompatCheckBox.getText();
    }

    public final void setOnCheckedChangeListener(@Nullable CompoundButton.OnCheckedChangeListener listener2) {
        this.onCheckedChangeListener = listener2;
    }

    public final void setMovementMethod(@NotNull MovementMethod movementMethod) {
        Intrinsics.checkNotNullParameter((Object)movementMethod, (String)"movementMethod");
        AppCompatCheckBox appCompatCheckBox = this.checkBox;
        if (appCompatCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkBox");
            appCompatCheckBox = null;
        }
        appCompatCheckBox.setMovementMethod(movementMethod);
    }

    @Nullable
    public final Drawable getButtonDrawable() {
        AppCompatCheckBox appCompatCheckBox = this.checkBox;
        if (appCompatCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkBox");
            appCompatCheckBox = null;
        }
        return appCompatCheckBox.getButtonDrawable();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        AppCompatCheckBox appCompatCheckBox = this.checkBox;
        if (appCompatCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkBox");
            appCompatCheckBox = null;
        }
        appCompatCheckBox.setEnabled(enabled);
    }

    @JvmOverloads
    public CheckBoxInput(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public CheckBoxInput(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public CheckBoxInput(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 0, 14, null);
    }

    private static final void configureErrorResetOnCheckChange$lambda$0(CheckBoxInput this$0, CompoundButton buttonView, boolean isChecked) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.setErrorEnabled(false);
            CompoundButton.OnCheckedChangeListener onCheckedChangeListener = this$0.onCheckedChangeListener;
            if (onCheckedChangeListener == null) break block0;
            onCheckedChangeListener.onCheckedChanged(buttonView, isChecked);
        }
    }

    @BindingAdapter(value={"inputCheckedAttrChanged"})
    @JvmStatic
    public static final void setCheckWatcher(@NotNull CheckBoxInput input, @NotNull InverseBindingListener listener2) {
        Companion.setCheckWatcher(input, listener2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/telefonica/mistica/input/CheckBoxInput$Companion;", "", "()V", "setCheckWatcher", "", "input", "Lcom/telefonica/mistica/input/CheckBoxInput;", "listener", "Landroidx/databinding/InverseBindingListener;", "com.telefonica.mistica_release"})
    public static final class Companion {
        private Companion() {
        }

        @BindingAdapter(value={"inputCheckedAttrChanged"})
        @JvmStatic
        public final void setCheckWatcher(@NotNull CheckBoxInput input, @NotNull InverseBindingListener listener2) {
            Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            input.setOnCheckedChangeListener((arg_0, arg_1) -> Companion.setCheckWatcher$lambda$0(listener2, arg_0, arg_1));
        }

        private static final void setCheckWatcher$lambda$0(InverseBindingListener $listener, CompoundButton compoundButton, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
            $listener.onChange();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

