# Working with colors & drawables

Mistica xml themes expose [semantic colors and drawables attributes](../../../../../res/values/attrs_autogenerated.xml) which are provided with different configurations for each supported brand.

## Colors

When using a mistica theme, colors can be easily applied just referencing them in the xml layouts:

```xml
<LinearLayout
  android:layout_width="match_parent"
  android:layout_height="wrap_content"
  android:layout_marginTop="8dp"
  android:gravity="center_horizontal"
  android:orientation="vertical"
  android:background="?colorBackground"
  >
```

Also, if needed, [colors can be obtained programmatically](../util/ColorUtils.kt).

```kotlin
@ColorInt val color = getThemeColor(R.attr.colorBackground)
```

## Drawables

This is an heterogeneous type which can be implemented internally as a solid color or as a gradient depending on the specific brand theme.

When using a mistica theme, drawables can be easily applied just referencing them in the xml layouts:

```xml
<LinearLayout
  android:layout_width="match_parent"
  android:layout_height="wrap_content"
  android:layout_marginTop="8dp"
  android:gravity="center_horizontal"
  android:orientation="vertical"
  android:background="?drawableBackgroundBrand"
  >
```

Also, [drawables can be obtained programmatically](../util/DrawableUtils.kt).

```kotlin
val drawable: Drawable = getMisticaThemeDrawable(R.attr.drawableBackgroundBrand)
```

```kotlin
val drawable: Drawable = getMisticaThemeDrawableBuilder(R.attr.drawableBackgroundBrand)
    .withCornerRadius()
    .withBorderStroke()
    .withRipple()
    .get()
```
