/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.link;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ClickableSpan;
import android.util.Log;
import androidx.annotation.ColorInt;
import com.telefonica.mistica.link.MultiLink;
import com.telefonica.mistica.link.TextLinkSpan;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u001a\u001a\u0010\u000b\u001a\u00020\f*\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"WARNING_TAG", "", "getSpannableLinkText", "Landroid/text/Spannable;", "originalText", "links", "", "Lcom/telefonica/mistica/link/MultiLink;", "linkColor", "", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Integer;)Landroid/text/Spannable;", "containsAnyLink", "", "com.telefonica.mistica_release"})
@SourceDebugExtension(value={"SMAP\nTextLinkViewUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextLinkViewUtils.kt\ncom/telefonica/mistica/link/TextLinkViewUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1855#2,2:74\n1747#2,3:76\n*S KotlinDebug\n*F\n+ 1 TextLinkViewUtils.kt\ncom/telefonica/mistica/link/TextLinkViewUtilsKt\n*L\n25#1:74,2\n53#1:76,3\n*E\n"})
public final class TextLinkViewUtilsKt {
    @NotNull
    private static final String WARNING_TAG = "TextLinkUtils";

    @NotNull
    public static final Spannable getSpannableLinkText(@NotNull String originalText, @NotNull List<? extends MultiLink> links2, @ColorInt @Nullable Integer linkColor) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        Intrinsics.checkNotNullParameter(links2, (String)"links");
        SpannableString spannableString = new SpannableString((CharSequence)originalText);
        if (TextLinkViewUtilsKt.containsAnyLink(originalText, links2)) {
            Iterable $this$forEach$iv = links2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MultiLink link = (MultiLink)element$iv;
                boolean bl = false;
                int start = StringsKt.indexOf$default((CharSequence)originalText, (String)link.getLinkedText(), (int)0, (boolean)false, (int)6, null);
                if (start >= 0) {
                    ClickableSpan clickableSpan;
                    int end = start + link.getLinkedText().length();
                    MultiLink multiLink = link;
                    if (multiLink instanceof MultiLink.DefaultMultiLink) {
                        clickableSpan = new TextLinkSpan(linkColor, (Function0<Unit>)((Function0)new Function0<Unit>(link){
                            final /* synthetic */ MultiLink $link;
                            {
                                this.$link = $link;
                                super(0);
                            }

                            public final void invoke() {
                                ((MultiLink.DefaultMultiLink)this.$link).getOnLinkTapped().invoke();
                            }
                        }));
                    } else if (multiLink instanceof MultiLink.CustomMultiLink) {
                        clickableSpan = ((MultiLink.CustomMultiLink)link).getCustomSpan();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    spannableString.setSpan((Object)clickableSpan, start, end, 33);
                    continue;
                }
                Log.w((String)WARNING_TAG, (String)("Link \"" + link.getLinkedText() + "\" not found in text \"" + originalText + "\"."));
            }
        } else {
            Log.w((String)WARNING_TAG, (String)("None of the provided links match the text:\n- Links: " + links2 + "\n Provided text: \"" + originalText + "\"."));
        }
        return (Spannable)spannableString;
    }

    public static /* synthetic */ Spannable getSpannableLinkText$default(String string2, List list, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return TextLinkViewUtilsKt.getSpannableLinkText(string2, list, n);
    }

    private static final boolean containsAnyLink(String $this$containsAnyLink, List<? extends MultiLink> links2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = links2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MultiLink link = (MultiLink)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)$this$containsAnyLink, (CharSequence)link.getLinkedText(), (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

