/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.feedback.screen.view;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.PathInterpolator;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.LayoutRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.graphics.drawable.DrawableCompat;
import com.airbnb.lottie.LottieAnimationView;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.value.LottieFrameInfo;
import com.airbnb.lottie.value.SimpleLottieValueCallback;
import com.telefonica.mistica.R;
import com.telefonica.mistica.button.ProgressButton;
import com.telefonica.mistica.feedback.screen.haptics.HapticFeedbackType;
import com.telefonica.mistica.feedback.screen.haptics.HapticFeedbacksKt;
import com.telefonica.mistica.util.ColorUtilsKt;
import com.telefonica.mistica.util.ResUtilsKt;
import com.telefonica.mistica.util.ViewUtilsKt;
import com.telefonica.mistica.util.background.GradientBackgroundFactory;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\u0018\u0000 R2\u00020\u0001:\u0002RSB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020(H\u0002J\b\u0010+\u001a\u00020(H\u0002J\b\u0010,\u001a\u00020(H\u0002J\b\u0010-\u001a\u00020(H\u0002J&\u0010-\u001a\u00020(2\b\b\u0001\u0010.\u001a\u00020\t2\b\b\u0001\u0010/\u001a\u00020\t2\b\b\u0001\u00100\u001a\u00020\tH\u0002J\b\u00101\u001a\u00020(H\u0002J\b\u00102\u001a\u00020(H\u0002J\b\u00103\u001a\u00020(H\u0002J\u0012\u00104\u001a\u00020\u001a2\b\b\u0001\u00105\u001a\u00020\tH\u0002J\b\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\u0006\u0010<\u001a\u00020\tJ\u0006\u0010=\u001a\u00020>J\u0010\u0010?\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J&\u0010@\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u0002J\b\u0010A\u001a\u00020\u001aH\u0002J\b\u0010B\u001a\u00020(H\u0014J\b\u0010C\u001a\u00020(H\u0002J\u0010\u0010D\u001a\u00020(2\b\b\u0001\u0010E\u001a\u00020\tJ\u000e\u0010F\u001a\u00020(2\u0006\u0010G\u001a\u00020\u0016J\u000e\u0010H\u001a\u00020(2\u0006\u0010I\u001a\u00020\u001aJ\u000e\u0010J\u001a\u00020(2\u0006\u0010G\u001a\u00020\u0016J\u000e\u0010K\u001a\u00020(2\u0006\u0010G\u001a\u00020\u0016J\u000e\u0010L\u001a\u00020(2\u0006\u0010G\u001a\u00020\u0016J\u000e\u0010M\u001a\u00020(2\u0006\u0010&\u001a\u00020\tJ\u000e\u0010N\u001a\u00020(2\u0006\u0010O\u001a\u00020\u0014J\u000e\u0010P\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010Q\u001a\u00020(2\u0006\u0010O\u001a\u00020\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/telefonica/mistica/feedback/screen/view/FeedbackScreenView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "buttonsContainer", "Landroid/widget/LinearLayout;", "customContentContainer", "Landroid/widget/FrameLayout;", "customContentLayout", "Ljava/lang/Integer;", "firstButton", "Lcom/telefonica/mistica/button/ProgressButton;", "firstButtonClickListener", "Landroid/view/View$OnClickListener;", "firstButtonText", "", "icon", "Lcom/airbnb/lottie/LottieAnimationView;", "isIconAnimated", "", "isLoading", "secondButton", "Landroid/widget/Button;", "secondButtonAsLink", "secondButtonClickListener", "secondButtonText", "subtitle", "Landroid/widget/TextView;", "subtitleText", "title", "titleText", "type", "animateViews", "", "animateViewsOnFirstLayout", "configureBackground", "configureButtons", "configureCustomContentView", "configureIcon", "animationAttr", "imageAttr", "colorAttr", "configureTexts", "configureView", "executeHapticFeedback", "getBooleanThemeRes", "attributeRes", "getCubicBezierInterpolator", "Landroid/view/animation/PathInterpolator;", "getFadeInAnim", "Landroid/animation/ObjectAnimator;", "view", "Landroid/view/View;", "getFeedbackType", "getFirstButtonText", "", "getTranslationYAnim", "init", "isInversePresentation", "onAttachedToWindow", "performHapticFeedback", "setCustomContentLayout", "layout", "setFeedbackFirstButtonText", "text", "setFeedbackSecondButtonAsLink", "asLink", "setFeedbackSecondButtonText", "setFeedbackSubtitle", "setFeedbackTitle", "setFeedbackType", "setFirstButtonOnClick", "clickListener", "setIsLoading", "setSecondButtonOnClick", "Companion", "FeedbackType", "library_release"})
public final class FeedbackScreenView
extends ConstraintLayout {
    private LottieAnimationView icon;
    private TextView title;
    private TextView subtitle;
    private FrameLayout customContentContainer;
    private LinearLayout buttonsContainer;
    private ProgressButton firstButton;
    private Button secondButton;
    private int type;
    private CharSequence titleText;
    private CharSequence subtitleText;
    private boolean isLoading;
    @LayoutRes
    private Integer customContentLayout;
    private CharSequence firstButtonText;
    private CharSequence secondButtonText;
    private boolean secondButtonAsLink;
    private boolean isIconAnimated;
    private View.OnClickListener firstButtonClickListener;
    private View.OnClickListener secondButtonClickListener;
    public static final int TYPE_SUCCESS = 0;
    public static final int TYPE_ERROR = 1;
    public static final int TYPE_INFO = 2;
    public static final long TEXTS_ANIMATION_DURATION = 800L;
    public static final long TEXTS_ANIMATION_DELAY = 200L;
    public static final long HAPTIC_FEEDBACK_DEFAULT_DELAY = 450L;
    public static final long HAPTIC_FEEDBACK_ERROR_DELAY = 500L;
    @NotNull
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final void setFeedbackType(int type) {
        this.type = type;
        this.configureView();
    }

    public final int getFeedbackType() {
        return this.type;
    }

    public final void setFeedbackTitle(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.titleText = text;
        TextView textView = this.title;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"title");
        }
        textView.setText(text);
    }

    public final void setFeedbackSubtitle(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.subtitleText = text;
        TextView textView = this.subtitle;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
        }
        textView.setText(text);
    }

    public final void setCustomContentLayout(@LayoutRes int layout2) {
        this.customContentLayout = layout2;
        this.configureCustomContentView();
    }

    public final void setFeedbackFirstButtonText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.firstButtonText = text;
        ProgressButton progressButton = this.firstButton;
        if (progressButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
        }
        progressButton.setText(text);
        ProgressButton progressButton2 = this.firstButton;
        if (progressButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
        }
        progressButton2.setVisibility(StringsKt.isBlank((CharSequence)text) ? 8 : 0);
    }

    public final void setFeedbackSecondButtonText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.secondButtonText = text;
        Button button = this.secondButton;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secondButton");
        }
        button.setText(text);
        Button button2 = this.secondButton;
        if (button2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secondButton");
        }
        button2.setVisibility(StringsKt.isBlank((CharSequence)text) ? 8 : 0);
    }

    public final void setFeedbackSecondButtonAsLink(boolean asLink) {
        this.secondButtonAsLink = asLink;
        this.configureButtons();
    }

    public final void setFirstButtonOnClick(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        this.firstButtonClickListener = clickListener;
        if (this.firstButton != null) {
            ProgressButton progressButton = this.firstButton;
            if (progressButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
            }
            progressButton.setOnClickListener(clickListener);
        }
    }

    public final void setSecondButtonOnClick(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        this.secondButtonClickListener = clickListener;
        if (this.secondButton != null) {
            Button button = this.secondButton;
            if (button == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"secondButton");
            }
            button.setOnClickListener(clickListener);
        }
    }

    @NotNull
    public final String getFirstButtonText() {
        return ((Object)this.firstButtonText).toString();
    }

    public final void setIsLoading(boolean isLoading) {
        boolean wasLoading = this.isLoading;
        this.isLoading = isLoading;
        ProgressButton progressButton = this.firstButton;
        if (progressButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
        }
        progressButton.setIsLoading(isLoading);
        if (wasLoading && !isLoading) {
            LottieAnimationView lottieAnimationView = this.icon;
            if (lottieAnimationView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
            }
            lottieAnimationView.playAnimation();
            this.executeHapticFeedback();
        }
    }

    private final void init(Context context, AttributeSet attrs, int defStyleAttr) {
        LayoutInflater.from((Context)context).inflate(R.layout.screen_feedback, (ViewGroup)this, true);
        if (attrs != null) {
            CharSequence it;
            boolean bl;
            boolean bl2;
            Object object;
            Resources.Theme theme = context.getTheme();
            TypedArray typedArray = theme.obtainStyledAttributes(attrs, R.styleable.FeedbackScreen, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"theme.obtainStyledAttrib\u2026kScreen, defStyleAttr, 0)");
            TypedArray styledAttrs = typedArray;
            this.type = styledAttrs.getInteger(R.styleable.FeedbackScreen_feedbackType, 2);
            CharSequence charSequence = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackTitle);
            if (charSequence != null) {
                object = charSequence;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl3 = false;
                this.titleText = it;
            }
            CharSequence charSequence2 = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackSubtitle);
            if (charSequence2 != null) {
                object = charSequence2;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl4 = false;
                this.subtitleText = it;
            }
            object = styledAttrs.getResourceId(R.styleable.FeedbackScreen_feedbackCustomContentLayout, 0);
            bl2 = false;
            bl = false;
            int it2 = ((Number)object).intValue();
            FeedbackScreenView feedbackScreenView = this;
            boolean bl5 = false;
            boolean bl6 = it2 != 0;
            feedbackScreenView.customContentLayout = bl6 ? object : null;
            CharSequence charSequence3 = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackFirstButtonText);
            if (charSequence3 != null) {
                object = charSequence3;
                bl2 = false;
                bl = false;
                Object it3 = object;
                boolean bl7 = false;
                this.firstButtonText = it3;
            }
            CharSequence charSequence4 = styledAttrs.getText(R.styleable.FeedbackScreen_feedbackSecondButtonText);
            if (charSequence4 != null) {
                object = charSequence4;
                bl2 = false;
                bl = false;
                Object it4 = object;
                boolean bl8 = false;
                this.secondButtonText = it4;
            }
            this.secondButtonAsLink = styledAttrs.getBoolean(R.styleable.FeedbackScreen_feedbackSecondButtonAsLink, false);
            styledAttrs.recycle();
        }
        View view = this.findViewById(R.id.icon);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.icon)");
        this.icon = (LottieAnimationView)view;
        View view2 = this.findViewById(R.id.title);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.title)");
        this.title = (TextView)view2;
        View view3 = this.findViewById(R.id.subtitle);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.subtitle)");
        this.subtitle = (TextView)view3;
        View view4 = this.findViewById(R.id.custom_content);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.custom_content)");
        this.customContentContainer = (FrameLayout)view4;
        View view5 = this.findViewById(R.id.buttons_container);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(R.id.buttons_container)");
        this.buttonsContainer = (LinearLayout)view5;
    }

    static /* synthetic */ void init$default(FeedbackScreenView feedbackScreenView, Context context, AttributeSet attributeSet, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        feedbackScreenView.init(context, attributeSet, n);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.configureView();
        this.animateViewsOnFirstLayout();
    }

    private final void configureView() {
        this.configureBackground();
        this.configureIcon();
        this.configureTexts();
        this.configureCustomContentView();
        this.configureButtons();
    }

    private final void configureBackground() {
        Drawable drawable2;
        switch (this.type) {
            case 0: {
                if (this.getBooleanThemeRes(R.attr.feedbackScreenSuccessWithGradient)) {
                    Context context = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    drawable2 = GradientBackgroundFactory.getBackground(context);
                    break;
                }
                if (this.getBooleanThemeRes(R.attr.feedbackScreenSuccessInverse)) {
                    Context context = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    drawable2 = (Drawable)new ColorDrawable(ColorUtilsKt.getThemeColor(context, R.attr.colorBackgroundBrand));
                    break;
                }
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                drawable2 = (Drawable)new ColorDrawable(ColorUtilsKt.getThemeColor(context, R.attr.colorBackground));
                break;
            }
            default: {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                drawable2 = (Drawable)new ColorDrawable(ColorUtilsKt.getThemeColor(context, R.attr.colorBackground));
            }
        }
        Drawable drawable3 = drawable2;
        boolean bl = false;
        boolean bl2 = false;
        Drawable it = drawable3;
        boolean bl3 = false;
        this.setBackground(it);
    }

    private final void configureIcon() {
        switch (this.type) {
            case 0: {
                this.configureIcon(R.attr.feedbackScreenSuccessAnimation, R.attr.feedbackScreenSuccessIcon, R.attr.colorInverse);
                break;
            }
            case 1: {
                this.configureIcon(R.attr.feedbackScreenErrorAnimation, R.attr.feedbackScreenErrorIcon, R.attr.colorError);
                break;
            }
            case 2: {
                this.configureIcon(R.attr.feedbackScreenInfoAnimation, R.attr.feedbackScreenInfoIcon, R.attr.colorBrand);
                break;
            }
        }
    }

    private final void configureIcon(@AttrRes int animationAttr, @AttrRes int imageAttr, @AttrRes int colorAttr) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Integer animationResource = ResUtilsKt.getThemeRes(context, animationAttr, false);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        Integer imageResource = ResUtilsKt.getThemeRes(context2, imageAttr, false);
        if (animationResource != null) {
            LottieAnimationView lottieAnimationView = this.icon;
            if (lottieAnimationView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
            }
            lottieAnimationView.setAnimation(animationResource.intValue());
            LottieAnimationView lottieAnimationView2 = this.icon;
            if (lottieAnimationView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
            }
            lottieAnimationView2.addValueCallback(new KeyPath(new String[]{"**"}), (Object)LottieProperty.COLOR_FILTER, (SimpleLottieValueCallback)new SimpleLottieValueCallback<ColorFilter>(this, colorAttr){
                final /* synthetic */ FeedbackScreenView this$0;
                final /* synthetic */ int $colorAttr;

                public final ColorFilter getValue(LottieFrameInfo<ColorFilter> it) {
                    Context context = this.this$0.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    return (ColorFilter)new PorterDuffColorFilter(ColorUtilsKt.getThemeColor(context, this.$colorAttr), PorterDuff.Mode.SRC_ATOP);
                }
                {
                    this.this$0 = feedbackScreenView;
                    this.$colorAttr = n;
                }
            });
            LottieAnimationView lottieAnimationView3 = this.icon;
            if (lottieAnimationView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
            }
            lottieAnimationView3.setVisibility(0);
        } else if (imageResource != null) {
            Drawable drawable2 = AppCompatResources.getDrawable((Context)this.getContext(), (int)imageResource);
            Intrinsics.checkNotNull((Object)drawable2);
            Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"AppCompatResources.getDr\u2026context, imageResource)!!");
            Drawable unwrappedDrawable = drawable2;
            Drawable drawable3 = DrawableCompat.wrap((Drawable)unwrappedDrawable);
            Context context3 = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
            DrawableCompat.setTint((Drawable)drawable3, (int)ColorUtilsKt.getThemeColor(context3, colorAttr));
            LottieAnimationView lottieAnimationView = this.icon;
            if (lottieAnimationView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
            }
            lottieAnimationView.setImageDrawable(drawable3);
            LottieAnimationView lottieAnimationView4 = this.icon;
            if (lottieAnimationView4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
            }
            lottieAnimationView4.setVisibility(0);
        } else {
            LottieAnimationView lottieAnimationView = this.icon;
            if (lottieAnimationView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
            }
            lottieAnimationView.setVisibility(8);
        }
        this.isIconAnimated = animationResource != null;
        LottieAnimationView lottieAnimationView = this.icon;
        if (lottieAnimationView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
        }
        lottieAnimationView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this){
            final /* synthetic */ FeedbackScreenView this$0;

            public final void onLayoutChange(View $noName_0, int $noName_1, int $noName_2, int $noName_3, int $noName_4, int $noName_5, int $noName_6, int $noName_7, int $noName_8) {
                LottieAnimationView lottieAnimationView = FeedbackScreenView.access$getIcon$p(this.this$0);
                float f = FeedbackScreenView.access$getIcon$p(this.this$0).getWidth();
                Context context = this.this$0.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                lottieAnimationView.setTranslationX(-(f - (float)ViewUtilsKt.convertDpToPx(context, 64)) / (float)2);
            }
            {
                this.this$0 = feedbackScreenView;
            }
        });
    }

    private final void configureTexts() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        int titleTextColor = ColorUtilsKt.getThemeColor(context, this.isInversePresentation() ? R.attr.colorTextPrimaryInverse : R.attr.colorTextPrimary);
        TextView textView = this.title;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"title");
        }
        textView.setTextColor(titleTextColor);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        int subtitleTextColor = ColorUtilsKt.getThemeColor(context2, this.isInversePresentation() ? R.attr.colorTextPrimaryInverse : R.attr.colorTextSecondary);
        TextView textView2 = this.subtitle;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
        }
        textView2.setTextColor(subtitleTextColor);
        this.setFeedbackTitle(this.titleText);
        this.setFeedbackSubtitle(this.subtitleText);
    }

    private final void configureCustomContentView() {
        block3: {
            FrameLayout frameLayout = this.customContentContainer;
            if (frameLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
            }
            frameLayout.removeAllViews();
            Integer n = this.customContentLayout;
            if (n == null) break block3;
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
            FrameLayout frameLayout2 = this.customContentContainer;
            if (frameLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
            }
            layoutInflater.inflate(it, (ViewGroup)frameLayout2, false);
            FrameLayout frameLayout3 = this.customContentContainer;
            if (frameLayout3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
            }
            frameLayout3.setVisibility(0);
        }
    }

    private final void configureButtons() {
        block4: {
            View.OnClickListener it;
            boolean bl;
            boolean bl2;
            View.OnClickListener onClickListener;
            LinearLayout linearLayout = this.buttonsContainer;
            if (linearLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buttonsContainer");
            }
            linearLayout.removeAllViews();
            int layout2 = this.isInversePresentation() ? R.layout.screen_feedback_buttons_inverse : R.layout.screen_feedback_buttons;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
            LinearLayout linearLayout2 = this.buttonsContainer;
            if (linearLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buttonsContainer");
            }
            layoutInflater.inflate(layout2, (ViewGroup)linearLayout2, true);
            View view = this.findViewById(R.id.first_button);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.first_button)");
            this.firstButton = (ProgressButton)view;
            this.setFeedbackFirstButtonText(this.firstButtonText);
            View.OnClickListener onClickListener2 = this.firstButtonClickListener;
            if (onClickListener2 != null) {
                onClickListener = onClickListener2;
                bl2 = false;
                bl = false;
                it = onClickListener;
                boolean bl3 = false;
                this.setFirstButtonOnClick(it);
            }
            ProgressButton progressButton = this.firstButton;
            if (progressButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
            }
            progressButton.setIsLoading(this.isLoading);
            View view2 = this.findViewById(this.secondButtonAsLink ? R.id.link_button : R.id.second_button);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(if (secondB\u2026 else R.id.second_button)");
            this.secondButton = (Button)view2;
            this.setFeedbackSecondButtonText(this.secondButtonText);
            View.OnClickListener onClickListener3 = this.secondButtonClickListener;
            if (onClickListener3 == null) break block4;
            onClickListener = onClickListener3;
            bl2 = false;
            bl = false;
            it = onClickListener;
            boolean bl4 = false;
            this.setSecondButtonOnClick(it);
        }
    }

    private final void animateViewsOnFirstLayout() {
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this){
            final /* synthetic */ FeedbackScreenView this$0;

            public void onGlobalLayout() {
                this.this$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                if (FeedbackScreenView.access$isIconAnimated$p(this.this$0)) {
                    FeedbackScreenView.access$animateViews(this.this$0);
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void animateViews() {
        AnimatorSet animatorSet = new AnimatorSet();
        boolean bl = false;
        boolean bl2 = false;
        AnimatorSet $this$apply = animatorSet;
        boolean bl3 = false;
        Animator[] animatorArray = new Animator[6];
        TextView textView = this.title;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"title");
        }
        animatorArray[0] = (Animator)this.getFadeInAnim((View)textView);
        TextView textView2 = this.subtitle;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
        }
        animatorArray[1] = (Animator)this.getFadeInAnim((View)textView2);
        FrameLayout frameLayout = this.customContentContainer;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
        }
        animatorArray[2] = (Animator)this.getFadeInAnim((View)frameLayout);
        TextView textView3 = this.title;
        if (textView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"title");
        }
        animatorArray[3] = (Animator)this.getTranslationYAnim((View)textView3);
        TextView textView4 = this.subtitle;
        if (textView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
        }
        animatorArray[4] = (Animator)this.getTranslationYAnim((View)textView4);
        FrameLayout frameLayout2 = this.customContentContainer;
        if (frameLayout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
        }
        animatorArray[5] = (Animator)this.getTranslationYAnim((View)frameLayout2);
        $this$apply.playTogether(animatorArray);
        $this$apply.setInterpolator((TimeInterpolator)this.getCubicBezierInterpolator());
        $this$apply.setDuration(800L);
        $this$apply.setStartDelay(200L);
        AnimatorSet animation = animatorSet;
        TextView textView5 = this.title;
        if (textView5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"title");
        }
        textView5.setAlpha(0.0f);
        TextView textView6 = this.subtitle;
        if (textView6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subtitle");
        }
        textView6.setAlpha(0.0f);
        FrameLayout frameLayout3 = this.customContentContainer;
        if (frameLayout3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customContentContainer");
        }
        frameLayout3.setAlpha(0.0f);
        animation.start();
        LottieAnimationView lottieAnimationView = this.icon;
        if (lottieAnimationView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
        }
        lottieAnimationView.playAnimation();
        this.executeHapticFeedback();
    }

    private final void executeHapticFeedback() {
        this.postDelayed(new Runnable(this){
            final /* synthetic */ FeedbackScreenView this$0;

            public final void run() {
                FeedbackScreenView.access$performHapticFeedback(this.this$0);
            }
            {
                this.this$0 = feedbackScreenView;
            }
        }, this.type == 1 ? 500L : 450L);
    }

    private final ObjectAnimator getTranslationYAnim(View view) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        float pixels = ViewUtilsKt.convertDpToPx(context, 20);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{pixels, 0.0f});
        Intrinsics.checkNotNullExpressionValue((Object)objectAnimator, (String)"ObjectAnimator.ofFloat(v\u2026ranslationY\", pixels, 0F)");
        return objectAnimator;
    }

    private final ObjectAnimator getFadeInAnim(View view) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        Intrinsics.checkNotNullExpressionValue((Object)objectAnimator, (String)"ObjectAnimator.ofFloat(view, \"alpha\", 0F, 1F)");
        return objectAnimator;
    }

    private final PathInterpolator getCubicBezierInterpolator() {
        return new PathInterpolator(0.215f, 0.61f, 0.355f, 1.0f);
    }

    private final void performHapticFeedback() {
        switch (this.type) {
            case 0: {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                HapticFeedbacksKt.performHapticFeedback(context, HapticFeedbackType.SUCCESS);
                break;
            }
            case 1: {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                HapticFeedbacksKt.performHapticFeedback(context, HapticFeedbackType.ERROR);
                break;
            }
        }
    }

    private final boolean isInversePresentation() {
        return this.type == 0 && (this.getBooleanThemeRes(R.attr.feedbackScreenSuccessWithGradient) || this.getBooleanThemeRes(R.attr.feedbackScreenSuccessInverse));
    }

    private final boolean getBooleanThemeRes(@AttrRes int attributeRes) {
        boolean bl;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Integer n = ResUtilsKt.getThemeRes$default(context, attributeRes, false, 2, null);
        if (n != null) {
            Integer n2 = n;
            boolean bl2 = false;
            boolean bl3 = false;
            int it = ((Number)n2).intValue();
            boolean bl4 = false;
            bl = it != 0;
        } else {
            bl = false;
        }
        return bl;
    }

    public FeedbackScreenView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.type = 2;
        this.titleText = "";
        this.subtitleText = "";
        this.firstButtonText = "";
        this.secondButtonText = "";
        FeedbackScreenView.init$default(this, context, null, 0, 6, null);
    }

    public FeedbackScreenView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.type = 2;
        this.titleText = "";
        this.subtitleText = "";
        this.firstButtonText = "";
        this.secondButtonText = "";
        FeedbackScreenView.init$default(this, context, attrs, 0, 4, null);
    }

    public FeedbackScreenView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.type = 2;
        this.titleText = "";
        this.subtitleText = "";
        this.firstButtonText = "";
        this.secondButtonText = "";
        this.init(context, attrs, defStyleAttr);
    }

    public static final /* synthetic */ ProgressButton access$getFirstButton$p(FeedbackScreenView $this) {
        ProgressButton progressButton = $this.firstButton;
        if (progressButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"firstButton");
        }
        return progressButton;
    }

    public static final /* synthetic */ void access$setFirstButton$p(FeedbackScreenView $this, ProgressButton progressButton) {
        $this.firstButton = progressButton;
    }

    public static final /* synthetic */ Button access$getSecondButton$p(FeedbackScreenView $this) {
        Button button = $this.secondButton;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secondButton");
        }
        return button;
    }

    public static final /* synthetic */ void access$setSecondButton$p(FeedbackScreenView $this, Button button) {
        $this.secondButton = button;
    }

    public static final /* synthetic */ LottieAnimationView access$getIcon$p(FeedbackScreenView $this) {
        LottieAnimationView lottieAnimationView = $this.icon;
        if (lottieAnimationView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"icon");
        }
        return lottieAnimationView;
    }

    public static final /* synthetic */ void access$setIcon$p(FeedbackScreenView $this, LottieAnimationView lottieAnimationView) {
        $this.icon = lottieAnimationView;
    }

    public static final /* synthetic */ boolean access$isIconAnimated$p(FeedbackScreenView $this) {
        return $this.isIconAnimated;
    }

    public static final /* synthetic */ void access$setIconAnimated$p(FeedbackScreenView $this, boolean bl) {
        $this.isIconAnimated = bl;
    }

    public static final /* synthetic */ void access$animateViews(FeedbackScreenView $this) {
        $this.animateViews();
    }

    public static final /* synthetic */ void access$performHapticFeedback(FeedbackScreenView $this) {
        $this.performHapticFeedback();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/telefonica/mistica/feedback/screen/view/FeedbackScreenView$FeedbackType;", "", "library_release"})
    public static @interface FeedbackType {
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/telefonica/mistica/feedback/screen/view/FeedbackScreenView$Companion;", "", "()V", "HAPTIC_FEEDBACK_DEFAULT_DELAY", "", "HAPTIC_FEEDBACK_ERROR_DELAY", "TEXTS_ANIMATION_DELAY", "TEXTS_ANIMATION_DURATION", "TYPE_ERROR", "", "TYPE_INFO", "TYPE_SUCCESS", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

