/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.input;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.provider.Settings;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.TextView;
import androidx.databinding.BindingAdapter;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import androidx.databinding.InverseBindingListener;
import androidx.databinding.InverseBindingMethod;
import androidx.databinding.InverseBindingMethods;
import androidx.databinding.adapters.ListenerUtil;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.telefonica.mistica.R;
import com.telefonica.mistica.input.Input;
import com.telefonica.mistica.input.validations.NoValidation;
import com.telefonica.mistica.input.validations.TextInputValidation;
import com.telefonica.mistica.input.validations.TextInputValidationResult;
import com.telefonica.mistica.util.ViewUtilsKt;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BindingMethods(value={@BindingMethod(attribute="inputCounterEnabled", method="setCounterEnabled", type=TextInput.class), @BindingMethod(attribute="inputMaxLength", method="setMaxLength", type=TextInput.class), @BindingMethod(attribute="inputAutofillEnabled", method="setAutofillEnabled", type=TextInput.class), @BindingMethod(attribute="inputText", method="setText", type=TextInput.class)})
@InverseBindingMethods(value={@InverseBindingMethod(attribute="inputText", method="getText", type=TextInput.class)})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 82\u00020\u0001:\u000289B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0019J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0002J\b\u0010\u001f\u001a\u00020\u0019H\u0002J\"\u0010 \u001a\u00020!2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0006\u0010\"\u001a\u00020#J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0007J\u0010\u00100\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0007H\u0002J\u000e\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u00020\u0007J\u000e\u00106\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u00107\u001a\u00020\u0019R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/telefonica/mistica/input/TextInput;", "Lcom/telefonica/mistica/input/Input;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "editTextView", "Lcom/google/android/material/textfield/TextInputEditText;", "value", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "type", "getType$annotations", "()V", "validation", "Lcom/telefonica/mistica/input/validations/TextInputValidation;", "addTextChangedListener", "", "watcher", "Landroid/text/TextWatcher;", "clear", "configureAutoFill", "configureEditTextPaddingTop", "configureErrorResetOnTextChange", "handleAttrsAndInflateLayout", "Lcom/google/android/material/textfield/TextInputLayout;", "isValid", "Lcom/telefonica/mistica/input/validations/TextInputValidationResult;", "onCreateInputConnection", "Landroid/view/inputmethod/InputConnection;", "outAttrs", "Landroid/view/inputmethod/EditorInfo;", "removeTextChangedListener", "setAutofillEnabled", "enabled", "", "setCounterEnabled", "setEnabled", "setMaxLength", "maxLength", "setMaxTextLength", "setOnEditorActionListener", "l", "Landroid/widget/TextView$OnEditorActionListener;", "setTopTextPadding", "padding", "setValidation", "validate", "Companion", "TextInputType", "library_release"})
public final class TextInput
extends Input {
    private int type;
    private TextInputEditText editTextView;
    private TextInputValidation validation;
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_EMAIL = 1;
    public static final int TYPE_PASSWORD = 2;
    public static final int TYPE_TEXT_AREA = 3;
    public static final int TYPE_PHONE = 4;
    public static final int NO_MAX_LENGTH = 0;
    @NotNull
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    @Nullable
    public final String getText() {
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        return String.valueOf(textInputEditText.getText());
    }

    public final void setText(@Nullable String value) {
        if (Intrinsics.areEqual((Object)value, (Object)this.getText()) ^ true) {
            TextInputEditText textInputEditText = this.editTextView;
            if (textInputEditText == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            }
            textInputEditText.setText((CharSequence)value);
        }
    }

    private static /* synthetic */ void getType$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TextInputLayout handleAttrsAndInflateLayout(@Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int n;
        String initialText = null;
        boolean initialCounterEnabled = false;
        int initialMaxLength = 0;
        boolean initialAutofillEnabled = true;
        if (attrs != null) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TextInput, defStyleAttr, defStyleRes);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026defStyleRes\n            )");
            TypedArray styledAttrs = typedArray;
            try {
                this.type = styledAttrs.getInt(R.styleable.TextInput_inputType, 0);
                initialText = styledAttrs.getString(R.styleable.TextInput_inputText);
                initialCounterEnabled = styledAttrs.getBoolean(R.styleable.TextInput_inputCounterEnabled, false);
                initialMaxLength = styledAttrs.getInt(R.styleable.TextInput_inputMaxLength, 0);
                initialAutofillEnabled = styledAttrs.getBoolean(R.styleable.TextInput_inputAutofillEnabled, true);
            }
            finally {
                styledAttrs.recycle();
            }
        }
        switch (this.type) {
            case 1: {
                n = R.layout.input_text_email;
                break;
            }
            case 2: {
                n = R.layout.input_text_password;
                break;
            }
            case 3: {
                n = R.layout.input_text_area;
                break;
            }
            case 4: {
                n = R.layout.input_text_phone;
                break;
            }
            default: {
                n = R.layout.input_text;
            }
        }
        int layout2 = n;
        LayoutInflater.from((Context)this.getContext()).inflate(layout2, (ViewGroup)this, true);
        View view = this.findViewById(R.id.text_input);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.text_input)");
        this.editTextView = (TextInputEditText)view;
        this.setMaxTextLength(initialMaxLength);
        this.setText(initialText);
        this.configureAutoFill();
        this.setAutofillEnabled(initialAutofillEnabled);
        this.configureErrorResetOnTextChange();
        this.configureEditTextPaddingTop();
        View view2 = this.findViewById(R.id.text_input_layout);
        boolean bl = false;
        boolean bl2 = false;
        TextInputLayout $this$apply = (TextInputLayout)view2;
        boolean bl3 = false;
        $this$apply.setCounterEnabled(initialCounterEnabled);
        $this$apply.setCounterMaxLength(initialMaxLength);
        View view3 = view2;
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById<TextInputLa\u2026nitialMaxLength\n        }");
        return (TextInputLayout)view3;
    }

    public final void clear() {
        block1: {
            TextInputEditText textInputEditText = this.editTextView;
            if (textInputEditText == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            }
            Editable editable = textInputEditText.getText();
            if (editable == null) break block1;
            editable.clear();
        }
    }

    public final void setCounterEnabled(boolean enabled) {
        this.getLayoutView().setCounterEnabled(enabled);
    }

    public final void setMaxLength(int maxLength) {
        this.getLayoutView().setCounterMaxLength(maxLength);
        this.setMaxTextLength(maxLength);
    }

    public final void setAutofillEnabled(boolean enabled) {
        if (Build.VERSION.SDK_INT >= 26) {
            TextInputEditText textInputEditText = this.editTextView;
            if (textInputEditText == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            }
            textInputEditText.setImportantForAutofill(enabled ? 0 : 2);
        }
    }

    public final void addTextChangedListener(@NotNull TextWatcher watcher) {
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        textInputEditText.addTextChangedListener(watcher);
    }

    public final void removeTextChangedListener(@NotNull TextWatcher watcher) {
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        textInputEditText.removeTextChangedListener(watcher);
    }

    public final void setTopTextPadding(int padding) {
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        int n = textInputEditText2.getPaddingLeft();
        TextInputEditText textInputEditText3 = this.editTextView;
        if (textInputEditText3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        int n2 = textInputEditText3.getPaddingRight();
        TextInputEditText textInputEditText4 = this.editTextView;
        if (textInputEditText4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        textInputEditText.setPadding(n, padding, n2, textInputEditText4.getPaddingBottom());
    }

    public final void setOnEditorActionListener(@NotNull TextView.OnEditorActionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        textInputEditText.setOnEditorActionListener(l);
    }

    public final void setValidation(@NotNull TextInputValidation validation) {
        Intrinsics.checkNotNullParameter((Object)validation, (String)"validation");
        this.validation = validation;
    }

    @NotNull
    public final TextInputValidationResult isValid() {
        return this.validation.isValid(this.getText());
    }

    public final void validate() {
        TextInputValidationResult result = this.isValid();
        if (Intrinsics.areEqual((Object)result, (Object)TextInputValidationResult.Success.INSTANCE)) {
            this.setErrorEnabled(false);
        } else if (result instanceof TextInputValidationResult.Invalid) {
            this.setError(((TextInputValidationResult.Invalid)result).getInvalidMessage());
            this.setErrorEnabled(true);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NotNull EditorInfo outAttrs) {
        Intrinsics.checkNotNullParameter((Object)outAttrs, (String)"outAttrs");
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        return textInputEditText.onCreateInputConnection(outAttrs);
    }

    private final void configureAutoFill() {
        block7: {
            String hint;
            String string;
            if (Build.VERSION.SDK_INT < 26) break block7;
            switch (this.type) {
                case 1: {
                    string = "emailAddress";
                    break;
                }
                case 2: {
                    string = "password";
                    break;
                }
                case 4: {
                    string = "phone";
                    break;
                }
                default: {
                    string = null;
                }
            }
            String string2 = hint = string;
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                TextInputEditText textInputEditText = this.editTextView;
                if (textInputEditText == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
                }
                textInputEditText.setAutofillHints(new String[]{it});
            }
        }
    }

    private final void configureErrorResetOnTextChange() {
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        textInputEditText.addTextChangedListener(new TextWatcher(this){
            final /* synthetic */ TextInput this$0;

            public void afterTextChanged(@Nullable Editable s) {
            }

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                this.this$0.setErrorEnabled(false);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void configureEditTextPaddingTop() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        float fontScale = Settings.System.getFloat((ContentResolver)context.getContentResolver(), (String)"font_scale", (float)1.0f);
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        View view = (View)textInputEditText;
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        ViewUtilsKt.padding$default(view, 0, (int)((float)textInputEditText2.getPaddingTop() * fontScale), 0, 0, 13, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void setMaxTextLength(int maxLength) {
        void $this$filterNotTo$iv$iv;
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        InputFilter[] inputFilterArray = textInputEditText.getFilters();
        Intrinsics.checkNotNullExpressionValue((Object)inputFilterArray, (String)"editTextView.filters");
        InputFilter[] $this$filterNot$iv = inputFilterArray;
        boolean $i$f$filterNot = false;
        InputFilter[] inputFilterArray2 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        void var7_8 = $this$filterNotTo$iv$iv;
        int n = ((void)var7_8).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var7_8[i];
            boolean bl = false;
            if (it instanceof InputFilter.LengthFilter) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        List it = list;
        boolean bl3 = false;
        list = maxLength != 0 ? CollectionsKt.plus((Collection)it, (Object)new InputFilter.LengthFilter(maxLength)) : it;
        bl = false;
        bl2 = false;
        it = list;
        boolean bl4 = false;
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        Collection $this$toTypedArray$iv = it;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        InputFilter[] inputFilterArray3 = thisCollection$iv.toArray(new InputFilter[0]);
        if (inputFilterArray3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        textInputEditText2.setFilters(inputFilterArray3);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
        }
        textInputEditText.setEnabled(enabled);
    }

    @JvmOverloads
    public TextInput(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.validation = new NoValidation();
    }

    public /* synthetic */ TextInput(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(context, attributeSet, n, n2);
    }

    @JvmOverloads
    public TextInput(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public TextInput(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public TextInput(@NotNull Context context) {
        this(context, null, 0, 0, 14, null);
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @BindingAdapter(value={"inputTextAttrChanged"})
    @JvmStatic
    public static final void setTextWatcher(@NotNull TextInput input, @NotNull InverseBindingListener listener) {
        Companion.setTextWatcher(input, listener);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/telefonica/mistica/input/TextInput$TextInputType;", "", "library_release"})
    public static @interface TextInputType {
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/telefonica/mistica/input/TextInput$Companion;", "", "()V", "NO_MAX_LENGTH", "", "TYPE_EMAIL", "TYPE_PASSWORD", "TYPE_PHONE", "TYPE_TEXT", "TYPE_TEXT_AREA", "setTextWatcher", "", "input", "Lcom/telefonica/mistica/input/TextInput;", "listener", "Landroidx/databinding/InverseBindingListener;", "library_release"})
    public static final class Companion {
        @BindingAdapter(value={"inputTextAttrChanged"})
        @JvmStatic
        public final void setTextWatcher(@NotNull TextInput input, @NotNull InverseBindingListener listener) {
            Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            TextWatcher textWatcher2 = new TextWatcher(listener){
                final /* synthetic */ InverseBindingListener $listener;

                public void afterTextChanged(@Nullable Editable s) {
                    this.$listener.onChange();
                }

                public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                }
                {
                    this.$listener = $captured_local_variable$0;
                }
            };
            TextWatcher oldTextWatcher = (TextWatcher)ListenerUtil.trackListener((View)((View)input), (Object)textWatcher2, (int)R.id.textWatcher);
            if (oldTextWatcher != null) {
                input.removeTextChangedListener(oldTextWatcher);
            }
            input.addTextChangedListener(textWatcher2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

