/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.badge;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.view.ViewParent;
import com.google.android.material.badge.BadgeDrawable;
import com.telefonica.mistica.R;
import com.telefonica.mistica.util.ColorUtilsKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0007J\u001c\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0007J,\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00042\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0007J$\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0007J&\u0010\u001d\u001a\u00020\u0016*\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0002J\u001c\u0010\u001f\u001a\u00020\u0016*\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010 \u001a\u00020\u0016*\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R(\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/telefonica/mistica/badge/Badge;", "", "()V", "NON_NUMERIC_BADGE", "", "contentDescriptions", "", "", "getContentDescriptions", "()Ljava/util/Map;", "setContentDescriptions", "(Ljava/util/Map;)V", "buildBadgeContentDescription", "", "anchor", "Landroid/view/View;", "count", "badgeDescription", "createBadge", "Lcom/google/android/material/badge/BadgeDrawable;", "getDefaultBadgeDescription", "removeBadge", "", "removeBadgeWithParent", "parent", "Landroid/view/ViewGroup;", "resetContentDescription", "showBadgeIn", "showNumericBadgeIn", "addToView", "contentDescription", "setBoundsFor", "setupCount", "com.telefonica.mistica"})
public final class Badge {
    @NotNull
    private static Map<Integer, CharSequence> contentDescriptions;
    private static final int NON_NUMERIC_BADGE = 0;
    @NotNull
    public static final Badge INSTANCE;

    @NotNull
    public final Map<Integer, CharSequence> getContentDescriptions() {
        return contentDescriptions;
    }

    public final void setContentDescriptions(@NotNull Map<Integer, CharSequence> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        contentDescriptions = map;
    }

    @JvmStatic
    @NotNull
    public static final BadgeDrawable showBadgeIn(@NotNull View anchor, @Nullable String badgeDescription) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        ViewParent parent = anchor.getParent();
        if (parent instanceof ViewGroup) {
            return Badge.showBadgeIn(anchor, (ViewGroup)parent, badgeDescription);
        }
        throw (Throwable)new RuntimeException("The view's parent is not a ViewGroup. Use showBadgeIn(anchor,parent) instead");
    }

    public static /* synthetic */ BadgeDrawable showBadgeIn$default(View view, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return Badge.showBadgeIn(view, string);
    }

    @JvmStatic
    @NotNull
    public static final BadgeDrawable showBadgeIn(@NotNull View anchor, @NotNull ViewGroup parent, @Nullable String badgeDescription) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        BadgeDrawable badgeDrawable = INSTANCE.createBadge(anchor, 0);
        boolean bl = false;
        boolean bl2 = false;
        BadgeDrawable $this$apply = badgeDrawable;
        boolean bl3 = false;
        INSTANCE.addToView($this$apply, anchor, parent, INSTANCE.buildBadgeContentDescription(anchor, 0, badgeDescription));
        return badgeDrawable;
    }

    public static /* synthetic */ BadgeDrawable showBadgeIn$default(View view, ViewGroup viewGroup, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return Badge.showBadgeIn(view, viewGroup, string);
    }

    @JvmStatic
    @NotNull
    public static final BadgeDrawable showNumericBadgeIn(@NotNull View anchor, int count, @Nullable String badgeDescription) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        ViewParent parent = anchor.getParent();
        if (parent instanceof ViewGroup) {
            return Badge.showNumericBadgeIn(anchor, (ViewGroup)parent, count, badgeDescription);
        }
        throw (Throwable)new RuntimeException("The view's parent is not a ViewGroup. Use showNumericBadgeIn(anchor, parent, count) instead");
    }

    public static /* synthetic */ BadgeDrawable showNumericBadgeIn$default(View view, int n, String string, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        return Badge.showNumericBadgeIn(view, n, string);
    }

    @JvmStatic
    @NotNull
    public static final BadgeDrawable showNumericBadgeIn(@NotNull View anchor, @NotNull ViewGroup parent, int count, @Nullable String badgeDescription) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        BadgeDrawable badgeDrawable = INSTANCE.createBadge(anchor, count);
        boolean bl = false;
        boolean bl2 = false;
        BadgeDrawable $this$apply = badgeDrawable;
        boolean bl3 = false;
        switch (count) {
            case 0: {
                Badge.removeBadge(anchor);
                break;
            }
            default: {
                INSTANCE.addToView($this$apply, anchor, parent, INSTANCE.buildBadgeContentDescription(anchor, count, badgeDescription));
            }
        }
        return badgeDrawable;
    }

    public static /* synthetic */ BadgeDrawable showNumericBadgeIn$default(View view, ViewGroup viewGroup, int n, String string, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string = null;
        }
        return Badge.showNumericBadgeIn(view, viewGroup, n, string);
    }

    @JvmStatic
    public static final void removeBadge(@NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        ViewParent parent = anchor.getParent();
        if (!(parent instanceof ViewGroup)) {
            throw (Throwable)new RuntimeException("The view's parent is not a ViewGroup. Use removeBadge(badge,parent) instead");
        }
        Badge.removeBadgeWithParent((ViewGroup)parent, anchor);
    }

    @JvmStatic
    public static final void removeBadgeWithParent(@NotNull ViewGroup parent, @NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        parent.post(new Runnable(anchor, parent){
            final /* synthetic */ View $anchor;
            final /* synthetic */ ViewGroup $parent;

            public final void run() {
                Badge.access$resetContentDescription(Badge.INSTANCE, this.$anchor);
                this.$parent.getOverlay().clear();
            }
            {
                this.$anchor = view;
                this.$parent = viewGroup;
            }
        });
    }

    private final BadgeDrawable createBadge(View anchor, int count) {
        BadgeDrawable badgeDrawable = BadgeDrawable.create((Context)anchor.getContext());
        boolean bl = false;
        boolean bl2 = false;
        BadgeDrawable $this$apply = badgeDrawable;
        boolean bl3 = false;
        $this$apply.setMaxCharacterCount(2);
        Context context = anchor.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"anchor.context");
        $this$apply.setBackgroundColor(ColorUtilsKt.getThemeColor(context, R.attr.colorBadge));
        INSTANCE.setupCount($this$apply, count);
        BadgeDrawable badgeDrawable2 = badgeDrawable;
        Intrinsics.checkNotNullExpressionValue((Object)badgeDrawable2, (String)"BadgeDrawable.create(anc\u2026  setupCount(count)\n    }");
        return badgeDrawable2;
    }

    private final String buildBadgeContentDescription(View anchor, int count, String badgeDescription) {
        String string;
        if (!contentDescriptions.containsKey(anchor.hashCode())) {
            contentDescriptions.put(anchor.hashCode(), anchor.getContentDescription());
        }
        if ((string = badgeDescription) == null) {
            string = this.getDefaultBadgeDescription(anchor, count);
        }
        String suffix = string;
        CharSequence charSequence = contentDescriptions.get(anchor.hashCode());
        return charSequence == null ? suffix : contentDescriptions.get(anchor.hashCode()) + ", " + suffix;
    }

    private final String getDefaultBadgeDescription(View anchor, int count) {
        String string2 = count == 0 ? anchor.getContext().getString(R.string.badge_notification_description) : String.valueOf(count);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (count == 0) {\n      \u2026   count.toString()\n    }");
        return string2;
    }

    private final void resetContentDescription(View anchor) {
        if (contentDescriptions.containsKey(anchor.hashCode())) {
            anchor.setContentDescription(contentDescriptions.get(anchor.hashCode()));
        }
    }

    private final void setupCount(BadgeDrawable $this$setupCount, int count) {
        $this$setupCount.setMaxCharacterCount(2);
        switch (count) {
            case 0: {
                $this$setupCount.clearNumber();
                break;
            }
            default: {
                $this$setupCount.setNumber(count);
            }
        }
    }

    private final void addToView(BadgeDrawable $this$addToView, View anchor, ViewGroup parent, CharSequence contentDescription) {
        parent.post(new Runnable($this$addToView, anchor, parent, contentDescription){
            final /* synthetic */ BadgeDrawable $this_addToView;
            final /* synthetic */ View $anchor;
            final /* synthetic */ ViewGroup $parent;
            final /* synthetic */ CharSequence $contentDescription;

            public final void run() {
                Badge.access$setBoundsFor(Badge.INSTANCE, this.$this_addToView, this.$anchor, this.$parent);
                ViewGroupOverlay overlay = this.$parent.getOverlay();
                overlay.add((Drawable)this.$this_addToView);
                this.$anchor.setContentDescription(this.$contentDescription);
            }
            {
                this.$this_addToView = badgeDrawable;
                this.$anchor = view;
                this.$parent = viewGroup;
                this.$contentDescription = charSequence;
            }
        });
    }

    private final void setBoundsFor(BadgeDrawable $this$setBoundsFor, View anchor, ViewGroup parent) {
        Rect rect = new Rect();
        parent.getDrawingRect(rect);
        $this$setBoundsFor.setBounds(rect);
        $this$setBoundsFor.updateBadgeCoordinates(anchor, parent);
    }

    private Badge() {
    }

    static {
        Badge badge;
        INSTANCE = badge = new Badge();
        boolean bl = false;
        contentDescriptions = new LinkedHashMap();
    }

    public static final /* synthetic */ void access$resetContentDescription(Badge $this, View anchor) {
        $this.resetContentDescription(anchor);
    }

    public static final /* synthetic */ void access$setBoundsFor(Badge $this, BadgeDrawable $this$access_u24setBoundsFor, View anchor, ViewGroup parent) {
        $this.setBoundsFor($this$access_u24setBoundsFor, anchor, parent);
    }
}

