/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.input;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.provider.Settings;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.databinding.BindingAdapter;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import androidx.databinding.InverseBindingListener;
import androidx.databinding.InverseBindingMethod;
import androidx.databinding.InverseBindingMethods;
import androidx.databinding.adapters.ListenerUtil;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.telefonica.mistica.R;
import com.telefonica.mistica.input.Input;
import com.telefonica.mistica.input.validations.NoValidation;
import com.telefonica.mistica.input.validations.TextInputValidation;
import com.telefonica.mistica.input.validations.TextInputValidationResult;
import com.telefonica.mistica.util.ViewUtilsKt;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BindingMethods(value={@BindingMethod(type=TextInput.class, attribute="inputCounterEnabled", method="setCounterEnabled"), @BindingMethod(type=TextInput.class, attribute="inputMaxLength", method="setMaxLength"), @BindingMethod(type=TextInput.class, attribute="inputAutofillEnabled", method="setAutofillEnabled"), @BindingMethod(type=TextInput.class, attribute="inputText", method="setText")})
@InverseBindingMethods(value={@InverseBindingMethod(type=TextInput.class, attribute="inputText", method="getText")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 :2\u00020\u0001:\u00029:B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%J\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u0007J\u000e\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020\u001cJ\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020\u001cH\u0002J\b\u00105\u001a\u00020\u001cH\u0002J\b\u00106\u001a\u00020\u001cH\u0002J\u0010\u00107\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0007H\u0002J\u0010\u00108\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R(\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/telefonica/mistica/input/TextInput;", "Lcom/telefonica/mistica/input/Input;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "value", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "type", "getType$annotations", "()V", "editTextView", "Lcom/google/android/material/textfield/TextInputEditText;", "validation", "Lcom/telefonica/mistica/input/validations/TextInputValidation;", "handleAttrsAndInflateLayout", "Lcom/google/android/material/textfield/TextInputLayout;", "clear", "", "setCounterEnabled", "enabled", "", "setMaxLength", "maxLength", "setAutofillEnabled", "addTextChangedListener", "watcher", "Landroid/text/TextWatcher;", "removeTextChangedListener", "setTopTextPadding", "padding", "setOnEditorActionListener", "l", "Landroid/widget/TextView$OnEditorActionListener;", "setValidation", "isValid", "Lcom/telefonica/mistica/input/validations/TextInputValidationResult;", "validate", "onCreateInputConnection", "Landroid/view/inputmethod/InputConnection;", "outAttrs", "Landroid/view/inputmethod/EditorInfo;", "configureAutoFill", "configureErrorResetOnTextChange", "configureEditTextPaddingTop", "setMaxTextLength", "setEnabled", "TextInputType", "Companion", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTextInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextInput.kt\ncom/telefonica/mistica/input/TextInput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,301:1\n1#2:302\n4154#3:303\n4254#3,2:304\n37#4:306\n36#4,3:307\n*S KotlinDebug\n*F\n+ 1 TextInput.kt\ncom/telefonica/mistica/input/TextInput\n*L\n245#1:303\n245#1:304,2\n254#1:306\n254#1:307,3\n*E\n"})
public final class TextInput
extends Input {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int type;
    private TextInputEditText editTextView;
    @NotNull
    private TextInputValidation validation;
    public static final int $stable = 8;
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_EMAIL = 1;
    public static final int TYPE_PASSWORD = 2;
    public static final int TYPE_TEXT_AREA = 3;
    public static final int TYPE_PHONE = 4;
    public static final int TYPE_NUMBER = 5;
    public static final int NO_MAX_LENGTH = 0;

    @JvmOverloads
    public TextInput(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.validation = new NoValidation();
    }

    public /* synthetic */ TextInput(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(context, attributeSet, n, n2);
    }

    @Nullable
    public final String getText() {
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        }
        return String.valueOf(textInputEditText.getText());
    }

    public final void setText(@Nullable String value) {
        if (!Intrinsics.areEqual((Object)value, (Object)this.getText())) {
            TextInputEditText textInputEditText = this.editTextView;
            if (textInputEditText == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
                textInputEditText = null;
            }
            textInputEditText.setText((CharSequence)value);
        }
    }

    private static /* synthetic */ void getType$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TextInputLayout handleAttrsAndInflateLayout(@Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        String initialText = null;
        boolean initialCounterEnabled = false;
        int initialMaxLength = 0;
        boolean initialAutofillEnabled = true;
        if (attrs != null) {
            TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.TextInput, defStyleAttr, defStyleRes);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
            TypedArray styledAttrs = typedArray;
            try {
                this.type = styledAttrs.getInt(R.styleable.TextInput_inputType, 0);
                initialText = styledAttrs.getString(R.styleable.TextInput_inputText);
                initialCounterEnabled = styledAttrs.getBoolean(R.styleable.TextInput_inputCounterEnabled, false);
                initialMaxLength = styledAttrs.getInt(R.styleable.TextInput_inputMaxLength, 0);
                initialAutofillEnabled = styledAttrs.getBoolean(R.styleable.TextInput_inputAutofillEnabled, true);
            }
            finally {
                styledAttrs.recycle();
            }
        }
        int layout2 = switch (this.type) {
            case 1 -> R.layout.input_text_email;
            case 2 -> R.layout.input_text_password;
            case 3 -> R.layout.input_text_area;
            case 4 -> R.layout.input_text_phone;
            case 5 -> R.layout.input_text_number;
            default -> R.layout.input_text;
        };
        LayoutInflater.from((Context)this.getContext()).inflate(layout2, (ViewGroup)this, true);
        this.editTextView = (TextInputEditText)this.findViewById(R.id.text_input);
        this.setMaxTextLength(initialMaxLength);
        this.setText(initialText);
        this.configureAutoFill();
        this.setAutofillEnabled(initialAutofillEnabled);
        this.configureErrorResetOnTextChange();
        this.configureEditTextPaddingTop();
        View view = this.findViewById(R.id.text_input_layout);
        TextInputLayout $this$handleAttrsAndInflateLayout_u24lambda_u240 = (TextInputLayout)view;
        boolean bl = false;
        $this$handleAttrsAndInflateLayout_u24lambda_u240.setCounterEnabled(initialCounterEnabled);
        $this$handleAttrsAndInflateLayout_u24lambda_u240.setCounterMaxLength(initialMaxLength);
        View view2 = view;
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"apply(...)");
        return (TextInputLayout)view2;
    }

    public final void clear() {
        block1: {
            TextInputEditText textInputEditText = this.editTextView;
            if (textInputEditText == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
                textInputEditText = null;
            }
            Editable editable = textInputEditText.getText();
            if (editable == null) break block1;
            editable.clear();
        }
    }

    public final void setCounterEnabled(boolean enabled) {
        this.getLayoutView().setCounterEnabled(enabled);
    }

    public final void setMaxLength(int maxLength) {
        this.getLayoutView().setCounterMaxLength(maxLength);
        this.setMaxTextLength(maxLength);
    }

    public final void setAutofillEnabled(boolean enabled) {
        if (Build.VERSION.SDK_INT >= 26) {
            TextInputEditText textInputEditText = this.editTextView;
            if (textInputEditText == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
                textInputEditText = null;
            }
            textInputEditText.setImportantForAutofill(enabled ? 0 : 2);
        }
    }

    public final void addTextChangedListener(@NotNull TextWatcher watcher) {
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        }
        textInputEditText.addTextChangedListener(watcher);
    }

    public final void removeTextChangedListener(@NotNull TextWatcher watcher) {
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        }
        textInputEditText.removeTextChangedListener(watcher);
    }

    public final void setTopTextPadding(int padding) {
        TextInputEditText textInputEditText;
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText2 = null;
        }
        if ((textInputEditText = this.editTextView) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        }
        int n = textInputEditText.getPaddingLeft();
        TextInputEditText textInputEditText3 = this.editTextView;
        if (textInputEditText3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText3 = null;
        }
        int n2 = textInputEditText3.getPaddingRight();
        TextInputEditText textInputEditText4 = this.editTextView;
        if (textInputEditText4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText4 = null;
        }
        textInputEditText2.setPadding(n, padding, n2, textInputEditText4.getPaddingBottom());
    }

    public final void setOnEditorActionListener(@NotNull TextView.OnEditorActionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        }
        textInputEditText.setOnEditorActionListener(l);
    }

    public final void setValidation(@NotNull TextInputValidation validation) {
        Intrinsics.checkNotNullParameter((Object)validation, (String)"validation");
        this.validation = validation;
    }

    @NotNull
    public final TextInputValidationResult isValid() {
        return this.validation.isValid(this.getText());
    }

    public final void validate() {
        TextInputValidationResult result = this.isValid();
        if (Intrinsics.areEqual((Object)result, (Object)TextInputValidationResult.Success.INSTANCE)) {
            this.setErrorEnabled(false);
        } else if (result instanceof TextInputValidationResult.Invalid) {
            this.setError(((TextInputValidationResult.Invalid)result).getInvalidMessage());
            this.setErrorEnabled(true);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NotNull EditorInfo outAttrs) {
        Intrinsics.checkNotNullParameter((Object)outAttrs, (String)"outAttrs");
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        }
        return textInputEditText.onCreateInputConnection(outAttrs);
    }

    private final void configureAutoFill() {
        block7: {
            String hint;
            if (Build.VERSION.SDK_INT < 26) break block7;
            String string2 = hint = (switch (this.type) {
                case 1 -> "emailAddress";
                case 2 -> "password";
                case 4 -> "phone";
                default -> null;
            });
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                TextInputEditText textInputEditText = this.editTextView;
                if (textInputEditText == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
                    textInputEditText = null;
                }
                String[] stringArray = new String[]{it};
                textInputEditText.setAutofillHints(stringArray);
            }
        }
    }

    private final void configureErrorResetOnTextChange() {
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        }
        textInputEditText.addTextChangedListener(new TextWatcher(this){
            final /* synthetic */ TextInput this$0;
            {
                this.this$0 = $receiver;
            }

            public void afterTextChanged(Editable s) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                this.this$0.setErrorEnabled(false);
            }
        });
    }

    private final void configureEditTextPaddingTop() {
        float fontScale = Settings.System.getFloat((ContentResolver)this.getContext().getContentResolver(), (String)"font_scale", (float)1.0f);
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        }
        View view = (View)textInputEditText;
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText2 = null;
        }
        ViewUtilsKt.padding$default(view, 0, (int)((float)textInputEditText2.getPaddingTop() * fontScale), 0, 0, 13, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void setMaxTextLength(int maxLength) {
        void $this$filterNotTo$iv$iv;
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        }
        InputFilter[] inputFilterArray = textInputEditText.getFilters();
        Intrinsics.checkNotNullExpressionValue((Object)inputFilterArray, (String)"getFilters(...)");
        Object[] $this$filterNot$iv = inputFilterArray;
        boolean $i$f$filterNot = false;
        Object[] objectArray = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (void element$iv$iv : $this$filterNotTo$iv$iv) {
            InputFilter it = (InputFilter)element$iv$iv;
            boolean bl = false;
            if (it instanceof InputFilter.LengthFilter) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        it = maxLength != 0 ? CollectionsKt.plus((Collection)it, (Object)new InputFilter.LengthFilter(maxLength)) : it;
        boolean bl2 = false;
        TextInputEditText textInputEditText2 = this.editTextView;
        if (textInputEditText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText2 = null;
        }
        Collection $this$toTypedArray$iv = it;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        textInputEditText2.setFilters(thisCollection$iv.toArray(new InputFilter[0]));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        TextInputEditText textInputEditText = this.editTextView;
        if (textInputEditText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"editTextView");
            textInputEditText = null;
        }
        textInputEditText.setEnabled(enabled);
    }

    @JvmOverloads
    public TextInput(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public TextInput(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public TextInput(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 0, 14, null);
    }

    @BindingAdapter(value={"inputTextAttrChanged"})
    @JvmStatic
    public static final void setTextWatcher(@NotNull TextInput input, @NotNull InverseBindingListener listener2) {
        Companion.setTextWatcher(input, listener2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/telefonica/mistica/input/TextInput$Companion;", "", "<init>", "()V", "TYPE_TEXT", "", "TYPE_EMAIL", "TYPE_PASSWORD", "TYPE_TEXT_AREA", "TYPE_PHONE", "TYPE_NUMBER", "NO_MAX_LENGTH", "setTextWatcher", "", "input", "Lcom/telefonica/mistica/input/TextInput;", "listener", "Landroidx/databinding/InverseBindingListener;", "com.telefonica.mistica_release"})
    public static final class Companion {
        private Companion() {
        }

        @BindingAdapter(value={"inputTextAttrChanged"})
        @JvmStatic
        public final void setTextWatcher(@NotNull TextInput input, @NotNull InverseBindingListener listener2) {
            Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            TextWatcher textWatcher2 = new TextWatcher(listener2){
                final /* synthetic */ InverseBindingListener $listener;
                {
                    this.$listener = $listener;
                }

                public void afterTextChanged(Editable s) {
                    this.$listener.onChange();
                }

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                }
            };
            TextWatcher oldTextWatcher = (TextWatcher)ListenerUtil.trackListener((View)((View)input), (Object)textWatcher2, (int)R.id.textWatcher);
            if (oldTextWatcher != null) {
                input.removeTextChangedListener(oldTextWatcher);
            }
            input.addTextChangedListener(textWatcher2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/telefonica/mistica/input/TextInput$TextInputType;", "", "com.telefonica.mistica_release"})
    public static @interface TextInputType {
    }
}

