/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.highlightedcard;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import com.telefonica.mistica.R;
import com.telefonica.mistica.util.ColorUtilsKt;
import com.telefonica.mistica.util.DimensionUtilsKt;
import com.telefonica.mistica.util.DrawableBuilder;
import com.telefonica.mistica.util.DrawableUtilsKt;
import com.telefonica.mistica.util.ViewUtilsKt;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BindingMethods(value={@BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardBackground", method="setCustomBackground"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardInverse", method="setInverse"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardTitle", method="setTitle"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardContent", method="setContent"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardButtonStyle", method="setButtonStyle"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardImageStyle", method="setImageStyle"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardImage", method="setImage"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardButton", method="setButtonText"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardImageVisibility", method="setImageVisibility"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardCloseButtonVisibility", method="setCloseVisibility"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardButtonOnClick", method="setButtonOnClick"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardCloseButton", method="setCloseButton"), @BindingMethod(type=HighlightedCardView.class, attribute="highlightedCardCloseButtonOnClick", method="setCloseButtonOnClick")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 E2\u00020\u0001:\u0003CDEB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0016J\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#J\u0010\u0010!\u001a\u00020\u001f2\b\b\u0001\u0010$\u001a\u00020\u0007J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#J\u0010\u0010%\u001a\u00020\u001f2\b\b\u0001\u0010$\u001a\u00020\u0007J\u0010\u0010&\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010#J\u0017\u0010&\u001a\u00020\u001f2\n\b\u0001\u0010$\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010'J\u000e\u0010(\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u0007J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u001aJ\u0010\u0010+\u001a\u00020\u001f2\b\b\u0001\u0010,\u001a\u00020\u0007J\u000e\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0007J\u0010\u0010/\u001a\u00020\u001f2\b\b\u0001\u0010,\u001a\u00020\u0007J\u000e\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020-J\u0006\u00101\u001a\u00020\u001fJ\u000e\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020#J\b\u00104\u001a\u00020\u001aH\u0002J\u000e\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u0016J\u0006\u00107\u001a\u00020\u001fJ\b\u00108\u001a\u00020\u001fH\u0002J\b\u00109\u001a\u00020\u001fH\u0002J\b\u0010:\u001a\u00020\u001fH\u0002J\b\u0010;\u001a\u00020\u001fH\u0002J\b\u0010<\u001a\u00020\u001fH\u0002J\b\u0010=\u001a\u00020\u001fH\u0002J\b\u0010>\u001a\u00020\u001fH\u0002J\b\u0010?\u001a\u00020\u001fH\u0002J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/telefonica/mistica/highlightedcard/HighlightedCardView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "titleTextView", "Landroid/widget/TextView;", "contentTextView", "image", "Landroid/widget/ImageView;", "closeButton", "closeButtonBackground", "Landroid/view/View;", "container", "button", "Landroid/widget/Button;", "buttonClickListener", "Landroid/view/View$OnClickListener;", "buttonText", "", "isInverse", "", "hasCustomBackground", "buttonStyle", "imageStyle", "setButtonOnClick", "", "onClickListener", "setTitle", "text", "", "textRes", "setContent", "setButtonText", "(Ljava/lang/Integer;)V", "setButtonStyle", "setInverse", "inverse", "setImage", "imageRes", "Landroid/graphics/drawable/Drawable;", "setImageStyle", "setCustomBackground", "drawable", "disableCustomBackground", "setCloseButton", "buttonContentDescription", "showCloseButtonBackground", "setCloseButtonOnClick", "onButtonClick", "removeCloseButton", "configureColors", "configureBackground", "configureImage", "showFillImage", "showFitImage", "hideImage", "reload", "configureButton", "getRoundedCornerBitmap", "Landroid/graphics/Bitmap;", "bitmap", "ButtonStyle", "ImageStyle", "Companion", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHighlightedCardView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlightedCardView.kt\ncom/telefonica/mistica/highlightedcard/HighlightedCardView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BitmapDrawable.kt\nandroidx/core/graphics/drawable/BitmapDrawableKt\n+ 4 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n*L\n1#1,394:1\n1#2:395\n28#3:396\n90#4,6:397\n*S KotlinDebug\n*F\n+ 1 HighlightedCardView.kt\ncom/telefonica/mistica/highlightedcard/HighlightedCardView\n*L\n263#1:396\n367#1:397,6\n*E\n"})
public final class HighlightedCardView
extends ConstraintLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextView titleTextView;
    @NotNull
    private final TextView contentTextView;
    @NotNull
    private final ImageView image;
    @NotNull
    private final ImageView closeButton;
    @NotNull
    private final View closeButtonBackground;
    @NotNull
    private final ConstraintLayout container;
    @Nullable
    private Button button;
    @Nullable
    private View.OnClickListener buttonClickListener;
    @Nullable
    private String buttonText;
    private boolean isInverse;
    private boolean hasCustomBackground;
    private int buttonStyle;
    private int imageStyle;
    public static final int $stable = 8;
    public static final int BUTTON_STYLE_PRIMARY = 0;
    public static final int BUTTON_STYLE_SECONDARY = 1;
    public static final int BUTTON_STYLE_LINK = 2;
    public static final int BUTTON_STYLE_NO_BUTTON = 3;
    public static final int IMAGE_STYLE_MODE_FIT = 0;
    public static final int IMAGE_STYLE_MODE_FILL = 1;
    public static final int IMAGE_STYLE_NO_IMAGE = 2;

    @JvmOverloads
    public HighlightedCardView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.buttonStyle = 3;
        this.imageStyle = 2;
        LayoutInflater.from((Context)context).inflate(R.layout.highlighted_card_view, (ViewGroup)this, true);
        this.titleTextView = (TextView)this.findViewById(R.id.highlighted_card_title);
        this.contentTextView = (TextView)this.findViewById(R.id.highlighted_card_content);
        this.button = (Button)this.findViewById(R.id.highlighted_card_button_primary);
        this.image = (ImageView)this.findViewById(R.id.highlighted_card_image);
        this.closeButton = (ImageView)this.findViewById(R.id.highlighted_card_close_button);
        this.closeButtonBackground = this.findViewById(R.id.highlighted_card_close_button_background);
        this.container = (ConstraintLayout)this.findViewById(R.id.highlighted_card_container);
        if (attrs != null) {
            Object object;
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.HighlightedCardView, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
            TypedArray styledAttrs = typedArray;
            Integer n = styledAttrs.getResourceId(R.styleable.HighlightedCardView_highlightedCardBackground, 0);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Object object2 = object = it != 0 ? n : null;
            if (object != null) {
                int it2 = ((Number)object).intValue();
                boolean bl2 = false;
                n = AppCompatResources.getDrawable((Context)context, (int)it2);
                if (n != null) {
                    Integer it3 = n;
                    boolean bl3 = false;
                    this.setCustomBackground((Drawable)it3);
                }
            }
            this.isInverse = styledAttrs.getBoolean(R.styleable.HighlightedCardView_highlightedCardInverse, false);
            object = styledAttrs.getText(R.styleable.HighlightedCardView_highlightedCardTitle);
            if (object != null) {
                Object it4 = object;
                boolean bl4 = false;
                this.titleTextView.setText((CharSequence)it4);
            }
            object = styledAttrs.getText(R.styleable.HighlightedCardView_highlightedCardContent);
            if (object != null) {
                Object it5 = object;
                boolean bl5 = false;
                this.contentTextView.setText((CharSequence)it5);
            }
            object = styledAttrs.getText(R.styleable.HighlightedCardView_highlightedCardButton);
            if (object != null) {
                Object it6 = object;
                boolean bl6 = false;
                this.buttonText = it6.toString();
            }
            String string2 = this.buttonText;
            if (string2 != null) {
                String it7 = string2;
                boolean bl7 = false;
                Button button = this.button;
                if (button != null) {
                    button.setText((CharSequence)it7);
                }
            }
            this.buttonStyle = styledAttrs.getInt(R.styleable.HighlightedCardView_highlightedCardButtonStyle, 3);
            this.imageStyle = styledAttrs.getInt(R.styleable.HighlightedCardView_highlightedCardImageStyle, 2);
            object = styledAttrs.getText(R.styleable.HighlightedCardView_highlightedCardCloseButton);
            if (object != null) {
                Object it8 = object;
                boolean bl8 = false;
                this.setCloseButton((CharSequence)it8);
            }
            n = styledAttrs.getResourceId(R.styleable.HighlightedCardView_highlightedCardImage, 0);
            int it9 = ((Number)n).intValue();
            boolean bl9 = false;
            Object object3 = object = it9 != 0 ? n : null;
            if (object != null) {
                int it10 = ((Number)object).intValue();
                boolean bl10 = false;
                n = AppCompatResources.getDrawable((Context)context, (int)it10);
                if (n != null) {
                    Integer it11 = n;
                    boolean bl11 = false;
                    this.setImage((Drawable)it11);
                }
            }
            styledAttrs.recycle();
        }
        this.reload();
    }

    public /* synthetic */ HighlightedCardView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final void setButtonOnClick(@Nullable View.OnClickListener onClickListener) {
        block0: {
            this.buttonClickListener = onClickListener;
            Button button = this.button;
            if (button == null) break block0;
            button.setOnClickListener(onClickListener);
        }
    }

    public final void setTitle(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.titleTextView.setText(text);
    }

    public final void setTitle(@StringRes int textRes) {
        String string2 = this.getContext().getString(textRes);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        this.setTitle(string2);
    }

    public final void setContent(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.contentTextView.setText(text);
    }

    public final void setContent(@StringRes int textRes) {
        String string2 = this.getContext().getString(textRes);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        this.setContent(string2);
    }

    public final void setButtonText(@Nullable CharSequence text) {
        CharSequence charSequence = text;
        if (charSequence != null) {
            CharSequence it = charSequence;
            boolean bl = false;
            this.buttonText = ((Object)it).toString();
        }
        this.configureButton();
    }

    public final void setButtonText(@StringRes @Nullable Integer textRes) {
        block0: {
            Integer n = textRes;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.setButtonText(this.getContext().getString(it));
        }
    }

    public final void setButtonStyle(int buttonStyle) {
        this.buttonStyle = buttonStyle;
        this.configureButton();
    }

    public final void setInverse(boolean inverse) {
        this.isInverse = inverse;
        this.reload();
    }

    public final void setImage(@DrawableRes int imageRes) {
        this.image.setImageResource(imageRes);
        this.configureImage();
    }

    public final void setImage(@NotNull Drawable imageRes) {
        Intrinsics.checkNotNullParameter((Object)imageRes, (String)"imageRes");
        this.image.setImageDrawable(imageRes);
        this.configureImage();
    }

    public final void setImageStyle(int imageStyle) {
        this.imageStyle = imageStyle;
        this.configureImage();
    }

    public final void setCustomBackground(@DrawableRes int imageRes) {
        Drawable drawable2 = AppCompatResources.getDrawable((Context)this.getContext(), (int)imageRes);
        Intrinsics.checkNotNull((Object)drawable2);
        this.setCustomBackground(drawable2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setCustomBackground(@NotNull Drawable drawable2) {
        void $this$toDrawable$iv;
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"getBitmap(...)");
        Bitmap bitmap2 = this.getRoundedCornerBitmap(bitmap);
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"getResources(...)");
        Resources resources$iv = resources;
        boolean $i$f$toDrawable = false;
        BitmapDrawable roundedCornerBitmap = new BitmapDrawable(resources$iv, (Bitmap)$this$toDrawable$iv);
        this.container.setBackground((Drawable)roundedCornerBitmap);
        this.hasCustomBackground = true;
    }

    public final void disableCustomBackground() {
        this.hasCustomBackground = false;
        this.configureBackground();
    }

    public final void setCloseButton(@NotNull CharSequence buttonContentDescription) {
        Intrinsics.checkNotNullParameter((Object)buttonContentDescription, (String)"buttonContentDescription");
        this.closeButton.setContentDescription(buttonContentDescription);
        ViewUtilsKt.show((View)this.closeButton);
        boolean bl = this.showCloseButtonBackground();
        if (bl) {
            ViewUtilsKt.show(this.closeButtonBackground);
        } else if (!bl) {
            ViewUtilsKt.hide(this.closeButtonBackground);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final boolean showCloseButtonBackground() {
        return this.isInverse || this.hasCustomBackground || this.imageStyle == 1;
    }

    public final void setCloseButtonOnClick(@NotNull View.OnClickListener onButtonClick) {
        Intrinsics.checkNotNullParameter((Object)onButtonClick, (String)"onButtonClick");
        this.closeButton.setOnClickListener(onButtonClick);
    }

    public final void removeCloseButton() {
        ViewUtilsKt.hide((View)this.closeButton);
        ViewUtilsKt.hide(this.closeButtonBackground);
    }

    private final void configureColors() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        int primaryColor = ColorUtilsKt.getThemeColor(context, this.isInverse ? R.attr.colorTextPrimaryInverse : R.attr.colorTextPrimary);
        this.titleTextView.setTextColor(primaryColor);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        int secondaryColor = ColorUtilsKt.getThemeColor(context2, this.isInverse ? R.attr.colorTextSecondaryInverse : R.attr.colorTextSecondary);
        this.contentTextView.setTextColor(secondaryColor);
    }

    private final void configureBackground() {
        if (!this.hasCustomBackground) {
            Drawable drawable2;
            if (this.isInverse) {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                drawable2 = DrawableBuilder.withBorderStroke$default(DrawableBuilder.withCornerRadius$default(DrawableUtilsKt.getMisticaThemeDrawableBuilder(context, R.attr.drawableBackgroundBrand), null, 1, null), null, null, 3, null).get();
            } else {
                drawable2 = AppCompatResources.getDrawable((Context)this.getContext(), (int)R.drawable.highlighted_card_background);
            }
            Drawable backgroundDrawable = drawable2;
            this.container.setBackground(backgroundDrawable);
        }
    }

    private final void configureImage() {
        switch (this.imageStyle) {
            case 0: {
                this.showFitImage();
                break;
            }
            case 1: {
                this.showFillImage();
                break;
            }
            case 2: {
                this.hideImage();
            }
        }
    }

    private final void showFillImage() {
        this.image.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.image.setVisibility(0);
    }

    private final void showFitImage() {
        this.image.setScaleType(ImageView.ScaleType.FIT_END);
        this.image.setVisibility(0);
    }

    private final void hideImage() {
        this.image.setVisibility(8);
    }

    private final void reload() {
        this.configureButton();
        this.configureBackground();
        this.configureColors();
        this.configureImage();
    }

    private final void configureButton() {
        Button button;
        Button button2 = button = (switch (this.buttonStyle) {
            case 0 -> (Button)this.findViewById(this.isInverse ? R.id.highlighted_card_button_primary_inverse : R.id.highlighted_card_button_primary);
            case 1 -> (Button)this.findViewById(this.isInverse ? R.id.highlighted_card_button_secondary_inverse : R.id.highlighted_card_button_secondary);
            case 2 -> (Button)this.findViewById(this.isInverse ? R.id.highlighted_card_button_link_inverse : R.id.highlighted_card_button_link);
            default -> null;
        });
        if (button2 != null) {
            button2.setOnClickListener(this.buttonClickListener);
        }
        Button button3 = button;
        if (button3 != null) {
            button3.setText((CharSequence)this.buttonText);
        }
        if (!Intrinsics.areEqual((Object)this.button, (Object)button)) {
            Button button4 = button;
            if (button4 != null) {
                button4.setVisibility(0);
            }
            Button button5 = this.button;
            if (button5 != null) {
                button5.setVisibility(8);
            }
            this.button = button;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Bitmap getRoundedCornerBitmap(Bitmap bitmap) {
        void width$iv;
        int n = bitmap.getWidth();
        int height$iv = bitmap.getHeight();
        Bitmap.Config config$iv = Bitmap.Config.ARGB_8888;
        boolean $i$f$createBitmap = false;
        Bitmap output = Bitmap.createBitmap((int)width$iv, (int)height$iv, (Bitmap.Config)config$iv);
        Canvas canvas = new Canvas(output);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        int color = ColorUtilsKt.getThemeColor(context, R.attr.colorBorder);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        float roundPx = DimensionUtilsKt.getDimension(context2, R.attr.containerBorderRadius);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(color);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    @JvmOverloads
    public HighlightedCardView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public HighlightedCardView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/telefonica/mistica/highlightedcard/HighlightedCardView$ButtonStyle;", "", "com.telefonica.mistica_release"})
    public static @interface ButtonStyle {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/telefonica/mistica/highlightedcard/HighlightedCardView$Companion;", "", "<init>", "()V", "BUTTON_STYLE_PRIMARY", "", "BUTTON_STYLE_SECONDARY", "BUTTON_STYLE_LINK", "BUTTON_STYLE_NO_BUTTON", "IMAGE_STYLE_MODE_FIT", "IMAGE_STYLE_MODE_FILL", "IMAGE_STYLE_NO_IMAGE", "com.telefonica.mistica_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/telefonica/mistica/highlightedcard/HighlightedCardView$ImageStyle;", "", "com.telefonica.mistica_release"})
    public static @interface ImageStyle {
    }
}

