/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.sheet;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.Space;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.lifecycle.ViewTreeLifecycleOwner;
import androidx.lifecycle.ViewTreeViewModelStoreOwner;
import androidx.savedstate.SavedStateRegistryOwner;
import androidx.savedstate.ViewTreeSavedStateRegistryOwner;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.telefonica.mistica.R;
import com.telefonica.mistica.sheet.Children;
import com.telefonica.mistica.sheet.InternalOnSheetTapped;
import com.telefonica.mistica.sheet.OnSheetTapped;
import com.telefonica.mistica.sheet.SheetKt;
import com.telefonica.mistica.sheet.SheetModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\nH\u0002J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J(\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J(\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/telefonica/mistica/sheet/SheetView;", "Lcom/google/android/material/bottomsheet/BottomSheetDialog;", "context", "Landroid/content/Context;", "sheetModel", "Lcom/telefonica/mistica/sheet/SheetModel;", "onSheetTapped", "Lcom/telefonica/mistica/sheet/OnSheetTapped;", "onDismiss", "Lkotlin/Function0;", "", "onCancel", "<init>", "(Landroid/content/Context;Lcom/telefonica/mistica/sheet/SheetModel;Lcom/telefonica/mistica/sheet/OnSheetTapped;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "initViewTreeOwners", "extractActivity", "Landroid/app/Activity;", "fillData", "root", "Landroid/view/View;", "onSheetTappedWrapped", "Lcom/telefonica/mistica/sheet/InternalOnSheetTapped;", "fillHeader", "fillContent", "setUpBehavior", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSheet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sheet.kt\ncom/telefonica/mistica/sheet/SheetView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n1863#2,2:306\n*S KotlinDebug\n*F\n+ 1 Sheet.kt\ncom/telefonica/mistica/sheet/SheetView\n*L\n118#1:306,2\n*E\n"})
public class SheetView
extends BottomSheetDialog {
    @NotNull
    private final OnSheetTapped onSheetTapped;
    @NotNull
    private final Function0<Unit> onDismiss;
    @NotNull
    private final Function0<Unit> onCancel;
    public static final int $stable = 8;

    public SheetView(@NotNull Context context, @NotNull SheetModel sheetModel, @NotNull OnSheetTapped onSheetTapped2, @NotNull Function0<Unit> onDismiss, @NotNull Function0<Unit> onCancel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sheetModel, (String)"sheetModel");
        Intrinsics.checkNotNullParameter((Object)onSheetTapped2, (String)"onSheetTapped");
        Intrinsics.checkNotNullParameter(onDismiss, (String)"onDismiss");
        Intrinsics.checkNotNullParameter(onCancel, (String)"onCancel");
        super(context, R.style.SheetDialogTheme);
        this.onSheetTapped = onSheetTapped2;
        this.onDismiss = onDismiss;
        this.onCancel = onCancel;
        this.initViewTreeOwners();
        InternalOnSheetTapped onSheetTappedWrapped2 = new InternalOnSheetTapped(this){
            final /* synthetic */ SheetView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onTapped(String childrenId, String itemId) {
                Intrinsics.checkNotNullParameter((Object)childrenId, (String)"childrenId");
                Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
                SheetView.access$getOnSheetTapped$p(this.this$0).onTapped(this.this$0, childrenId, itemId);
            }
        };
        View root = View.inflate((Context)this.getContext(), (int)R.layout.sheet_layout, null);
        ViewCompat.setAccessibilityPaneTitle((View)root, (CharSequence)" ");
        this.setContentView(root);
        Intrinsics.checkNotNull((Object)root);
        this.setUpBehavior(root);
        this.fillData(root, sheetModel, context, onSheetTappedWrapped2);
    }

    public /* synthetic */ SheetView(Context context, SheetModel sheetModel, OnSheetTapped onSheetTapped2, Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function0 = SheetView::_init_$lambda$0;
        }
        if ((n & 0x10) != 0) {
            function02 = SheetView::_init_$lambda$1;
        }
        this(context, sheetModel, onSheetTapped2, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    private final void initViewTreeOwners() {
        block2: {
            View decorView;
            Activity activity = this.extractActivity(this.getContext());
            Window window = this.getWindow();
            View view = decorView = window != null ? window.getDecorView() : null;
            if (view != null) {
                ViewTreeLifecycleOwner.set((View)view, (LifecycleOwner)(activity instanceof LifecycleOwner ? (LifecycleOwner)activity : null));
            }
            View view2 = decorView;
            if (view2 != null) {
                ViewTreeViewModelStoreOwner.set((View)view2, (ViewModelStoreOwner)(activity instanceof ViewModelStoreOwner ? (ViewModelStoreOwner)activity : null));
            }
            View view3 = decorView;
            if (view3 == null) break block2;
            ViewTreeSavedStateRegistryOwner.set((View)view3, (SavedStateRegistryOwner)(activity instanceof SavedStateRegistryOwner ? (SavedStateRegistryOwner)activity : null));
        }
    }

    private final Activity extractActivity(Context context) {
        Context currentContext = context;
        while (currentContext != null) {
            if (currentContext instanceof Activity) {
                return (Activity)currentContext;
            }
            if (!(currentContext instanceof ContextWrapper)) break;
            currentContext = ((ContextWrapper)currentContext).getBaseContext();
        }
        return null;
    }

    private final void fillData(View root, SheetModel sheetModel, Context context, InternalOnSheetTapped onSheetTappedWrapped2) {
        this.fillHeader(root, sheetModel);
        this.fillContent(root, sheetModel, context, onSheetTappedWrapped2);
    }

    private final void fillHeader(View root, SheetModel sheetModel) {
        View handler = root.findViewById(R.id.handler);
        TextView title = (TextView)root.findViewById(R.id.title);
        TextView subtitle = (TextView)root.findViewById(R.id.subtitle);
        TextView description = (TextView)root.findViewById(R.id.description);
        Space titleSpace = (Space)root.findViewById(R.id.title_space);
        String titleText = sheetModel.getHeader().getTitle();
        String subtitleText = sheetModel.getHeader().getSubtitle();
        String descriptionText = sheetModel.getHeader().getDescription();
        handler.setOnClickListener(arg_0 -> SheetView.fillHeader$lambda$2(this, arg_0));
        Intrinsics.checkNotNull((Object)title);
        SheetKt.access$setTextOrHide(title, titleText);
        ViewCompat.setAccessibilityHeading((View)((View)title), (boolean)true);
        Intrinsics.checkNotNull((Object)titleSpace);
        SheetKt.access$setSpaceOrGone(titleSpace, titleText);
        Intrinsics.checkNotNull((Object)subtitle);
        SheetKt.access$setTextOrHide(subtitle, subtitleText);
        Intrinsics.checkNotNull((Object)description);
        SheetKt.access$setTextOrHide(description, descriptionText);
    }

    private final void fillContent(View root, SheetModel sheetModel, Context context, InternalOnSheetTapped onSheetTappedWrapped2) {
        LinearLayout container = (LinearLayout)root.findViewById(R.id.container);
        List<Children> children = sheetModel.getContent();
        Iterable $this$forEach$iv = children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Children it = (Children)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)container);
            container.addView(SheetKt.access$toView(it, context, onSheetTappedWrapped2, (ViewGroup)container));
        }
    }

    private final void setUpBehavior(View root) {
        ViewParent viewParent = root.getParent();
        Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
        ViewGroup.LayoutParams layoutParams = ((View)viewParent).getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.coordinatorlayout.widget.CoordinatorLayout.LayoutParams");
        CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)layoutParams;
        CoordinatorLayout.Behavior behavior = params.getBehavior();
        if (behavior instanceof BottomSheetBehavior) {
            ((BottomSheetBehavior)behavior).addBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(this){
                final /* synthetic */ SheetView this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onStateChanged(View bottomSheet, int newState) {
                    Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
                    if (newState == 5) {
                        this.this$0.dismiss();
                    }
                }

                public void onSlide(View bottomSheet, float slideOffset) {
                    Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
                }
            });
            Resources resources = this.getContext().getResources();
            if (resources != null && (resources = resources.getDisplayMetrics()) != null) {
                int height = resources.heightPixels;
                boolean bl = false;
                ((BottomSheetBehavior)behavior).setMaxHeight((int)((double)height * 0.7));
            }
        }
        this.setCanceledOnTouchOutside(true);
        this.setOnDismissListener(arg_0 -> SheetView.setUpBehavior$lambda$5(this, arg_0));
        this.setOnCancelListener(arg_0 -> SheetView.setUpBehavior$lambda$6(this, arg_0));
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1() {
        return Unit.INSTANCE;
    }

    private static final void fillHeader$lambda$2(SheetView this$0, View it) {
        this$0.cancel();
    }

    private static final void setUpBehavior$lambda$5(SheetView this$0, DialogInterface it) {
        this$0.onDismiss.invoke();
    }

    private static final void setUpBehavior$lambda$6(SheetView this$0, DialogInterface it) {
        this$0.onCancel.invoke();
    }

    public static final /* synthetic */ OnSheetTapped access$getOnSheetTapped$p(SheetView $this) {
        return $this.onSheetTapped;
    }
}

