/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.badge;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.android.material.badge.BadgeDrawable;
import com.telefonica.mistica.R;
import com.telefonica.mistica.util.ColorUtilsKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J,\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00062\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u001d\u001a\u00020\u0017*\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J&\u0010\u001e\u001a\u00020\u0017*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u0002J\u001c\u0010 \u001a\u00020\u0017*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R(\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010!\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/telefonica/mistica/badge/Badge;", "", "<init>", "()V", "contentDescriptions", "", "", "", "getContentDescriptions", "()Ljava/util/Map;", "setContentDescriptions", "(Ljava/util/Map;)V", "showBadgeIn", "Lcom/google/android/material/badge/BadgeDrawable;", "anchor", "Landroid/view/View;", "parent", "Landroid/widget/FrameLayout;", "badgeDescription", "", "showNumericBadgeIn", "count", "removeBadge", "", "removeBadgeWithParent", "Landroid/view/ViewGroup;", "createBadge", "buildBadgeContentDescription", "resetContentDescription", "setupCount", "addToView", "contentDescription", "setBoundsFor", "NON_NUMERIC_BADGE", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
public final class Badge {
    @NotNull
    public static final Badge INSTANCE = new Badge();
    @NotNull
    private static Map<Integer, CharSequence> contentDescriptions = new LinkedHashMap();
    private static final int NON_NUMERIC_BADGE = 0;
    public static final int $stable = 8;

    private Badge() {
    }

    @NotNull
    public final Map<Integer, CharSequence> getContentDescriptions() {
        return contentDescriptions;
    }

    public final void setContentDescriptions(@NotNull Map<Integer, CharSequence> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        contentDescriptions = map;
    }

    @JvmStatic
    @NotNull
    public static final BadgeDrawable showBadgeIn(@NotNull View anchor, @NotNull FrameLayout parent, @Nullable String badgeDescription) {
        BadgeDrawable badgeDrawable;
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        BadgeDrawable $this$showBadgeIn_u24lambda_u240 = badgeDrawable = INSTANCE.createBadge(anchor, 0);
        boolean bl = false;
        INSTANCE.addToView($this$showBadgeIn_u24lambda_u240, anchor, parent, INSTANCE.buildBadgeContentDescription(anchor, badgeDescription));
        return badgeDrawable;
    }

    public static /* synthetic */ BadgeDrawable showBadgeIn$default(View view, FrameLayout frameLayout, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return Badge.showBadgeIn(view, frameLayout, string);
    }

    @JvmStatic
    @NotNull
    public static final BadgeDrawable showNumericBadgeIn(@NotNull View anchor, @NotNull FrameLayout parent, int count, @Nullable String badgeDescription) {
        BadgeDrawable badgeDrawable;
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        BadgeDrawable $this$showNumericBadgeIn_u24lambda_u241 = badgeDrawable = INSTANCE.createBadge(anchor, count);
        boolean bl = false;
        if (count == 0) {
            Badge.removeBadge(anchor);
        } else {
            INSTANCE.addToView($this$showNumericBadgeIn_u24lambda_u241, anchor, parent, INSTANCE.buildBadgeContentDescription(anchor, badgeDescription));
        }
        return badgeDrawable;
    }

    public static /* synthetic */ BadgeDrawable showNumericBadgeIn$default(View view, FrameLayout frameLayout, int n, String string, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string = null;
        }
        return Badge.showNumericBadgeIn(view, frameLayout, n, string);
    }

    @JvmStatic
    public static final void removeBadge(@NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        ViewParent parent = anchor.getParent();
        if (!(parent instanceof ViewGroup)) {
            throw new RuntimeException("The view's parent is not a ViewGroup. Use removeBadge(badge,parent) instead");
        }
        Badge.removeBadgeWithParent((ViewGroup)parent, anchor);
    }

    @JvmStatic
    public static final void removeBadgeWithParent(@NotNull ViewGroup parent, @NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        parent.post(() -> Badge.removeBadgeWithParent$lambda$2(anchor, parent));
    }

    private final BadgeDrawable createBadge(View anchor, int count) {
        BadgeDrawable badgeDrawable;
        BadgeDrawable $this$createBadge_u24lambda_u243 = badgeDrawable = BadgeDrawable.create((Context)anchor.getContext());
        boolean bl = false;
        $this$createBadge_u24lambda_u243.setMaxCharacterCount(2);
        Context context = anchor.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        $this$createBadge_u24lambda_u243.setBackgroundColor(ColorUtilsKt.getThemeColor(context, R.attr.colorBadge));
        Context context2 = anchor.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        $this$createBadge_u24lambda_u243.setBadgeTextColor(ColorUtilsKt.getThemeColor(context2, R.attr.colorTextPrimaryInverse));
        Intrinsics.checkNotNull((Object)$this$createBadge_u24lambda_u243);
        INSTANCE.setupCount($this$createBadge_u24lambda_u243, count);
        BadgeDrawable badgeDrawable2 = badgeDrawable;
        Intrinsics.checkNotNullExpressionValue((Object)badgeDrawable2, (String)"apply(...)");
        return badgeDrawable2;
    }

    private final String buildBadgeContentDescription(View anchor, String badgeDescription) {
        CharSequence charSequence;
        if (!contentDescriptions.containsKey(anchor.hashCode())) {
            contentDescriptions.put(anchor.hashCode(), anchor.getContentDescription());
        }
        String suffix = badgeDescription;
        return contentDescriptions.get(anchor.hashCode()) == null ? suffix : ((charSequence = (CharSequence)suffix) == null || charSequence.length() == 0 ? String.valueOf(contentDescriptions.get(anchor.hashCode())) : contentDescriptions.get(anchor.hashCode()) + ", " + suffix);
    }

    private final void resetContentDescription(View anchor) {
        if (contentDescriptions.containsKey(anchor.hashCode())) {
            anchor.setContentDescription(contentDescriptions.get(anchor.hashCode()));
        }
    }

    private final void setupCount(BadgeDrawable $this$setupCount, int count) {
        $this$setupCount.setMaxCharacterCount(2);
        if (count == 0) {
            $this$setupCount.clearNumber();
        } else if (String.valueOf(count).length() < $this$setupCount.getMaxCharacterCount()) {
            $this$setupCount.setNumber(count);
        } else {
            $this$setupCount.setText("+9");
        }
    }

    private final void addToView(BadgeDrawable $this$addToView, View anchor, FrameLayout parent, CharSequence contentDescription) {
        parent.post(() -> Badge.addToView$lambda$4($this$addToView, anchor, parent, contentDescription));
    }

    private final void setBoundsFor(BadgeDrawable $this$setBoundsFor, View anchor, FrameLayout parent) {
        Rect rect = new Rect();
        parent.getDrawingRect(rect);
        $this$setBoundsFor.setBounds(rect);
        $this$setBoundsFor.updateBadgeCoordinates(anchor, parent);
    }

    private static final void removeBadgeWithParent$lambda$2(View $anchor, ViewGroup $parent) {
        INSTANCE.resetContentDescription($anchor);
        $parent.getOverlay().clear();
    }

    private static final void addToView$lambda$4(BadgeDrawable $this_addToView, View $anchor, FrameLayout $parent, CharSequence $contentDescription) {
        INSTANCE.setBoundsFor($this_addToView, $anchor, $parent);
        ViewGroupOverlay overlay = $parent.getOverlay();
        overlay.clear();
        overlay.add((Drawable)$this_addToView);
        $anchor.setContentDescription($contentDescription);
    }
}

