/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.link;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.method.LinkMovementMethod;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import com.telefonica.mistica.R;
import com.telefonica.mistica.link.MultiLink;
import com.telefonica.mistica.link.SingleLink;
import com.telefonica.mistica.link.TextLinkViewUtilsKt;
import com.telefonica.mistica.util.ColorUtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BindingMethods(value={@BindingMethod(type=TextLink.class, attribute="linkColor", method="setLinkColor")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u0019\u001a\u00020\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u001aJ\u001c\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u001aJ\u0010\u0010\u001b\u001a\u00020\u000f2\b\b\u0001\u0010\n\u001a\u00020\u0007J\b\u0010\u001c\u001a\u00020\u000fH\u0002J\u0014\u0010\u001d\u001a\u00020\r*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0012\u0010\n\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/telefonica/mistica/link/TextLink;", "Landroidx/appcompat/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "linkColor", "links", "", "Lcom/telefonica/mistica/link/MultiLink;", "setText", "", "text", "", "type", "Landroid/widget/TextView$BufferType;", "setSingleTextLink", "singleLink", "Lcom/telefonica/mistica/link/SingleLink;", "originalText", "", "setMultiLinkText", "", "setLinkColor", "updateView", "toMultiLink", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
public final class TextLink
extends AppCompatTextView {
    @ColorInt
    private int linkColor;
    @Nullable
    private final List<MultiLink> links;
    public static final int $stable = 8;

    @JvmOverloads
    public TextLink(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.linkColor = ColorUtilsKt.getThemeColor(context, R.attr.colorTextLink);
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.setHighlightColor(0);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TextLinkView, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
            TypedArray styledAttrs = typedArray;
            this.setLinkColor(styledAttrs.getColor(R.styleable.TextLinkView_linkColor, ColorUtilsKt.getThemeColor(context, R.attr.colorTextLink)));
        }
    }

    public /* synthetic */ TextLink(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public void setText(@Nullable CharSequence text, @Nullable TextView.BufferType type) {
        super.setText(text, type);
        this.updateView();
    }

    public final void setSingleTextLink(@NotNull SingleLink singleLink) {
        Intrinsics.checkNotNullParameter((Object)singleLink, (String)"singleLink");
        this.setSingleTextLink(((Object)this.getText()).toString(), singleLink);
    }

    public final void setSingleTextLink(@NotNull String originalText, @NotNull SingleLink singleLink) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        Intrinsics.checkNotNullParameter((Object)singleLink, (String)"singleLink");
        this.setText((CharSequence)TextLinkViewUtilsKt.getSpannableLinkText(originalText, CollectionsKt.listOf((Object)this.toMultiLink(singleLink, originalText)), this.linkColor));
    }

    public final void setMultiLinkText(@NotNull List<? extends MultiLink> links) {
        Intrinsics.checkNotNullParameter(links, (String)"links");
        this.setMultiLinkText(((Object)this.getText()).toString(), links);
    }

    public final void setMultiLinkText(@NotNull String originalText, @NotNull List<? extends MultiLink> links) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        Intrinsics.checkNotNullParameter(links, (String)"links");
        this.setText((CharSequence)TextLinkViewUtilsKt.getSpannableLinkText(originalText, links, this.linkColor));
    }

    public final void setLinkColor(@ColorInt int linkColor) {
        if (this.linkColor != linkColor) {
            this.linkColor = linkColor;
            this.updateView();
        }
    }

    private final void updateView() {
        Collection collection = this.links;
        if (!(collection == null || collection.isEmpty())) {
            this.setMultiLinkText(((Object)this.getText()).toString(), this.links);
        }
    }

    private final MultiLink toMultiLink(SingleLink $this$toMultiLink, String originalText) {
        MultiLink multiLink;
        SingleLink singleLink = $this$toMultiLink;
        if (singleLink instanceof SingleLink.DefaultSingleLink) {
            multiLink = new MultiLink.DefaultMultiLink(originalText, ((SingleLink.DefaultSingleLink)$this$toMultiLink).getOnLinkTapped());
        } else if (singleLink instanceof SingleLink.CustomSingleLink) {
            multiLink = new MultiLink.CustomMultiLink(originalText, ((SingleLink.CustomSingleLink)$this$toMultiLink).getCustomSpan());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return multiLink;
    }

    @JvmOverloads
    public TextLink(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TextLink(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

