/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.stepper;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.provider.Settings;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.ScaleAnimation;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import com.airbnb.lottie.LottieAnimationView;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.RenderMode;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.value.LottieFrameInfo;
import com.airbnb.lottie.value.ScaleXY;
import com.telefonica.mistica.R;
import com.telefonica.mistica.util.ColorUtilsKt;
import com.telefonica.mistica.util.ResUtilsKt;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 12\u00020\u0001:\u000201B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u001a\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00072\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007J\u0006\u0010\u001b\u001a\u00020\u0015J\u0006\u0010\u001c\u001a\u00020\u0015J\u0006\u0010\u001d\u001a\u00020\u0015J\u001a\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010 H\u0002J\u0016\u0010\u001f\u001a\u00020\u0015*\u00020 2\b\b\u0002\u0010\"\u001a\u00020\u001aH\u0002J \u0010!\u001a\u00020\u0015*\u00020 2\b\b\u0002\u0010\"\u001a\u00020\u001a2\b\b\u0002\u0010#\u001a\u00020\u001aH\u0002J1\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\b\u0010)\u001a\u0004\u0018\u00010'2\b\u0010*\u001a\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0002\u0010+J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020'H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/telefonica/mistica/stepper/StepView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "selectedStepTextView", "Landroid/widget/TextView;", "selectedStepContainer", "Landroid/widget/RelativeLayout;", "unselectedStepTextView", "unselectedStepContainer", "checkIcon", "Lcom/airbnb/lottie/LottieAnimationView;", "stepStatus", "Lcom/telefonica/mistica/stepper/StepView$State;", "scaleLayoutAccordingTextSize", "", "setUpLottieAnimation", "setStep", "step", "isSelected", "", "setUnselected", "setSelected", "setCompleted", "animateSelection", "fadeIn", "Landroid/view/View;", "fadeOut", "withScale", "hideOnAnimationEnd", "animationSet", "Landroid/view/animation/AnimationSet;", "fromAlpha", "", "toAlpha", "fromScale", "toScale", "(FFLjava/lang/Float;Ljava/lang/Float;)Landroid/view/animation/AnimationSet;", "scaleAnimation", "Landroid/view/animation/ScaleAnimation;", "from", "to", "State", "Companion", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
public final class StepView
extends FrameLayout {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final TextView selectedStepTextView;
    @NotNull
    private final RelativeLayout selectedStepContainer;
    @NotNull
    private final TextView unselectedStepTextView;
    @NotNull
    private final RelativeLayout unselectedStepContainer;
    @NotNull
    private final LottieAnimationView checkIcon;
    @NotNull
    private State stepStatus;
    public static final int $stable = 8;
    @Deprecated
    public static final long ANIMATION_DURATION = 300L;
    @Deprecated
    public static final float ANIMATION_SCALE = 0.98f;

    @JvmOverloads
    public StepView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.stepStatus = State.UNSELECTED;
        LayoutInflater.from((Context)context).inflate(R.layout.step_view, (ViewGroup)this, true);
        this.selectedStepTextView = (TextView)this.findViewById(R.id.selected_step_number);
        this.selectedStepContainer = (RelativeLayout)this.findViewById(R.id.selected_step_container);
        this.unselectedStepTextView = (TextView)this.findViewById(R.id.unselected_step_number);
        this.unselectedStepContainer = (RelativeLayout)this.findViewById(R.id.unselected_step_container);
        this.checkIcon = (LottieAnimationView)this.findViewById(R.id.check_icon);
        this.scaleLayoutAccordingTextSize();
        this.setUpLottieAnimation();
    }

    public /* synthetic */ StepView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final void scaleLayoutAccordingTextSize() {
        float fontScale = Settings.System.getFloat((ContentResolver)this.getContext().getContentResolver(), (String)"font_scale", (float)1.0f);
        int stepWidth = (int)(this.getResources().getDimension(R.dimen.stepper_step_width) * fontScale);
        this.selectedStepContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(stepWidth, stepWidth));
        this.unselectedStepContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(stepWidth, stepWidth));
        this.checkIcon.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(stepWidth, stepWidth));
    }

    private final void setUpLottieAnimation() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Integer n = ResUtilsKt.getThemeRes(context, R.attr.stepperFinishedStepAnimation, false);
        if (n == null) {
            return;
        }
        int animationResource = n;
        String[] stringArray = new String[]{"**"};
        KeyPath keyPath = new KeyPath(stringArray);
        LottieAnimationView $this$setUpLottieAnimation_u24lambda_u243 = this.checkIcon;
        boolean bl = false;
        $this$setUpLottieAnimation_u24lambda_u243.setAnimation(animationResource);
        $this$setUpLottieAnimation_u24lambda_u243.setRenderMode(RenderMode.SOFTWARE);
        $this$setUpLottieAnimation_u24lambda_u243.addValueCallback(keyPath, (Object)LottieProperty.COLOR_FILTER, arg_0 -> StepView.setUpLottieAnimation$lambda$3$lambda$0($this$setUpLottieAnimation_u24lambda_u243, arg_0));
        $this$setUpLottieAnimation_u24lambda_u243.addValueCallback(keyPath, (Object)LottieProperty.STROKE_WIDTH, arg_0 -> StepView.setUpLottieAnimation$lambda$3$lambda$1($this$setUpLottieAnimation_u24lambda_u243, arg_0));
        $this$setUpLottieAnimation_u24lambda_u243.addValueCallback(keyPath, (Object)LottieProperty.TRANSFORM_SCALE, StepView::setUpLottieAnimation$lambda$3$lambda$2);
    }

    @SuppressLint(value={"SetTextI18n"})
    public final void setStep(int step, boolean isSelected) {
        this.selectedStepTextView.setText((CharSequence)String.valueOf(step));
        this.unselectedStepTextView.setText((CharSequence)String.valueOf(step));
        if (isSelected) {
            this.stepStatus = State.SELECTED;
            this.unselectedStepContainer.setVisibility(4);
            this.selectedStepContainer.setVisibility(0);
        }
    }

    public static /* synthetic */ void setStep$default(StepView stepView, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        stepView.setStep(n, bl);
    }

    public final void setUnselected() {
        this.animateSelection((View)this.unselectedStepContainer, (View)this.selectedStepContainer);
        this.stepStatus = State.UNSELECTED;
    }

    public final void setSelected() {
        this.animateSelection((View)this.selectedStepContainer, (View)(this.stepStatus == State.UNSELECTED ? this.unselectedStepContainer : null));
        this.stepStatus = State.SELECTED;
    }

    public final void setCompleted() {
        RelativeLayout containerToHide = this.stepStatus == State.SELECTED ? this.selectedStepContainer : this.unselectedStepContainer;
        StepView.fadeOut$default(this, (View)containerToHide, true, false, 2, null);
        this.checkIcon.setVisibility(0);
        this.checkIcon.playAnimation();
        this.stepStatus = State.COMPLETED;
    }

    private final void animateSelection(View fadeIn, View fadeOut2) {
        block1: {
            if (this.stepStatus == State.COMPLETED) {
                StepView.fadeOut$default(this, (View)this.checkIcon, false, false, 1, null);
            }
            this.checkIcon.setVisibility(4);
            this.fadeIn(fadeIn, this.stepStatus == State.COMPLETED);
            View view = fadeOut2;
            if (view == null) break block1;
            StepView.fadeOut$default(this, view, false, false, 3, null);
        }
    }

    private final void fadeIn(View $this$fadeIn, boolean withScale) {
        $this$fadeIn.setVisibility(0);
        AnimationSet animationSet = withScale ? this.animationSet(0.0f, 1.0f, Float.valueOf(0.0f), Float.valueOf(1.0f)) : this.animationSet(0.0f, 1.0f, null, null);
        $this$fadeIn.startAnimation((Animation)animationSet);
    }

    static /* synthetic */ void fadeIn$default(StepView stepView, View view, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        stepView.fadeIn(view, bl);
    }

    private final void fadeOut(View $this$fadeOut, boolean withScale, boolean hideOnAnimationEnd) {
        AnimationSet animationSet;
        AnimationSet animationSet2 = animationSet = withScale ? this.animationSet(1.0f, 0.0f, Float.valueOf(1.0f), Float.valueOf(0.0f)) : this.animationSet(1.0f, 0.0f, null, null);
        if (hideOnAnimationEnd) {
            animationSet.setAnimationListener(new Animation.AnimationListener(animationSet, $this$fadeOut){
                final /* synthetic */ AnimationSet $animationSet;
                final /* synthetic */ View $this_fadeOut;
                {
                    this.$animationSet = $animationSet;
                    this.$this_fadeOut = $receiver;
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    this.$animationSet.setAnimationListener(null);
                    this.$this_fadeOut.setVisibility(4);
                    this.$this_fadeOut.setScaleX(1.0f);
                    this.$this_fadeOut.setScaleY(1.0f);
                }
            });
        }
        $this$fadeOut.startAnimation((Animation)animationSet);
    }

    static /* synthetic */ void fadeOut$default(StepView stepView, View view, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        stepView.fadeOut(view, bl, bl2);
    }

    private final AnimationSet animationSet(float fromAlpha, float toAlpha, Float fromScale, Float toScale) {
        AnimationSet animationSet = new AnimationSet(true);
        animationSet.setRepeatCount(1);
        animationSet.setDuration(300L);
        animationSet.addAnimation((Animation)new AlphaAnimation(fromAlpha, toAlpha));
        if (fromScale != null && toScale != null) {
            animationSet.addAnimation((Animation)this.scaleAnimation(fromScale.floatValue(), toScale.floatValue()));
        }
        return animationSet;
    }

    private final ScaleAnimation scaleAnimation(float from, float to) {
        return new ScaleAnimation(from, to, from, to, 1, 0.5f, 1, 0.5f);
    }

    @JvmOverloads
    public StepView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public StepView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final ColorFilter setUpLottieAnimation$lambda$3$lambda$0(LottieAnimationView $this_with, LottieFrameInfo it) {
        Context context = $this_with.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return (ColorFilter)new PorterDuffColorFilter(ColorUtilsKt.getThemeColor(context, R.attr.colorControlActive), PorterDuff.Mode.SRC_ATOP);
    }

    private static final Float setUpLottieAnimation$lambda$3$lambda$1(LottieAnimationView $this_with, LottieFrameInfo it) {
        return Float.valueOf($this_with.getResources().getDimension(R.dimen.step_completed_icon_width));
    }

    private static final ScaleXY setUpLottieAnimation$lambda$3$lambda$2(LottieFrameInfo it) {
        return new ScaleXY(0.98f, 0.98f);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/telefonica/mistica/stepper/StepView$Companion;", "", "<init>", "()V", "ANIMATION_DURATION", "", "ANIMATION_SCALE", "", "com.telefonica.mistica_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/telefonica/mistica/stepper/StepView$State;", "", "<init>", "(Ljava/lang/String;I)V", "SELECTED", "UNSELECTED", "COMPLETED", "com.telefonica.mistica_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State SELECTED = new State();
        public static final /* enum */ State UNSELECTED = new State();
        public static final /* enum */ State COMPLETED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.SELECTED, State.UNSELECTED, State.COMPLETED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

