/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.card;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.res.ResourcesCompat;
import androidx.databinding.BindingMethod;
import androidx.databinding.BindingMethods;
import com.telefonica.mistica.R;
import com.telefonica.mistica.card.CardActionsView;
import com.telefonica.mistica.card.CardContentView;
import com.telefonica.mistica.tag.TagView;
import com.telefonica.mistica.util.DimensionUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BindingMethods(value={@BindingMethod(type=androidx.cardview.widget.CardView.class, attribute="cardTag", method="setTag"), @BindingMethod(type=androidx.cardview.widget.CardView.class, attribute="cardTagColor", method="setTagColor"), @BindingMethod(type=androidx.cardview.widget.CardView.class, attribute="cardTitle", method="setTitle"), @BindingMethod(type=androidx.cardview.widget.CardView.class, attribute="cardTitleMaxLines", method="setTitleMaxLines"), @BindingMethod(type=androidx.cardview.widget.CardView.class, attribute="cardDescription", method="setDescription"), @BindingMethod(type=androidx.cardview.widget.CardView.class, attribute="cardDescriptionMaxLines", method="setDescriptionMaxLines"), @BindingMethod(type=androidx.cardview.widget.CardView.class, attribute="cardPrimaryButtonText", method="setPrimaryButtonText"), @BindingMethod(type=androidx.cardview.widget.CardView.class, attribute="cardLinkButtonText", method="setLinkButtonText"), @BindingMethod(type=androidx.cardview.widget.CardView.class, attribute="cardPrimaryButtonOnClick", method="setPrimaryButtonOnClick"), @BindingMethod(type=androidx.cardview.widget.CardView.class, attribute="cardLinkButtonOnClick", method="setLinkButtonOnClick")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u0007H$J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0017\u0010\u0013\u001a\u00020\u00142\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0007J\u0010\u0010\u001b\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0007J\u0017\u0010\u001b\u001a\u00020\u00142\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u001e\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0007J\u0017\u0010\u001e\u001a\u00020\u00142\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010 \u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0017\u0010 \u001a\u00020\u00142\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010!\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0017\u0010!\u001a\u00020\u00142\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\"\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010$J\u0010\u0010%\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010$J\u0010\u0010&\u001a\u00020\u00142\b\u0010'\u001a\u0004\u0018\u00010\u0011J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*H\u0004J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020*H\u0004J\u0016\u0010-\u001a\u00020\u0014*\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u0016H\u0004J\b\u00100\u001a\u000201H\u0002J\u0014\u00102\u001a\u00020\u0014*\u00020\u00012\u0006\u00103\u001a\u000201H\u0002J\b\u00104\u001a\u00020\u0014H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/telefonica/mistica/card/CardView;", "Landroidx/cardview/widget/CardView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cardContentView", "Lcom/telefonica/mistica/card/CardContentView;", "cardCustomContentLayout", "Landroid/widget/LinearLayout;", "cardActionsView", "Lcom/telefonica/mistica/card/CardActionsView;", "handleAttrsAndInflateLayout", "Landroid/view/View;", "defStyleRes", "setTag", "", "text", "", "textRes", "(Ljava/lang/Integer;)V", "setTagStyle", "style", "setTitle", "setTitleMaxLines", "maxLines", "setDescription", "setDescriptionMaxLines", "setPrimaryButtonText", "setLinkButtonText", "setPrimaryButtonOnClick", "onClickListener", "Landroid/view/View$OnClickListener;", "setLinkButtonOnClick", "setCardAdditionalContent", "content", "setPretitle", "pretitle", "", "setSubtitle", "subtitle", "setTextAndVisibility", "Landroid/widget/TextView;", "newText", "shouldShowRippleOnClick", "", "setCardRipple", "showRippleOnClick", "updateButtonsContainerVisibility", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCardView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardView.kt\ncom/telefonica/mistica/card/CardView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
public abstract class CardView
extends androidx.cardview.widget.CardView {
    @NotNull
    private final CardContentView cardContentView;
    @NotNull
    private final LinearLayout cardCustomContentLayout;
    @NotNull
    private final CardActionsView cardActionsView;
    public static final int $stable = 8;

    @JvmOverloads
    public CardView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        View rootView = this.handleAttrsAndInflateLayout(attrs, defStyleAttr, defStyleAttr);
        this.setClickable(true);
        this.setFocusable(true);
        this.setCardElevation(0.0f);
        this.setRadius(DimensionUtilsKt.getDimension(context, R.attr.containerBorderRadius));
        this.setMinimumWidth((int)this.getResources().getDimension(R.dimen.card_min_width));
        this.setBackground(AppCompatResources.getDrawable((Context)context, (int)R.drawable.card_view_background));
        this.cardContentView = (CardContentView)rootView.findViewById(R.id.card_content);
        this.cardCustomContentLayout = (LinearLayout)rootView.findViewById(R.id.card_custom_content_layout);
        this.cardActionsView = (CardActionsView)rootView.findViewById(R.id.card_actions);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CardView, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
            TypedArray styledAttrs = typedArray;
            this.setTag(styledAttrs.getText(R.styleable.CardView_cardTag));
            this.setTagStyle(styledAttrs.getInt(R.styleable.CardView_tagStyle, 0));
            this.setTitle(styledAttrs.getText(R.styleable.CardView_cardTitle));
            this.setTitleMaxLines(styledAttrs.getInteger(R.styleable.CardView_cardTitleMaxLines, -1));
            this.setDescription(styledAttrs.getText(R.styleable.CardView_cardDescription));
            this.setDescriptionMaxLines(styledAttrs.getInteger(R.styleable.CardView_cardDescriptionMaxLines, -1));
            this.setPrimaryButtonText(styledAttrs.getText(R.styleable.CardView_cardPrimaryButtonText));
            this.setLinkButtonText(styledAttrs.getText(R.styleable.CardView_cardLinkButtonText));
            styledAttrs.recycle();
        }
        this.setCardRipple(this, this.shouldShowRippleOnClick());
    }

    public /* synthetic */ CardView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    protected abstract View handleAttrsAndInflateLayout(@Nullable AttributeSet var1, int var2, int var3);

    public static /* synthetic */ View handleAttrsAndInflateLayout$default(CardView cardView, AttributeSet attributeSet, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleAttrsAndInflateLayout");
        }
        if ((n3 & 1) != 0) {
            attributeSet = null;
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return cardView.handleAttrsAndInflateLayout(attributeSet, n, n2);
    }

    public final void setTag(@Nullable CharSequence text) {
        this.setTextAndVisibility((TextView)this.cardContentView.getTagTextView(), text);
    }

    public final void setTag(@StringRes @Nullable Integer textRes) {
        block0: {
            Integer n = textRes;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.setTag(this.getContext().getString(it));
        }
    }

    public final void setTagStyle(int style2) {
        TagView.setTagStyle$default(this.cardContentView.getTagTextView(), style2, null, null, 6, null);
    }

    public final void setTitle(@Nullable CharSequence text) {
        this.setTextAndVisibility(this.cardContentView.getTitleTextView(), text);
    }

    public final void setTitleMaxLines(int maxLines) {
        if (maxLines > 0) {
            this.cardContentView.getTitleTextView().setMaxLines(maxLines);
            this.cardContentView.getTitleTextView().setEllipsize(TextUtils.TruncateAt.END);
        }
    }

    public final void setTitle(@StringRes @Nullable Integer textRes) {
        block0: {
            Integer n = textRes;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.setTitle(this.getContext().getString(it));
        }
    }

    public final void setDescription(@Nullable CharSequence text) {
        this.setTextAndVisibility(this.cardContentView.getDescriptionTextView(), text);
    }

    public final void setDescriptionMaxLines(int maxLines) {
        if (maxLines > 0) {
            this.cardContentView.getDescriptionTextView().setMaxLines(maxLines);
            this.cardContentView.getDescriptionTextView().setEllipsize(TextUtils.TruncateAt.END);
        }
    }

    public final void setDescription(@StringRes @Nullable Integer textRes) {
        block0: {
            Integer n = textRes;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.setDescription(this.getContext().getString(it));
        }
    }

    public final void setPrimaryButtonText(@Nullable CharSequence text) {
        this.setTextAndVisibility((TextView)this.cardActionsView.getPrimaryButton(), text);
        this.updateButtonsContainerVisibility();
    }

    public final void setPrimaryButtonText(@StringRes @Nullable Integer textRes) {
        block0: {
            Integer n = textRes;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.setPrimaryButtonText(this.getContext().getString(it));
        }
    }

    public final void setLinkButtonText(@Nullable CharSequence text) {
        this.setTextAndVisibility((TextView)this.cardActionsView.getLinkButton(), text);
        this.updateButtonsContainerVisibility();
    }

    public final void setLinkButtonText(@StringRes @Nullable Integer textRes) {
        block0: {
            Integer n = textRes;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.setLinkButtonText(this.getContext().getString(it));
        }
    }

    public final void setPrimaryButtonOnClick(@Nullable View.OnClickListener onClickListener) {
        this.cardActionsView.getPrimaryButton().setOnClickListener(onClickListener);
        this.setCardRipple(this, this.shouldShowRippleOnClick());
    }

    public final void setLinkButtonOnClick(@Nullable View.OnClickListener onClickListener) {
        this.cardActionsView.getLinkButton().setOnClickListener(onClickListener);
        this.setCardRipple(this, this.shouldShowRippleOnClick());
    }

    public final void setCardAdditionalContent(@Nullable View content) {
        this.cardCustomContentLayout.removeAllViews();
        if (content != null) {
            this.cardCustomContentLayout.addView(content);
        }
    }

    protected final void setPretitle(@NotNull String pretitle) {
        Intrinsics.checkNotNullParameter((Object)pretitle, (String)"pretitle");
        this.setTextAndVisibility(this.cardContentView.getPretitleTextView(), pretitle);
    }

    protected final void setSubtitle(@NotNull String subtitle) {
        Intrinsics.checkNotNullParameter((Object)subtitle, (String)"subtitle");
        this.setTextAndVisibility(this.cardContentView.getSubtitleTextView(), subtitle);
    }

    protected final void setTextAndVisibility(@NotNull TextView $this$setTextAndVisibility, @Nullable CharSequence newText) {
        Intrinsics.checkNotNullParameter((Object)$this$setTextAndVisibility, (String)"<this>");
        CharSequence charSequence = newText;
        boolean bl = charSequence != null ? !StringsKt.isBlank((CharSequence)charSequence) : false;
        if (bl) {
            $this$setTextAndVisibility.setText(newText);
            $this$setTextAndVisibility.setVisibility(0);
        } else {
            $this$setTextAndVisibility.setVisibility(8);
        }
    }

    private final boolean shouldShowRippleOnClick() {
        return this.cardActionsView.cardHasNoActions();
    }

    private final void setCardRipple(androidx.cardview.widget.CardView $this$setCardRipple, boolean showRippleOnClick) {
        Drawable drawable2;
        if (showRippleOnClick) {
            TypedValue outValue = new TypedValue();
            $this$setCardRipple.getContext().getTheme().resolveAttribute(16843534, outValue, true);
            drawable2 = ResourcesCompat.getDrawable((Resources)$this$setCardRipple.getResources(), (int)outValue.resourceId, (Resources.Theme)$this$setCardRipple.getContext().getTheme());
        } else {
            drawable2 = null;
        }
        $this$setCardRipple.setForeground(drawable2);
    }

    private final void updateButtonsContainerVisibility() {
        this.cardActionsView.setVisibility(this.cardActionsView.cardHasNoActions() ? 8 : 0);
    }

    @JvmOverloads
    public CardView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

