/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.mistica.feedback;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.StringRes;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.android.material.snackbar.BaseTransientBottomBar;
import com.google.android.material.snackbar.Snackbar;
import com.telefonica.mistica.R;
import com.telefonica.mistica.feedback.SnackBarBehaviorConfig;
import com.telefonica.mistica.feedback.SnackbarLength;
import com.telefonica.mistica.feedback.snackbar.CustomSnackbarLayout;
import com.telefonica.mistica.util.ColorUtilsKt;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ&\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u0011H\u0016J-\u0010\u001c\u001a\u00020\u00002\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0003\u0010\u001d\u001a\u0004\u0018\u00010\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0000H\u0016J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020\u0000H\u0016J\u0012\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020&H\u0017J\u0012\u0010'\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020&H\u0017J\u001a\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020$2\b\b\u0001\u0010+\u001a\u00020\tH\u0002J\u001a\u0010,\u001a\u00020)2\u0006\u0010*\u001a\u00020$2\b\b\u0001\u0010+\u001a\u00020\tH\u0002J\u0018\u0010-\u001a\u00020)2\u0006\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010.\u001a\u00020)2\u0006\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010/\u001a\u00020)2\u0006\u0010*\u001a\u00020$H\u0002J\u0012\u00100\u001a\u0002012\b\b\u0001\u0010+\u001a\u00020\tH\u0002J\u0018\u00102\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020\r2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020&H\u0002J\u0010\u00105\u001a\u00020\u00152\u0006\u00104\u001a\u00020&H\u0002J\u0010\u00106\u001a\u00020$2\u0006\u00107\u001a\u00020\tH\u0003J\f\u00108\u001a\u00020)*\u00020$H\u0002J\f\u00109\u001a\u00020)*\u00020$H\u0002J\f\u0010:\u001a\u00020;*\u00020$H\u0002J\u0014\u0010<\u001a\u00020)*\u00020$2\u0006\u0010=\u001a\u00020\u0015H\u0002J\f\u0010>\u001a\u00020)*\u00020$H\u0002J\u0014\u0010?\u001a\u00020)*\u00020$2\u0006\u0010\u0004\u001a\u00020\rH\u0002R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006@"}, d2={"Lcom/telefonica/mistica/feedback/SnackbarBuilder;", "", "view", "Landroid/view/View;", "text", "", "<init>", "(Landroid/view/View;Ljava/lang/String;)V", "resId", "", "(Landroid/view/View;I)V", "focusViewAfterDismiss", "Ljava/lang/ref/WeakReference;", "", "actionText", "actionContentDescription", "actionListener", "Landroid/view/View$OnClickListener;", "callback", "Lcom/google/android/material/snackbar/Snackbar$Callback;", "withDismiss", "", "forceRequestFocus", "accessibilityManager", "Landroid/view/accessibility/AccessibilityManager;", "hasAction", "getHasAction", "()Z", "withAction", "contentDescription", "listener", "(ILjava/lang/Integer;Landroid/view/View$OnClickListener;)Lcom/telefonica/mistica/feedback/SnackbarBuilder;", "withCallback", "setFocusViewAfterDismiss", "setForceRequestFocus", "showInformative", "Lcom/google/android/material/snackbar/Snackbar;", "snackbarLength", "Lcom/telefonica/mistica/feedback/SnackbarLength;", "showCritical", "setActionTextColor", "", "snackbar", "colorRes", "setBackgroundColor", "muteSnackbarAndForceRequestFocus", "returnFocusToViewIfNeeded", "interruptPreviousAccessibilityAnnouncement", "getSpannable", "Landroid/text/Spannable;", "createSnackbar", "isInvalidLengthWhenThereIsAction", "length", "isInvalidLengthWhenThereIsNoAction", "inflateCustomSnackbar", "duration", "setCustomAction", "dispatchDismissedByActionEvent", "getCustomLayout", "Lcom/telefonica/mistica/feedback/snackbar/CustomSnackbarLayout;", "showDismissActionIfNeeded", "hasInfiniteDuration", "addCallbackIfNeeded", "setContentDescription", "com.telefonica.mistica_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSnackbarBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnackbarBuilder.kt\ncom/telefonica/mistica/feedback/SnackbarBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1#2:262\n*E\n"})
public class SnackbarBuilder {
    @Nullable
    private WeakReference<View> focusViewAfterDismiss;
    @NotNull
    private final View view;
    @NotNull
    private final CharSequence text;
    @Nullable
    private String actionText;
    @Nullable
    private String actionContentDescription;
    @Nullable
    private View.OnClickListener actionListener;
    @Nullable
    private Snackbar.Callback callback;
    private boolean withDismiss;
    private boolean forceRequestFocus;
    @NotNull
    private final AccessibilityManager accessibilityManager;
    public static final int $stable = 8;

    public SnackbarBuilder(@Nullable View view, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (view == null) {
            boolean bl = false;
            String string2 = "View cannot be null";
            throw new IllegalArgumentException(string2.toString());
        }
        this.text = text;
        this.view = view;
        Object object = view.getContext().getSystemService("accessibility");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.accessibility.AccessibilityManager");
        this.accessibilityManager = (AccessibilityManager)object;
    }

    private final boolean getHasAction() {
        return this.actionText != null;
    }

    public SnackbarBuilder(@NotNull View view, @StringRes int resId) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        String string2 = view.getResources().getString(resId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        this(view, string2);
    }

    @NotNull
    public SnackbarBuilder withAction(@NotNull String text, @Nullable String contentDescription, @Nullable View.OnClickListener listener2) {
        SnackbarBuilder snackbarBuilder;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SnackbarBuilder $this$withAction_u24lambda_u240 = snackbarBuilder = this;
        boolean bl = false;
        $this$withAction_u24lambda_u240.actionText = text;
        $this$withAction_u24lambda_u240.actionListener = listener2;
        $this$withAction_u24lambda_u240.actionContentDescription = contentDescription;
        return snackbarBuilder;
    }

    public static /* synthetic */ SnackbarBuilder withAction$default(SnackbarBuilder snackbarBuilder, String string2, String string3, View.OnClickListener onClickListener, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withAction");
        }
        if ((n & 2) != 0) {
            string3 = null;
        }
        return snackbarBuilder.withAction(string2, string3, onClickListener);
    }

    @NotNull
    public SnackbarBuilder withAction(@StringRes int resId, @StringRes @Nullable Integer contentDescription, @Nullable View.OnClickListener listener2) {
        String string2;
        SnackbarBuilder snackbarBuilder = this;
        String string3 = this.view.getResources().getString(resId);
        String string4 = string3;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        Integer n = contentDescription;
        if (n != null) {
            int n2 = ((Number)n).intValue();
            String string5 = string4;
            SnackbarBuilder snackbarBuilder2 = snackbarBuilder;
            boolean bl = false;
            String string6 = this.view.getResources().getString(contentDescription.intValue());
            snackbarBuilder = snackbarBuilder2;
            string4 = string5;
            string2 = string6;
        } else {
            string2 = null;
        }
        return snackbarBuilder.withAction(string4, string2, listener2);
    }

    public static /* synthetic */ SnackbarBuilder withAction$default(SnackbarBuilder snackbarBuilder, int n, Integer n2, View.OnClickListener onClickListener, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withAction");
        }
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        return snackbarBuilder.withAction(n, n2, onClickListener);
    }

    @NotNull
    public SnackbarBuilder withCallback(@NotNull Snackbar.Callback callback) {
        SnackbarBuilder snackbarBuilder;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        SnackbarBuilder $this$withCallback_u24lambda_u240 = snackbarBuilder = this;
        boolean bl = false;
        $this$withCallback_u24lambda_u240.callback = callback;
        return snackbarBuilder;
    }

    @NotNull
    public SnackbarBuilder withDismiss() {
        SnackbarBuilder snackbarBuilder;
        SnackbarBuilder $this$withDismiss_u24lambda_u240 = snackbarBuilder = this;
        boolean bl = false;
        $this$withDismiss_u24lambda_u240.withDismiss = true;
        return snackbarBuilder;
    }

    @NotNull
    public SnackbarBuilder setFocusViewAfterDismiss(@NotNull View view) {
        SnackbarBuilder snackbarBuilder;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        SnackbarBuilder $this$setFocusViewAfterDismiss_u24lambda_u240 = snackbarBuilder = this;
        boolean bl = false;
        $this$setFocusViewAfterDismiss_u24lambda_u240.focusViewAfterDismiss = new WeakReference<View>(view);
        return snackbarBuilder;
    }

    @NotNull
    public SnackbarBuilder setForceRequestFocus() {
        SnackbarBuilder snackbarBuilder;
        SnackbarBuilder $this$setForceRequestFocus_u24lambda_u240 = snackbarBuilder = this;
        boolean bl = false;
        $this$setForceRequestFocus_u24lambda_u240.forceRequestFocus = true;
        return snackbarBuilder;
    }

    @JvmOverloads
    @NotNull
    public Snackbar showInformative(@NotNull SnackbarLength snackbarLength) {
        Intrinsics.checkNotNullParameter((Object)((Object)snackbarLength), (String)"snackbarLength");
        Spannable spannable = this.getSpannable(R.attr.colorTextPrimaryInverse);
        Snackbar snackbar = this.createSnackbar((CharSequence)spannable, snackbarLength);
        this.setBackgroundColor(snackbar, R.attr.colorFeedbackInfoBackground);
        this.setActionTextColor(snackbar, R.attr.colorTextLinkSnackbar);
        this.muteSnackbarAndForceRequestFocus(snackbar, snackbarLength);
        this.returnFocusToViewIfNeeded(snackbar, snackbarLength);
        snackbar.show();
        return snackbar;
    }

    public static /* synthetic */ Snackbar showInformative$default(SnackbarBuilder snackbarBuilder, SnackbarLength snackbarLength, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showInformative");
        }
        if ((n & 1) != 0) {
            snackbarLength = SnackbarLength.SHORT;
        }
        return snackbarBuilder.showInformative(snackbarLength);
    }

    @JvmOverloads
    @NotNull
    public Snackbar showCritical(@NotNull SnackbarLength snackbarLength) {
        Intrinsics.checkNotNullParameter((Object)((Object)snackbarLength), (String)"snackbarLength");
        Spannable spannable = this.getSpannable(R.attr.colorTextPrimaryInverse);
        Snackbar snackbar = this.createSnackbar((CharSequence)spannable, snackbarLength);
        this.setBackgroundColor(snackbar, R.attr.colorFeedbackErrorBackground);
        this.setActionTextColor(snackbar, R.attr.colorTextPrimaryInverse);
        this.interruptPreviousAccessibilityAnnouncement(snackbar);
        this.muteSnackbarAndForceRequestFocus(snackbar, snackbarLength);
        this.returnFocusToViewIfNeeded(snackbar, snackbarLength);
        snackbar.show();
        return snackbar;
    }

    public static /* synthetic */ Snackbar showCritical$default(SnackbarBuilder snackbarBuilder, SnackbarLength snackbarLength, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showCritical");
        }
        if ((n & 1) != 0) {
            snackbarLength = SnackbarLength.SHORT;
        }
        return snackbarBuilder.showCritical(snackbarLength);
    }

    private final void setActionTextColor(Snackbar snackbar, @AttrRes int colorRes) {
        CustomSnackbarLayout customSnackbarLayout = this.getCustomLayout(snackbar);
        Context context = this.view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        customSnackbarLayout.setActionTextColor(ColorUtilsKt.getThemeColor(context, colorRes));
    }

    private final void setBackgroundColor(Snackbar snackbar, @AttrRes int colorRes) {
        View view = snackbar.getView();
        Context context = this.view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        view.setBackgroundTintList(ColorStateList.valueOf((int)ColorUtilsKt.getThemeColor(context, colorRes)));
    }

    private final void muteSnackbarAndForceRequestFocus(Snackbar snackbar, SnackbarLength snackbarLength) {
        if (snackbarLength == SnackbarLength.INDEFINITE && this.forceRequestFocus) {
            snackbar.getView().setAccessibilityLiveRegion(0);
            snackbar.addCallback((BaseTransientBottomBar.BaseCallback)new BaseTransientBottomBar.BaseCallback<Snackbar>(){

                public void onShown(Snackbar snackbar) {
                    Intrinsics.checkNotNullParameter((Object)snackbar, (String)"snackbar");
                    snackbar.getView().sendAccessibilityEvent(8);
                }
            });
        }
    }

    private final void returnFocusToViewIfNeeded(Snackbar snackbar, SnackbarLength snackbarLength) {
        if (snackbarLength == SnackbarLength.INDEFINITE) {
            snackbar.addCallback((BaseTransientBottomBar.BaseCallback)new BaseTransientBottomBar.BaseCallback<Snackbar>(this){
                final /* synthetic */ SnackbarBuilder this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onDismissed(Snackbar transientBottomBar, int event) {
                    block0: {
                        super.onDismissed((Object)transientBottomBar, event);
                        WeakReference weakReference = SnackbarBuilder.access$getFocusViewAfterDismiss$p(this.this$0);
                        if (weakReference == null || (weakReference = (View)weakReference.get()) == null) break block0;
                        WeakReference view = weakReference;
                        boolean bl = false;
                        view.requestFocus();
                        view.sendAccessibilityEvent(8);
                    }
                }
            });
        }
    }

    private final void interruptPreviousAccessibilityAnnouncement(Snackbar snackbar) {
        snackbar.addCallback((BaseTransientBottomBar.BaseCallback)new BaseTransientBottomBar.BaseCallback<Snackbar>(this){
            final /* synthetic */ SnackbarBuilder this$0;
            {
                this.this$0 = $receiver;
            }

            public void onShown(Snackbar snackbar) {
                Intrinsics.checkNotNullParameter((Object)snackbar, (String)"snackbar");
                if (SnackbarBuilder.access$getAccessibilityManager$p(this.this$0).isEnabled()) {
                    SnackbarBuilder.access$getAccessibilityManager$p(this.this$0).interrupt();
                }
            }
        });
    }

    private final Spannable getSpannable(@AttrRes int colorRes) {
        Spannable spannable = (Spannable)new SpannableString(this.text);
        Context context = this.view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(ColorUtilsKt.getThemeColor(context, colorRes));
        spannable.setSpan((Object)foregroundColorSpan, 0, spannable.length(), 33);
        return spannable;
    }

    private final Snackbar createSnackbar(CharSequence text, SnackbarLength snackbarLength) {
        int duration = (SnackBarBehaviorConfig.areSticky() ? SnackbarLength.INDEFINITE : (this.isInvalidLengthWhenThereIsAction(snackbarLength) ? SnackbarLength.LONG : (this.isInvalidLengthWhenThereIsNoAction(snackbarLength) ? SnackbarLength.SHORT : snackbarLength))).duration();
        Snackbar snackbar = this.inflateCustomSnackbar(duration);
        this.getCustomLayout(snackbar).setText(text);
        this.setCustomAction(snackbar);
        this.showDismissActionIfNeeded(snackbar, snackbarLength == SnackbarLength.INDEFINITE);
        this.addCallbackIfNeeded(snackbar);
        this.setContentDescription(snackbar, text);
        return snackbar;
    }

    private final boolean isInvalidLengthWhenThereIsAction(SnackbarLength length) {
        return this.getHasAction() && length == SnackbarLength.SHORT;
    }

    private final boolean isInvalidLengthWhenThereIsNoAction(SnackbarLength length) {
        return !this.getHasAction() && length == SnackbarLength.LONG;
    }

    @SuppressLint(value={"ShowToast"})
    private final Snackbar inflateCustomSnackbar(int duration) {
        Snackbar snackbar = Snackbar.make((View)this.view, (CharSequence)"", (int)duration);
        Intrinsics.checkNotNullExpressionValue((Object)snackbar, (String)"make(...)");
        Snackbar snackbar2 = snackbar;
        View view = snackbar2.getView();
        Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.FrameLayout");
        FrameLayout snackbarLayout = (FrameLayout)view;
        snackbarLayout.removeAllViews();
        View customLayout = LayoutInflater.from((Context)snackbarLayout.getContext()).inflate(R.layout.snackbar_layout, (ViewGroup)snackbarLayout, false);
        snackbarLayout.addView(customLayout);
        return snackbar2;
    }

    private final void setCustomAction(Snackbar $this$setCustomAction) {
        block0: {
            String string2 = this.actionText;
            if (string2 == null) break block0;
            String text = string2;
            boolean bl = false;
            this.getCustomLayout($this$setCustomAction).setAction(text, this.actionContentDescription, arg_0 -> SnackbarBuilder.setCustomAction$lambda$0$0(this, $this$setCustomAction, arg_0));
        }
    }

    private final void dispatchDismissedByActionEvent(Snackbar $this$dispatchDismissedByActionEvent) {
        $this$dispatchDismissedByActionEvent.removeCallback((BaseTransientBottomBar.BaseCallback)this.callback);
        Snackbar.Callback callback = this.callback;
        if (callback != null) {
            callback.onDismissed($this$dispatchDismissedByActionEvent, 1);
        }
        $this$dispatchDismissedByActionEvent.dismiss();
    }

    private final CustomSnackbarLayout getCustomLayout(Snackbar $this$getCustomLayout) {
        View view = $this$getCustomLayout.getView().findViewById(R.id.custom_layout);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        return (CustomSnackbarLayout)view;
    }

    private final void showDismissActionIfNeeded(Snackbar $this$showDismissActionIfNeeded, boolean hasInfiniteDuration) {
        boolean userShouldBeAbleToDismissSnackbar;
        boolean bl = userShouldBeAbleToDismissSnackbar = !this.getHasAction() && hasInfiniteDuration;
        if (this.withDismiss || userShouldBeAbleToDismissSnackbar) {
            this.getCustomLayout($this$showDismissActionIfNeeded).setOnDismissClickListener((Function0<Unit>)((Function0)() -> SnackbarBuilder.showDismissActionIfNeeded$lambda$0($this$showDismissActionIfNeeded)));
        }
    }

    private final void addCallbackIfNeeded(Snackbar $this$addCallbackIfNeeded) {
        if (this.callback != null) {
            $this$addCallbackIfNeeded.addCallback((BaseTransientBottomBar.BaseCallback)this.callback);
        }
    }

    private final void setContentDescription(Snackbar $this$setContentDescription, CharSequence text) {
        this.getCustomLayout($this$setContentDescription).setContentDescription(text);
    }

    @JvmOverloads
    @NotNull
    public final Snackbar showInformative() {
        return SnackbarBuilder.showInformative$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Snackbar showCritical() {
        return SnackbarBuilder.showCritical$default(this, null, 1, null);
    }

    private static final void setCustomAction$lambda$0$0(SnackbarBuilder this$0, Snackbar $this_setCustomAction, View it) {
        View.OnClickListener onClickListener = this$0.actionListener;
        if (onClickListener != null) {
            onClickListener.onClick(it);
        }
        this$0.dispatchDismissedByActionEvent($this_setCustomAction);
    }

    private static final Unit showDismissActionIfNeeded$lambda$0(Snackbar $this_showDismissActionIfNeeded) {
        $this_showDismissActionIfNeeded.dismiss();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ WeakReference access$getFocusViewAfterDismiss$p(SnackbarBuilder $this) {
        return $this.focusViewAfterDismiss;
    }

    public static final /* synthetic */ AccessibilityManager access$getAccessibilityManager$p(SnackbarBuilder $this) {
        return $this.accessibilityManager;
    }
}

